/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.textual.Case;
import org.refcodes.textual.CaseStyleBuilder;
import org.refcodes.textual.CaseStyleBuilderImpl;

public class CaseStyleBuilderTest {
    private static Logger LOGGER = Logger.getLogger(CaseStyleBuilderTest.class);
    private static final String[] NAMES = new String[]{"mySystemProperty", "MY_SYSTEM_PROPERTY", "my_system_property", "My_System_Property", "My-System-Property", "_My-System-Property", "mySystemProperty__", "my___System--Property__"};
    private static final String SNAKE_CASE = "MY_SYSTEM_PROPERTY";
    private static final String SNAKE_LOWER = "my_system_property";
    private static final String KEBAB_CASE = "MY-SYSTEM-PROPERTY";
    private static final String KEBAB_LOWER = "my-system-property";
    private static final String CAMEL_CASE = "mySystemProperty";
    private static final String PASCAL_CASE = "MySystemProperty";

    @Test
    public void testPascalEdgeCase() {
        CaseStyleBuilderImpl theBuilder = new CaseStyleBuilderImpl();
        String thePascalCase = theBuilder.toPascalCase("a");
        Assertions.assertEquals((Object)"A", (Object)thePascalCase);
        thePascalCase = theBuilder.toPascalCase("a_a");
        Assertions.assertEquals((Object)"AA", (Object)thePascalCase);
        thePascalCase = theBuilder.toPascalCase("aa_aa_aa");
        Assertions.assertEquals((Object)"AaAaAa", (Object)thePascalCase);
        thePascalCase = theBuilder.toPascalCase("a_____");
        Assertions.assertEquals((Object)"A", (Object)thePascalCase);
        thePascalCase = theBuilder.toPascalCase("aA");
        Assertions.assertEquals((Object)"AA", (Object)thePascalCase);
        thePascalCase = theBuilder.toPascalCase("aa");
        Assertions.assertEquals((Object)"Aa", (Object)thePascalCase);
    }

    @Test
    public void testSnakeCase() {
        CaseStyleBuilderImpl theBuilder = new CaseStyleBuilderImpl();
        for (String eText : NAMES) {
            LOGGER.info((Object)theBuilder.toSnakeCase(eText));
            Assertions.assertEquals((Object)SNAKE_CASE, (Object)theBuilder.toSnakeCase(eText));
        }
    }

    @Test
    public void testSnakeCaseWithState() {
        CaseStyleBuilderImpl theBuilder = new CaseStyleBuilderImpl();
        for (String eText : NAMES) {
            LOGGER.info((Object)((CaseStyleBuilder)theBuilder.withText(eText)).toSnakeCase());
            Assertions.assertEquals((Object)SNAKE_CASE, (Object)((CaseStyleBuilder)theBuilder.withText(eText)).toSnakeCase());
        }
    }

    @Test
    public void testSnakeLower() {
        CaseStyleBuilder theBuilder = new CaseStyleBuilderImpl().withCase(Case.LOWER);
        for (String eText : NAMES) {
            LOGGER.info((Object)theBuilder.toSnakeCase(eText));
            Assertions.assertEquals((Object)SNAKE_LOWER, (Object)theBuilder.toSnakeCase(eText));
        }
    }

    @Test
    public void testSnakeLowerWithState() {
        CaseStyleBuilder theBuilder = new CaseStyleBuilderImpl().withCase(Case.LOWER);
        for (String eText : NAMES) {
            LOGGER.info((Object)((CaseStyleBuilder)theBuilder.withText(eText)).toSnakeCase());
            Assertions.assertEquals((Object)SNAKE_LOWER, (Object)((CaseStyleBuilder)theBuilder.withText(eText)).toSnakeCase());
        }
    }

    @Test
    public void testKebabCase() {
        CaseStyleBuilderImpl theBuilder = new CaseStyleBuilderImpl();
        for (String eText : NAMES) {
            LOGGER.info((Object)theBuilder.toKebabCase(eText));
            Assertions.assertEquals((Object)KEBAB_CASE, (Object)theBuilder.toKebabCase(eText));
        }
    }

    @Test
    public void testKebabCaseWithState() {
        CaseStyleBuilderImpl theBuilder = new CaseStyleBuilderImpl();
        for (String eText : NAMES) {
            LOGGER.info((Object)((CaseStyleBuilder)theBuilder.withText(eText)).toKebabCase());
            Assertions.assertEquals((Object)KEBAB_CASE, (Object)((CaseStyleBuilder)theBuilder.withText(eText)).toKebabCase());
        }
    }

    @Test
    public void testKebabLower() {
        CaseStyleBuilder theBuilder = new CaseStyleBuilderImpl().withCase(Case.LOWER);
        for (String eText : NAMES) {
            LOGGER.info((Object)theBuilder.toKebabCase(eText));
            Assertions.assertEquals((Object)KEBAB_LOWER, (Object)theBuilder.toKebabCase(eText));
        }
    }

    @Test
    public void testKebabLowerWithState() {
        CaseStyleBuilder theBuilder = new CaseStyleBuilderImpl().withCase(Case.LOWER);
        for (String eText : NAMES) {
            LOGGER.info((Object)((CaseStyleBuilder)theBuilder.withText(eText)).toKebabCase());
            Assertions.assertEquals((Object)KEBAB_LOWER, (Object)((CaseStyleBuilder)theBuilder.withText(eText)).toKebabCase());
        }
    }

    @Test
    public void testCamelCase() {
        CaseStyleBuilderImpl theBuilder = new CaseStyleBuilderImpl();
        for (String eText : NAMES) {
            LOGGER.info((Object)theBuilder.toCamelCase(eText));
            Assertions.assertEquals((Object)CAMEL_CASE, (Object)theBuilder.toCamelCase(eText));
        }
    }

    @Test
    public void testCamelCaseWithState() {
        CaseStyleBuilderImpl theBuilder = new CaseStyleBuilderImpl();
        for (String eText : NAMES) {
            LOGGER.info((Object)((CaseStyleBuilder)theBuilder.withText(eText)).toCamelCase());
            Assertions.assertEquals((Object)CAMEL_CASE, (Object)((CaseStyleBuilder)theBuilder.withText(eText)).toCamelCase());
        }
    }

    @Test
    public void testPascalCase() {
        CaseStyleBuilderImpl theBuilder = new CaseStyleBuilderImpl();
        for (String eText : NAMES) {
            LOGGER.info((Object)theBuilder.toPascalCase(eText));
            Assertions.assertEquals((Object)PASCAL_CASE, (Object)theBuilder.toPascalCase(eText));
        }
    }

    @Test
    public void testPascalCaseWithState() {
        CaseStyleBuilderImpl theBuilder = new CaseStyleBuilderImpl();
        for (String eText : NAMES) {
            LOGGER.info((Object)((CaseStyleBuilder)theBuilder.withText(eText)).toPascalCase());
            Assertions.assertEquals((Object)PASCAL_CASE, (Object)((CaseStyleBuilder)theBuilder.withText(eText)).toPascalCase());
        }
    }
}

