/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.textual.CaseStyle;

public class CaseStyleTest {
    private static Logger LOGGER = Logger.getLogger(CaseStyleTest.class);
    private static String[] INPUT = new String[]{"_caseStyle", "CASE_STYLE", "CASE#STYLE", "case style", "CASE _style"};

    @Test
    public void testNone() {
        for (String eName : INPUT) {
            CaseStyle theStyle = CaseStyle.NONE;
            LOGGER.info((Object)(eName + " := " + theStyle.toCaseStyle(eName)));
            Assertions.assertEquals((Object)eName, (Object)theStyle.toCaseStyle(eName));
        }
    }

    @Test
    public void testCamelCase() {
        for (String eName : INPUT) {
            CaseStyle theStyle = CaseStyle.CAMEL_CASE;
            LOGGER.info((Object)(eName + " := " + theStyle.toCaseStyle(eName)));
            Assertions.assertEquals((Object)"caseStyle", (Object)theStyle.toCaseStyle(eName));
        }
    }

    @Test
    public void testPascalCase() {
        for (String eName : INPUT) {
            CaseStyle theStyle = CaseStyle.PASCAL_CASE;
            LOGGER.info((Object)(eName + " := " + theStyle.toCaseStyle(eName)));
            Assertions.assertEquals((Object)"CaseStyle", (Object)theStyle.toCaseStyle(eName));
        }
    }

    @Test
    public void testSnakeCase() {
        for (String eName : INPUT) {
            CaseStyle thsStyle = CaseStyle.SNAKE_CASE;
            LOGGER.info((Object)(eName + " := " + thsStyle.toCaseStyle(eName)));
            Assertions.assertEquals((Object)"case_style", (Object)thsStyle.toCaseStyle(eName));
        }
    }

    @Test
    public void testSnakeUpperCase() {
        for (String eName : INPUT) {
            CaseStyle thsStyle = CaseStyle.SNAKE_UPPER_CASE;
            LOGGER.info((Object)(eName + " := " + thsStyle.toCaseStyle(eName)));
            Assertions.assertEquals((Object)"CASE_STYLE", (Object)thsStyle.toCaseStyle(eName));
        }
    }

    @Test
    public void testKebabCase() {
        for (String eName : INPUT) {
            CaseStyle thsStyle = CaseStyle.KEBAB_CASE;
            LOGGER.info((Object)(eName + " := " + thsStyle.toCaseStyle(eName)));
            Assertions.assertEquals((Object)"case-style", (Object)thsStyle.toCaseStyle(eName));
        }
    }

    @Test
    public void testKebabUpperCase() {
        for (String eName : INPUT) {
            CaseStyle thsStyle = CaseStyle.KEBAB_UPPER_CASE;
            LOGGER.info((Object)(eName + " := " + thsStyle.toCaseStyle(eName)));
            Assertions.assertEquals((Object)"CASE-STYLE", (Object)thsStyle.toCaseStyle(eName));
        }
    }
}

