/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.time.Instant;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.ConsoleDimension;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.RuntimeUtility;
import org.refcodes.textual.ColumnWidthMetrics;
import org.refcodes.textual.ColumnWidthMetricsImpl;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextBuilderImpl;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.MoreTextMode;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextGenerartorImpl;
import org.refcodes.textual.RandomTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableBuilderImpl;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.VerboseTextBuilderImpl;
import org.refcodes.time.DateFormat;

public class TableBuilderTest {
    private static Logger LOGGER = Logger.getLogger(TableBuilderTest.class);

    @Test
    public void testToHeader() {
        TableBuilderImpl theTablePrinter = new TableBuilderImpl();
        theTablePrinter.addColumn().withColumnWidth(25, ColumnWidthType.RELATIVE);
        theTablePrinter.addColumn().withColumnWidth(33, ColumnWidthType.RELATIVE);
        theTablePrinter.addColumn().withColumnWidth(50, ColumnWidthType.RELATIVE).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT);
        theTablePrinter.addColumn().withColumnWidth(33, ColumnWidthType.RELATIVE);
        System.out.print(theTablePrinter.toHeader(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"}));
        System.out.print(theTablePrinter.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        theTablePrinter.withTableStyle(TableStyle.ASCII);
        System.out.print(theTablePrinter.toHeader(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"}));
        System.out.print(theTablePrinter.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        theTablePrinter.withTableStyle(TableStyle.SINGLE_DOUBLE);
        System.out.print(theTablePrinter.toHeader(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"}));
        System.out.print(theTablePrinter.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        theTablePrinter.withTableStyle(TableStyle.SINGLE);
        System.out.print(theTablePrinter.toHeader(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"}));
        System.out.print(theTablePrinter.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        theTablePrinter.withTableStyle(TableStyle.DOUBLE);
        System.out.print(theTablePrinter.toHeader(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"}));
        System.out.print(theTablePrinter.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        theTablePrinter.withTableStyle(TableStyle.SINGLE_DOUBLE);
        System.out.print(theTablePrinter.toHeaderBegin());
        System.out.print(theTablePrinter.toHeaderContinue(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"}));
        System.out.print(theTablePrinter.toHeaderContinue(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"}));
        System.out.print(theTablePrinter.toHeaderContinue(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"}));
        System.out.print(theTablePrinter.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinter.toRowContinue(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinter.toRowContinue(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinter.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinter.toRowContinue(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        theTablePrinter.withTableStyle(TableStyle.SINGLE_DOUBLE).withTextEscapeCode(AnsiEscapeCode.FG_WHITE_BRIGHT_BG_RED.getCode());
        System.out.print(theTablePrinter.toHeader(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"}));
        System.out.print(theTablePrinter.toRowBegin());
        System.out.print(theTablePrinter.toRowContinue(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinter.toRowContinue(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinter.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinter.toRowContinue(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinter.toTail());
    }

    @Test
    public void testJoinTables() {
        TableBuilder theTablePrinterA = new TableBuilderImpl().withRowWidth(ConsoleDimension.MIN_WIDTH.getValue().intValue());
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        TableBuilder theTablePrinterB = new TableBuilderImpl().withRowWidth(ConsoleDimension.MIN_WIDTH.getValue().intValue());
        theTablePrinterB.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(2, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(3, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(4, ColumnWidthType.RELATIVE);
        TableBuilder theTablePrinterC = new TableBuilderImpl().withRowWidth(ConsoleDimension.MIN_WIDTH.getValue().intValue());
        theTablePrinterC.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(2, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(4, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(3, ColumnWidthType.RELATIVE);
        theTablePrinterA.withTableStyle(TableStyle.SINGLE_DOUBLE);
        theTablePrinterB.withTableStyle(TableStyle.SINGLE_DOUBLE);
        theTablePrinterC.withTableStyle(TableStyle.SINGLE_DOUBLE);
        System.out.print(theTablePrinterA.toHeader(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"}));
        System.out.print(theTablePrinterA.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinterB.toRowEnd(theTablePrinterA));
        System.out.print(theTablePrinterB.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinterC.toRowEnd(theTablePrinterB));
        System.out.print(theTablePrinterC.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        ((TableBuilder)theTablePrinterB.withRowWidth(ConsoleDimension.MAX_WIDTH.getValue().intValue())).addColumn().withColumnWidth(79, ColumnWidthType.ABSOLUTE).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT);
        System.out.print(theTablePrinterB.toRowEnd(theTablePrinterC));
        System.out.print(theTablePrinterB.toRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinterB.toRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinterC.toRowEnd(theTablePrinterB));
        System.out.print(theTablePrinterC.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinterC.toRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        theTablePrinterB.withRowWidth(ConsoleDimension.NORM_WIDTH.getValue().intValue());
        System.out.print(theTablePrinterB.toRowEnd(theTablePrinterC));
        System.out.print(theTablePrinterB.toRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinterB.toRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"}));
        System.out.print(theTablePrinterB.toTail());
        System.out.println();
    }

    @Test
    public void testPrintTables() {
        TableBuilder theTablePrinterA = new TableBuilderImpl().withRowWidth(ConsoleDimension.MIN_WIDTH.getValue().intValue());
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        TableBuilder theTablePrinterB = new TableBuilderImpl().withRowWidth(ConsoleDimension.NORM_WIDTH.getValue().intValue());
        theTablePrinterB.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(2, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(3, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(4, ColumnWidthType.RELATIVE);
        TableBuilder theTablePrinterC = new TableBuilderImpl().withRowWidth(ConsoleDimension.MIN_WIDTH.getValue().intValue());
        theTablePrinterC.addColumn().withColumnWidth(3, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(2, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(4, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(3, ColumnWidthType.RELATIVE);
        theTablePrinterA.withTableStyle(TableStyle.SINGLE_DOUBLE);
        theTablePrinterB.withTableStyle(TableStyle.SINGLE_DOUBLE);
        theTablePrinterC.withTableStyle(TableStyle.SINGLE_DOUBLE);
        theTablePrinterA.printHeader(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"});
        theTablePrinterA.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.printRowEnd(theTablePrinterA);
        theTablePrinterB.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRowEnd(theTablePrinterB);
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        ((TableBuilder)theTablePrinterB.withRowWidth(ConsoleDimension.NORM_WIDTH.getValue().intValue())).addColumn().withColumnWidth(30, ColumnWidthType.ABSOLUTE);
        theTablePrinterB.printRowEnd(theTablePrinterC);
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRowEnd(theTablePrinterB);
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.withRowWidth(ConsoleDimension.NORM_WIDTH.getValue() / 2);
        theTablePrinterB.printRowEnd(theTablePrinterC);
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.withBorderEscapeCode(AnsiEscapeCode.FG_BLUE_BRIGHT.getCode());
        theTablePrinterC.withRowWidth(ConsoleDimension.NORM_WIDTH.getValue() / 2);
        theTablePrinterC.printRowEnd(theTablePrinterB);
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printTail();
        System.out.println();
    }

    @Test
    public void testPrintSingleBlankTables() {
        TableBuilder theTablePrinterA = new TableBuilderImpl().withRowWidth(ConsoleDimension.MIN_WIDTH.getValue().intValue()).withLeftBorder(false).withRightBorder(false).withTableStyle(TableStyle.SINGLE_BLANK);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        TableBuilder theTablePrinterB = new TableBuilderImpl().withRowWidth(ConsoleDimension.NORM_WIDTH.getValue().intValue()).withLeftBorder(false).withRightBorder(false).withTableStyle(TableStyle.SINGLE_BLANK);
        theTablePrinterB.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(2, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(3, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(4, ColumnWidthType.RELATIVE);
        TableBuilder theTablePrinterC = new TableBuilderImpl().withRowWidth(ConsoleDimension.MIN_WIDTH.getValue().intValue()).withLeftBorder(false).withRightBorder(false).withTableStyle(TableStyle.SINGLE_BLANK);
        theTablePrinterC.addColumn().withColumnWidth(3, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(2, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(4, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(3, ColumnWidthType.RELATIVE);
        theTablePrinterA.printHeader(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"});
        theTablePrinterA.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.printRowEnd(theTablePrinterA);
        theTablePrinterB.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRowEnd(theTablePrinterB);
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        ((TableBuilder)theTablePrinterB.withRowWidth(ConsoleDimension.NORM_WIDTH.getValue().intValue())).addColumn().withColumnWidth(30, ColumnWidthType.ABSOLUTE);
        theTablePrinterB.printRowEnd(theTablePrinterC);
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRowEnd(theTablePrinterB);
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.withRowWidth(ConsoleDimension.NORM_WIDTH.getValue() / 2);
        theTablePrinterB.printRowEnd(theTablePrinterC);
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.withBorderEscapeCode(AnsiEscapeCode.FG_BLUE_BRIGHT.getCode());
        theTablePrinterC.withRowWidth(ConsoleDimension.NORM_WIDTH.getValue() / 2);
        theTablePrinterC.printRowEnd(theTablePrinterB);
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printTail();
        System.out.println();
    }

    @Test
    public void testPrintAsciiBlankTables() {
        TableBuilder theTablePrinterA = new TableBuilderImpl().withRowWidth(ConsoleDimension.MIN_WIDTH.getValue().intValue()).withLeftBorder(false).withRightBorder(false).withTableStyle(TableStyle.ASCII_BLANK);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterA.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        TableBuilder theTablePrinterB = new TableBuilderImpl().withRowWidth(ConsoleDimension.NORM_WIDTH.getValue().intValue()).withLeftBorder(false).withRightBorder(false).withTableStyle(TableStyle.ASCII_BLANK);
        theTablePrinterB.addColumn().withColumnWidth(1, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(2, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(3, ColumnWidthType.RELATIVE);
        theTablePrinterB.addColumn().withColumnWidth(4, ColumnWidthType.RELATIVE);
        TableBuilder theTablePrinterC = new TableBuilderImpl().withRowWidth(ConsoleDimension.MIN_WIDTH.getValue().intValue()).withLeftBorder(false).withRightBorder(false).withTableStyle(TableStyle.ASCII_BLANK);
        theTablePrinterC.addColumn().withColumnWidth(3, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(2, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(4, ColumnWidthType.RELATIVE);
        theTablePrinterC.addColumn().withColumnWidth(3, ColumnWidthType.RELATIVE);
        theTablePrinterA.printHeader(new String[]{"AAAAA", "BBBBB", "CCCCC", "DDDDD"});
        theTablePrinterA.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.printRowEnd(theTablePrinterA);
        theTablePrinterB.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRowEnd(theTablePrinterB);
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        ((TableBuilder)theTablePrinterB.withRowWidth(ConsoleDimension.NORM_WIDTH.getValue().intValue())).addColumn().withColumnWidth(30, ColumnWidthType.ABSOLUTE);
        theTablePrinterB.printRowEnd(theTablePrinterC);
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRowEnd(theTablePrinterB);
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.withRowWidth(ConsoleDimension.NORM_WIDTH.getValue() / 2);
        theTablePrinterB.printRowEnd(theTablePrinterC);
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterB.printRow(new String[]{"ATARI", "XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.withBorderEscapeCode(AnsiEscapeCode.FG_BLUE_BRIGHT.getCode());
        theTablePrinterC.withRowWidth(ConsoleDimension.NORM_WIDTH.getValue() / 2);
        theTablePrinterC.printRowEnd(theTablePrinterB);
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printRow(new String[]{"XX XX XX", "YY YY YY", "ZZ ZZ ZZ", "QQ QQ QQ"});
        theTablePrinterC.printTail();
        System.out.println();
    }

    @Test
    public void testAnsiLoggerTable() {
        RandomTextGenerartor theRndTextGenerator = new RandomTextGenerartorImpl().withColumnWidth(128).withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        TableBuilderImpl theTablePrinter = new TableBuilderImpl();
        theTablePrinter.addColumn().withColumnWidth(7, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_DEFAULT_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT);
        theTablePrinter.addColumn().withColumnWidth(7, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_GREEN_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.CENTER);
        theTablePrinter.addColumn().withColumnWidth(10, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_WHITE_BRIGHT_BG_RED.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        theTablePrinter.addColumn().withColumnWidth(19, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_DEFAULT_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT);
        theTablePrinter.addColumn().withColumnWidth(16, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_BLUE_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        theTablePrinter.addColumn().withColumnWidth(22, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_BLUE_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        theTablePrinter.addColumn().withColumnWidth(45, ColumnWidthType.RELATIVE).withTextColumnEscapeCode(AnsiEscapeCode.FG_GREEN_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        theTablePrinter.addColumn().withColumnWidth(55, ColumnWidthType.RELATIVE).withTextColumnEscapeCode(AnsiEscapeCode.FG_BLUE_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        if (theTablePrinter.getRowWidth() < 160) {
            theTablePrinter.withRowWidth(160);
        }
        for (int i = 0; i < 25; ++i) {
            theTablePrinter.printRow(new String[]{((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(HorizAlignTextMode.RIGHT).withText(new String[]{"" + i})).withColumnWidth(7)).withFillChar('0').toString(), "INFO", "Thread-" + i, DateFormat.NORM_DATE_FORMAT.getFormatter().format(Instant.now()), RuntimeUtility.getCallerStackTraceElement().getMethodName(), RuntimeUtility.getCallerStackTraceElement().getClassName(), (String)theRndTextGenerator.next(), ""});
        }
        theTablePrinter.printTail();
    }

    @Test
    public void testLoggerTable() {
        RandomTextGenerartor theRndTextGenerator = new RandomTextGenerartorImpl().withColumnWidth(128).withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        TableBuilderImpl theTablePrinter = new TableBuilderImpl();
        theTablePrinter.addColumn().withColumnWidth(7, ColumnWidthType.ABSOLUTE).withColumnHorizAlignTextMode(HorizAlignTextMode.CENTER);
        theTablePrinter.addColumn().withColumnWidth(7, ColumnWidthType.ABSOLUTE).withColumnHorizAlignTextMode(HorizAlignTextMode.CENTER);
        theTablePrinter.addColumn().withColumnWidth(10, ColumnWidthType.ABSOLUTE).withColumnHorizAlignTextMode(HorizAlignTextMode.CENTER);
        theTablePrinter.addColumn().withColumnWidth(19, ColumnWidthType.ABSOLUTE).withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT);
        theTablePrinter.addColumn().withColumnWidth(16, ColumnWidthType.ABSOLUTE).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        theTablePrinter.addColumn().withColumnWidth(22, ColumnWidthType.ABSOLUTE).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        theTablePrinter.addColumn().withColumnWidth(45, ColumnWidthType.RELATIVE).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        theTablePrinter.addColumn().withColumnWidth(55, ColumnWidthType.RELATIVE).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        if (theTablePrinter.getRowWidth() < 160) {
            theTablePrinter.withRowWidth(160);
        }
        for (int i = 0; i < 25; ++i) {
            theTablePrinter.printRow(new String[]{((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(HorizAlignTextMode.RIGHT).withText(new String[]{"" + i})).withColumnWidth(7)).withFillChar('0').toString(), "INFO", "Thread-" + i, DateFormat.NORM_DATE_FORMAT.getFormatter().format(Instant.now()), RuntimeUtility.getCallerStackTraceElement().getMethodName(), RuntimeUtility.getCallerStackTraceElement().getClassName(), (String)theRndTextGenerator.next(), ""});
        }
        theTablePrinter.printTail();
    }

    @Test
    public void testMoreLoggerTable() {
        RandomTextGenerartor theRndTextGenerator = new RandomTextGenerartorImpl().withColumnWidth(128).withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        TableBuilder theTablePrinter = new TableBuilderImpl().withMoreTextMode(MoreTextMode.CENTER);
        theTablePrinter.addColumn().withColumnWidth(7, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_DEFAULT_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT);
        theTablePrinter.addColumn().withColumnWidth(7, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_GREEN_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.CENTER);
        theTablePrinter.addColumn().withColumnWidth(10, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_WHITE_BRIGHT_BG_RED.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        theTablePrinter.addColumn().withColumnWidth(19, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_DEFAULT_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT);
        theTablePrinter.addColumn().withColumnWidth(16, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_BLUE_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        theTablePrinter.addColumn().withColumnWidth(22, ColumnWidthType.ABSOLUTE).withTextColumnEscapeCode(AnsiEscapeCode.FG_BLUE_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        theTablePrinter.addColumn().withColumnWidth(45, ColumnWidthType.RELATIVE).withTextColumnEscapeCode(AnsiEscapeCode.FG_GREEN_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        theTablePrinter.addColumn().withColumnWidth(55, ColumnWidthType.RELATIVE).withTextColumnEscapeCode(AnsiEscapeCode.FG_BLUE_BRIGHT.getCode()).withColumnHorizAlignTextMode(HorizAlignTextMode.LEFT);
        if (theTablePrinter.getRowWidth() < 160) {
            theTablePrinter.withRowWidth(160);
        }
        theTablePrinter.printRowBegin();
        for (int i = 0; i < 25; ++i) {
            theTablePrinter.printRowContinue(new String[]{((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(HorizAlignTextMode.RIGHT).withText(new String[]{"" + i})).withColumnWidth(7)).withFillChar('0').toString(), "INFO", "Thread-" + i, DateFormat.NORM_DATE_FORMAT.getFormatter().format(Instant.now()), RuntimeUtility.getCallerStackTraceElement().getMethodName(), RuntimeUtility.getCallerStackTraceElement().getClassName(), (String)theRndTextGenerator.next(), ""});
        }
        theTablePrinter.printTail();
    }

    @Test
    public void toGoodColumnNumCharWidths() {
        Object[] theColumnWidths = new ColumnWidthMetricsImpl[]{new ColumnWidthMetricsImpl(1, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(50, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(2, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(25, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(4, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(8, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(25, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(16, ColumnWidthType.ABSOLUTE)};
        LOGGER.info((Object)("Provided column widths = " + new VerboseTextBuilderImpl().withElements(theColumnWidths).toString()));
        int[] theNumChars = this.testColumnWidths(63, (ColumnWidthMetricsImpl[])theColumnWidths);
        Assertions.assertEquals((int)theNumChars[0], (int)1);
        Assertions.assertEquals((int)theNumChars[1], (int)16);
        Assertions.assertEquals((int)theNumChars[2], (int)2);
        Assertions.assertEquals((int)theNumChars[3], (int)8);
        Assertions.assertEquals((int)theNumChars[4], (int)4);
        Assertions.assertEquals((int)theNumChars[5], (int)8);
        Assertions.assertEquals((int)theNumChars[6], (int)8);
        Assertions.assertEquals((int)theNumChars[7], (int)16);
        theNumChars = this.testColumnWidths(64, (ColumnWidthMetricsImpl[])theColumnWidths);
        Assertions.assertEquals((int)theNumChars[0], (int)1);
        Assertions.assertEquals((int)theNumChars[1], (int)17);
        Assertions.assertEquals((int)theNumChars[2], (int)2);
        Assertions.assertEquals((int)theNumChars[3], (int)8);
        Assertions.assertEquals((int)theNumChars[4], (int)4);
        Assertions.assertEquals((int)theNumChars[5], (int)8);
        Assertions.assertEquals((int)theNumChars[6], (int)8);
        Assertions.assertEquals((int)theNumChars[7], (int)16);
        theNumChars = this.testColumnWidths(65, (ColumnWidthMetricsImpl[])theColumnWidths);
        Assertions.assertEquals((int)theNumChars[0], (int)1);
        Assertions.assertEquals((int)theNumChars[1], (int)18);
        Assertions.assertEquals((int)theNumChars[2], (int)2);
        Assertions.assertEquals((int)theNumChars[3], (int)8);
        Assertions.assertEquals((int)theNumChars[4], (int)4);
        Assertions.assertEquals((int)theNumChars[5], (int)8);
        Assertions.assertEquals((int)theNumChars[6], (int)8);
        Assertions.assertEquals((int)theNumChars[7], (int)16);
        theNumChars = this.testColumnWidths(66, (ColumnWidthMetricsImpl[])theColumnWidths);
        Assertions.assertEquals((int)theNumChars[0], (int)1);
        Assertions.assertEquals((int)theNumChars[1], (int)18);
        Assertions.assertEquals((int)theNumChars[2], (int)2);
        Assertions.assertEquals((int)theNumChars[3], (int)9);
        Assertions.assertEquals((int)theNumChars[4], (int)4);
        Assertions.assertEquals((int)theNumChars[5], (int)8);
        Assertions.assertEquals((int)theNumChars[6], (int)8);
        Assertions.assertEquals((int)theNumChars[7], (int)16);
        theNumChars = this.testColumnWidths(67, (ColumnWidthMetricsImpl[])theColumnWidths);
        Assertions.assertEquals((int)theNumChars[0], (int)1);
        Assertions.assertEquals((int)theNumChars[1], (int)18);
        Assertions.assertEquals((int)theNumChars[2], (int)2);
        Assertions.assertEquals((int)theNumChars[3], (int)9);
        Assertions.assertEquals((int)theNumChars[4], (int)4);
        Assertions.assertEquals((int)theNumChars[5], (int)8);
        Assertions.assertEquals((int)theNumChars[6], (int)9);
        Assertions.assertEquals((int)theNumChars[7], (int)16);
    }

    private int[] testColumnWidths(int aTotalWidth, ColumnWidthMetricsImpl[] aColumnWidths) {
        int[] theNumChars = TableBuilderImpl.toColumnWidths((int)aTotalWidth, (ColumnWidthMetrics[])aColumnWidths);
        this.toOut(theNumChars);
        Assertions.assertEquals((int)aTotalWidth, (int)NumericalUtility.sum((int[])theNumChars));
        Assertions.assertEquals((int)aColumnWidths.length, (int)theNumChars.length);
        for (int i = 0; i < theNumChars.length; ++i) {
            if (aColumnWidths[i].getColumnWidthType() != ColumnWidthType.ABSOLUTE) continue;
            Assertions.assertEquals((int)aColumnWidths[i].getColumnWidth(), (int)theNumChars[i]);
        }
        return theNumChars;
    }

    @Test
    public void toOddColumnNumCharWidths() {
        Object[] theColumnWidths = new ColumnWidthMetricsImpl[]{new ColumnWidthMetricsImpl(1, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(50, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(2, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(25, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(4, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(8, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(26, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(16, ColumnWidthType.ABSOLUTE)};
        LOGGER.info((Object)("Provided column widths = " + new VerboseTextBuilderImpl().withElements(theColumnWidths).toString()));
        try {
            TableBuilderImpl.toColumnWidths((int)63, (ColumnWidthMetrics[])theColumnWidths);
        }
        catch (IllegalArgumentException e) {
            LOGGER.info((Object)("Expected exception: " + e.getMessage()));
        }
        theColumnWidths = new ColumnWidthMetricsImpl[]{new ColumnWidthMetricsImpl(1, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(2, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(4, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(8, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(16, ColumnWidthType.ABSOLUTE)};
        LOGGER.info((Object)("Provided column widths = " + new VerboseTextBuilderImpl().withElements(theColumnWidths).toString()));
        try {
            TableBuilderImpl.toColumnWidths((int)62, (ColumnWidthMetrics[])theColumnWidths);
            Assertions.fail((String)"Expected this test to fail as we provided more than 63 chars width");
        }
        catch (IllegalArgumentException e) {
            LOGGER.info((Object)("Expected exception: " + e.getMessage()));
        }
        theColumnWidths = new ColumnWidthMetricsImpl[]{new ColumnWidthMetricsImpl(1, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(2, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(4, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(8, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(16, ColumnWidthType.ABSOLUTE)};
        LOGGER.info((Object)("Provided column widths = " + new VerboseTextBuilderImpl().withElements(theColumnWidths).toString()));
        try {
            TableBuilderImpl.toColumnWidths((int)30, (ColumnWidthMetrics[])theColumnWidths);
            Assertions.fail((String)"Expected this test to fail as we provided more than 63 chars width");
        }
        catch (IllegalArgumentException e) {
            LOGGER.info((Object)("Expected exception: " + e.getMessage()));
        }
    }

    @Test
    public void toUglyColumnNumCharWidths() {
        Object[] theColumnWidths = new ColumnWidthMetricsImpl[]{new ColumnWidthMetricsImpl(1, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(0, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(2, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(50, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(4, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(8, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(50, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(16, ColumnWidthType.ABSOLUTE)};
        LOGGER.info((Object)("Provided column widths = " + new VerboseTextBuilderImpl().withElements(theColumnWidths).toString()));
        int[] theNumChars = TableBuilderImpl.toColumnWidths((int)63, (ColumnWidthMetrics[])theColumnWidths);
        this.toOut(theNumChars);
        Assertions.assertEquals((int)theNumChars[0], (int)1);
        Assertions.assertEquals((int)theNumChars[1], (int)0);
        Assertions.assertEquals((int)theNumChars[2], (int)2);
        Assertions.assertEquals((int)theNumChars[3], (int)16);
        Assertions.assertEquals((int)theNumChars[4], (int)4);
        Assertions.assertEquals((int)theNumChars[5], (int)8);
        Assertions.assertEquals((int)theNumChars[6], (int)16);
        Assertions.assertEquals((int)theNumChars[7], (int)16);
        theColumnWidths = new ColumnWidthMetricsImpl[]{new ColumnWidthMetricsImpl(0, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(50, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(2, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(25, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(4, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(8, ColumnWidthType.ABSOLUTE), new ColumnWidthMetricsImpl(25, ColumnWidthType.RELATIVE), new ColumnWidthMetricsImpl(16, ColumnWidthType.ABSOLUTE)};
        LOGGER.info((Object)("Provided column widths = " + new VerboseTextBuilderImpl().withElements(theColumnWidths).toString()));
        theNumChars = TableBuilderImpl.toColumnWidths((int)63, (ColumnWidthMetrics[])theColumnWidths);
        this.toOut(theNumChars);
        Assertions.assertEquals((int)theNumChars[0], (int)0);
        Assertions.assertEquals((int)theNumChars[1], (int)17);
        Assertions.assertEquals((int)theNumChars[2], (int)2);
        Assertions.assertEquals((int)theNumChars[3], (int)8);
        Assertions.assertEquals((int)theNumChars[4], (int)4);
        Assertions.assertEquals((int)theNumChars[5], (int)8);
        Assertions.assertEquals((int)theNumChars[6], (int)8);
        Assertions.assertEquals((int)theNumChars[7], (int)16);
    }

    @Test
    public void testExampleBuilder() {
        SysRecord[] someSysRecords = new SysRecord[]{this.toRandomSysRecord(), this.toRandomSysRecord(), this.toRandomSysRecord(), this.toRandomSysRecord(), this.toRandomSysRecord()};
        TableBuilder theTableBuilder = new TableBuilderImpl().withRowWidth(80).withTableStyle(TableStyle.SINGLE_DASHED).addColumn().addColumn().withRowColumnHorizAlignTextMode(HorizAlignTextMode.CENTER).withColumnWidth(6).addColumn().withColumnWidth(14).addColumn().withColumnWidth(10).withRowColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT).addColumn().withColumnWidth(4).withRowColumnHorizAlignTextMode(HorizAlignTextMode.CENTER).addColumn().withColumnWidth(9).withRowColumnHorizAlignTextMode(HorizAlignTextMode.RIGHT);
        theTableBuilder.printHeader(new String[]{"SYSTEM-NAME", "ID", "LOCATION", "LOAD", "T", "MEM"});
        for (SysRecord eSysRecord : someSysRecords) {
            theTableBuilder.printRow(new String[]{eSysRecord.getName(), eSysRecord.getId(), eSysRecord.getLocation(), eSysRecord.getLoadKbS() + " KB/s", eSysRecord.getThreads(), eSysRecord.getMemoryMb() + " MB"});
        }
        theTableBuilder.printTail();
    }

    private SysRecord toRandomSysRecord() {
        RandomTextGenerartorImpl theTextGenerator = new RandomTextGenerartorImpl();
        return new SysRecord((String)((RandomTextGenerartor)theTextGenerator.withColumnWidth(8)).withRandomTextMode(RandomTextMode.UPPER_CASE).next(), (String)((RandomTextGenerartor)theTextGenerator.withColumnWidth(4)).withRandomTextMode(RandomTextMode.NUMERIC).next(), (String)((RandomTextGenerartor)theTextGenerator.withColumnWidth(12)).withRandomTextMode(RandomTextMode.LOWER_CASE).next(), (String)((RandomTextGenerartor)theTextGenerator.withColumnWidth(3)).withRandomTextMode(RandomTextMode.NUMERIC).next(), (String)((RandomTextGenerartor)theTextGenerator.withColumnWidth(2)).withRandomTextMode(RandomTextMode.NUMERIC).next(), (String)((RandomTextGenerartor)theTextGenerator.withColumnWidth(4)).withRandomTextMode(RandomTextMode.NUMERIC).next());
    }

    protected void toOut(int[] aIntValues) {
        Object[] theNumCharObjs = new Integer[aIntValues.length];
        for (int i = 0; i < aIntValues.length; ++i) {
            theNumCharObjs[i] = aIntValues[i];
        }
        LOGGER.info((Object)("Calculated column widths = " + new VerboseTextBuilderImpl().withElements(theNumCharObjs).toString()));
    }

    private static class SysRecord {
        private String name;
        private String id;
        private String location;
        private String loadKbS;
        private String threads;
        private String memoryMb;

        public SysRecord(String name, String id, String location, String loadKbS, String threads, String memoryMb) {
            this.name = name;
            this.id = id;
            this.location = location;
            this.loadKbS = loadKbS;
            this.threads = threads;
            this.memoryMb = memoryMb;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        public String getLoadKbS() {
            return this.loadKbS;
        }

        public String getThreads() {
            return this.threads;
        }

        public String getMemoryMb() {
            return this.memoryMb;
        }
    }
}

