/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TextBlockBuilder;
import org.refcodes.textual.TextBlockBuilderImpl;
import org.refcodes.textual.TextLineBuilderImpl;

public class TextBlockBuilderTest {
    private static Logger LOGGER = Logger.getLogger(TextBlockBuilderTest.class);
    private static String TEST_TEXT = "=== \u00dcBERSCHRIFT ===\nIn ei alsbald ubrigen achtete. Oben eins steg gern kopf auf nur.\n=== \u00dcBERSCHRIFT ===\n Es an lohgruben hochstens gepfiffen wo arbeitete tanzmusik. So gelegen es du spuckte mageren je. Regnet kommen kleine spinat la schale ei du fallen. Behutsam schuppen zu um schlafen funkelte reinlich erzahlte. Ihr beschlo und kriegen lockere offnung konnten wie ten. Um ob so dann mund weit je. Konntest ku blattern ansprach kraftlos mu. === TEST === Uberlegt horchend burschen zu du so kollegen da. Pa ja zueinander dachkammer da dazwischen du knabenhaft. Dem sie klein drauf unter waren lange ihr lie wesen. Warm mein ort hut mag fein ists gut filz. === HEADLINE === Kugeln da da pa stelle leeren. Schlich breiten ach hut dem argerte. === ENDE === Wer kein ward zur die art dame tief also. ";

    @Test
    public void testTextBlockBuilder() {
        String[] theStrings = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{TEST_TEXT})).withColumnWidth(90)).withHorizAlignTextMode(HorizAlignTextMode.BLOCK).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this.toOut(theStrings);
    }

    @Test
    public void testEdgeCase1() {
        String[] theStrings = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{"12345678:abcdefgh:ABCDEFGH:1"})).withColumnWidth(9)).withHorizAlignTextMode(HorizAlignTextMode.RIGHT).withSplitTextMode(SplitTextMode.AT_SPACE).toStrings();
        this.toOut(theStrings);
        Assertions.assertEquals((int)4, (int)theStrings.length);
        Assertions.assertEquals((Object)"12345678:", (Object)theStrings[0]);
        Assertions.assertEquals((Object)"abcdefgh:", (Object)theStrings[1]);
        Assertions.assertEquals((Object)"ABCDEFGH:", (Object)theStrings[2]);
        Assertions.assertEquals((Object)"        1", (Object)theStrings[3]);
    }

    @Test
    public void testEdgeCase2() {
        String[] theStrings = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{"1234567890"})).withSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withColumnWidth(9)).toStrings();
        this.toOut(theStrings);
        Assertions.assertEquals((int)2, (int)theStrings.length);
        Assertions.assertEquals((Object)"123456789", (Object)theStrings[0]);
        Assertions.assertEquals((Object)"0        ", (Object)theStrings[1]);
    }

    @Test
    public void testEdgeCase2Right() {
        String[] theStrings = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{"1234567890"})).withSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withColumnWidth(9)).withHorizAlignTextMode(HorizAlignTextMode.RIGHT).toStrings();
        this.toOut(theStrings);
        Assertions.assertEquals((int)2, (int)theStrings.length);
        Assertions.assertEquals((Object)"123456789", (Object)theStrings[0]);
        Assertions.assertEquals((Object)"        0", (Object)theStrings[1]);
    }

    @Test
    public void testEdgeCase3() {
        String[] theStrings = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{"1234567890"})).withSplitTextMode(SplitTextMode.AT_END_OF_LINE).withColumnWidth(9)).toStrings();
        this.toOut(theStrings);
        Assertions.assertEquals((int)2, (int)theStrings.length);
        Assertions.assertEquals((Object)"123456789", (Object)theStrings[0]);
        Assertions.assertEquals((Object)"0        ", (Object)theStrings[1]);
    }

    @Test
    public void testEdgeCase3Right() {
        String[] theStrings = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{"1234567890"})).withSplitTextMode(SplitTextMode.AT_END_OF_LINE).withColumnWidth(9)).withHorizAlignTextMode(HorizAlignTextMode.RIGHT).toStrings();
        this.toOut(theStrings);
        Assertions.assertEquals((int)2, (int)theStrings.length);
        Assertions.assertEquals((Object)"123456789", (Object)theStrings[0]);
        Assertions.assertEquals((Object)"        0", (Object)theStrings[1]);
    }

    @Test
    public void testEdgeCase4() {
        String[] theStrings = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{"1234567890"})).withSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withColumnWidth(9)).toStrings();
        this.toOut(theStrings);
        Assertions.assertEquals((int)2, (int)theStrings.length);
        Assertions.assertEquals((Object)"123456789", (Object)theStrings[0]);
        Assertions.assertEquals((Object)"0        ", (Object)theStrings[1]);
    }

    @Test
    public void testEdgeCase4Right() {
        String[] theStrings = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{"1234567890"})).withSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withColumnWidth(9)).withHorizAlignTextMode(HorizAlignTextMode.RIGHT).toStrings();
        this.toOut(theStrings);
        Assertions.assertEquals((int)2, (int)theStrings.length);
        Assertions.assertEquals((Object)"123456789", (Object)theStrings[0]);
        Assertions.assertEquals((Object)"        0", (Object)theStrings[1]);
    }

    @Test
    public void testEdgeCase5() {
        String[] theStrings = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{"1234567890"})).withSplitTextMode(SplitTextMode.AT_SPACE).withColumnWidth(9)).toStrings();
        this.toOut(theStrings);
        Assertions.assertEquals((int)2, (int)theStrings.length);
        Assertions.assertEquals((Object)"123456789", (Object)theStrings[0]);
        Assertions.assertEquals((Object)"0        ", (Object)theStrings[1]);
    }

    @Test
    public void testEdgeCase5Right() {
        String[] theStrings = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{"1234567890"})).withSplitTextMode(SplitTextMode.AT_SPACE).withColumnWidth(9)).withHorizAlignTextMode(HorizAlignTextMode.RIGHT).toStrings();
        this.toOut(theStrings);
        Assertions.assertEquals((int)2, (int)theStrings.length);
        Assertions.assertEquals((Object)"123456789", (Object)theStrings[0]);
        Assertions.assertEquals((Object)"        0", (Object)theStrings[1]);
    }

    private void toOut(String[] aLines) {
        for (String eLine : aLines) {
            LOGGER.info((Object)("\"" + eLine + "\" [" + eLine.length() + "]"));
        }
        LOGGER.info((Object)("\"" + new TextLineBuilderImpl().withColumnWidth(aLines[0].length()).withLineChar('-').toString() + "\""));
    }
}

