/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.graphical.BoxBorderMode;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.TextBorderBuilder;
import org.refcodes.textual.TextBorderBuilderImpl;
import org.refcodes.textual.TextLineBuilderImpl;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class TextBorderBuilderTest {
    private static Logger LOGGER = Logger.getLogger(TextBorderBuilderTest.class);
    private static final String[] BLOCK = new String[]{"          ", "          ", "          ", "          ", "          ", "          ", "          ", "          ", "          ", "          "};

    @Test
    public void testTextBorderBuilder() {
        String[] theBlock = ((TextBorderBuilder)((TextBorderBuilder)new TextBorderBuilderImpl().withText(BLOCK)).withBoxBorderMode(BoxBorderMode.ALL)).toStrings();
        this.toOut(theBlock);
        Assertions.assertEquals((int)(BLOCK[0].length() + 2), (int)theBlock[0].length());
        Assertions.assertEquals((int)(BLOCK.length + 2), (int)theBlock.length);
    }

    @Test
    public void testTextBorderBuilderWidth1() {
        String[] theBlock = ((TextBorderBuilder)((TextBorderBuilder)new TextBorderBuilderImpl().withText(BLOCK)).withBorderChar('#').withBoxBorderMode(BoxBorderMode.ALL)).withBorderWidth(1).toStrings();
        this.toOut(theBlock);
        Assertions.assertEquals((int)(BLOCK[0].length() + 2), (int)theBlock[0].length());
        Assertions.assertEquals((int)(BLOCK.length + 2), (int)theBlock.length);
    }

    @Test
    public void testTextBorderBuilderWidth2() {
        String[] theBlock = ((TextBorderBuilder)((TextBorderBuilder)new TextBorderBuilderImpl().withText(BLOCK)).withBorderChar('#').withBoxBorderMode(BoxBorderMode.ALL)).withBorderWidth(2).toStrings();
        this.toOut(theBlock);
        Assertions.assertEquals((int)(BLOCK[0].length() + 4), (int)theBlock[0].length());
        Assertions.assertEquals((int)(BLOCK.length + 4), (int)theBlock.length);
    }

    @Test
    public void testTextBorderBuilderMutation() {
        for (BoxBorderMode eMode : BoxBorderMode.values()) {
            String[] eBlock = ((TextBorderBuilder)((TextBorderBuilder)((TextBorderBuilder)new TextBorderBuilderImpl().withText(BLOCK)).withBoxBorderMode(eMode)).withTableStyle(TableStyle.DOUBLE)).toStrings();
            this.toOut(eBlock);
            int eHorizontal = 0;
            if (eMode.isLeftBorder()) {
                ++eHorizontal;
            }
            if (eMode.isRightBorder()) {
                ++eHorizontal;
            }
            int eVertical = 0;
            if (eMode.isTopBorder()) {
                ++eVertical;
            }
            if (eMode.isBottomBorder()) {
                ++eVertical;
            }
            Assertions.assertEquals((int)(BLOCK[0].length() + eHorizontal), (int)eBlock[0].length());
            Assertions.assertEquals((int)(BLOCK.length + eVertical), (int)eBlock.length);
        }
    }

    @Test
    public void testTextBorderBuilderMutationWidth1() {
        for (BoxBorderMode eMode : BoxBorderMode.values()) {
            String[] eBlock = ((TextBorderBuilder)((TextBorderBuilder)new TextBorderBuilderImpl().withText(BLOCK)).withBorderChar('#').withBoxBorderMode(eMode)).withBorderWidth(1).toStrings();
            this.toOut(eBlock);
            int eHorizontal = 0;
            if (eMode.isLeftBorder()) {
                ++eHorizontal;
            }
            if (eMode.isRightBorder()) {
                ++eHorizontal;
            }
            int eVertical = 0;
            if (eMode.isTopBorder()) {
                ++eVertical;
            }
            if (eMode.isBottomBorder()) {
                ++eVertical;
            }
            Assertions.assertEquals((int)(BLOCK[0].length() + eHorizontal), (int)eBlock[0].length());
            Assertions.assertEquals((int)(BLOCK.length + eVertical), (int)eBlock.length);
        }
    }

    @Test
    public void testTextBorderBuilderMutationWidth2() {
        for (BoxBorderMode eMode : BoxBorderMode.values()) {
            String[] eBlock = ((TextBorderBuilder)((TextBorderBuilder)new TextBorderBuilderImpl().withText(BLOCK)).withBorderChar('#').withBoxBorderMode(eMode)).withBorderWidth(2).toStrings();
            this.toOut(eBlock);
            int eHorizontal = 0;
            if (eMode.isLeftBorder()) {
                eHorizontal += 2;
            }
            if (eMode.isRightBorder()) {
                eHorizontal += 2;
            }
            int eVertical = 0;
            if (eMode.isTopBorder()) {
                eVertical += 2;
            }
            if (eMode.isBottomBorder()) {
                eVertical += 2;
            }
            Assertions.assertEquals((int)(BLOCK[0].length() + eHorizontal), (int)eBlock[0].length());
            Assertions.assertEquals((int)(BLOCK.length + eVertical), (int)eBlock.length);
        }
    }

    protected void toOut(int[] aIntValues) {
        Object[] theNumCharObjs = new Integer[aIntValues.length];
        for (int i = 0; i < aIntValues.length; ++i) {
            theNumCharObjs[i] = aIntValues[i];
        }
        LOGGER.info((Object)("Calculated column widths = " + new VerboseTextBuilderImpl().withElements(theNumCharObjs).toString()));
    }

    private void toOut(String[] aLines) {
        for (String eLine : aLines) {
            LOGGER.info((Object)("\"" + eLine + "\" [" + eLine.length() + "]"));
        }
        LOGGER.info((Object)("\"" + new TextLineBuilderImpl().withColumnWidth(aLines[0].length()).withLineChar('-').toString() + "\""));
    }
}

