/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.io.InputStream;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.data.ext.boulderdash.BoulderDashAnimation;
import org.refcodes.data.ext.boulderdash.BoulderDashAnimationInputStreamsFactoryImpl;
import org.refcodes.data.ext.corporate.LogoPixmap;
import org.refcodes.data.ext.corporate.LogoPixmapInputStreamFactoryImpl;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.RgbPixmapImageBuilderImpl;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.textual.AsciiArtBuilder;
import org.refcodes.textual.AsciiArtBuilderImpl;
import org.refcodes.textual.AsciiArtMode;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontImpl;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.FontType;
import org.refcodes.textual.PixmapRatioMode;
import org.refcodes.textual.TextLineBuilderImpl;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class AsciiArtBuilderTest {
    private static Logger LOGGER = Logger.getLogger(AsciiArtBuilderTest.class);

    @Test
    public void testToAsciiArt() {
        FontImpl theFont = new FontImpl(FontType.DIALOG_INPUT, FontStyle.ITALIC, 24);
        String[] theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{"DEBUG"})).withFont((Font)theFont)).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
        this.toOut(theLines);
        theFont = new FontImpl(FontType.SERIF, FontStyle.BOLD, 24);
        theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{"FATAL!"})).withFont((Font)theFont)).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
        this.toOut(theLines);
        theFont = new FontImpl(FontType.SERIF, FontStyle.BOLD, 24);
        theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{"ONE-TWO-THREE"})).withFont((Font)theFont)).withAsciiArtMode(AsciiArtMode.NORMAL).withAsciiColors(new char[]{' ', '1', '2', '3'}).toStrings();
        this.toOut(theLines);
        theFont = new FontImpl(FontType.SERIF, FontStyle.BOLD, 22);
        theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{"ABC123 MINIMUM"})).withFont((Font)theFont)).withAsciiArtMode(AsciiArtMode.NORMAL).withAsciiColorPalette(AsciiColorPalette.MIN_LEVEL_GRAY).toStrings();
        this.toOut(theLines);
        theFont = new FontImpl(FontType.SERIF, FontStyle.BOLD, 22);
        theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{"ABC123 NORMAL"})).withFont((Font)theFont)).withAsciiArtMode(AsciiArtMode.NORMAL).withAsciiColorPalette(AsciiColorPalette.NORM_LEVEL_GRAY).toStrings();
        this.toOut(theLines);
        theFont = new FontImpl(FontType.SERIF, FontStyle.BOLD, 22);
        theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{"ABC123 MAXIMUM"})).withFont((Font)theFont)).withAsciiArtMode(AsciiArtMode.NORMAL).withAsciiColorPalette(AsciiColorPalette.MAX_LEVEL_GRAY).toStrings();
        this.toOut(theLines);
        theFont = new FontImpl(FontType.SANS_SERIF, FontStyle.BOLD, -1);
        theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{"Bag off!"})).withFont((Font)theFont)).withAsciiArtMode(AsciiArtMode.NORMAL).withAsciiColorPalette(AsciiColorPalette.MAX_LEVEL_GRAY).toStrings();
        this.toOut(theLines);
        for (String eString : new String[]{"FATAL", "ERROR", "WARN", "INFO", "DEBUG", "COMMENT", "OFF"}) {
            theFont = new FontImpl(FontType.SANS_SERIF, FontStyle.BOLD, 24);
            theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{eString})).withFont((Font)theFont)).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
            this.toOut(theLines);
        }
    }

    @Test
    public void testToInverseAsciiArt() {
        FontImpl theFont = new FontImpl(FontType.MONOSPACED, FontStyle.BOLD_ITALIC, -1);
        String[] theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{"REFCODES"})).withFont((Font)theFont)).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
        this.toOut(theLines);
        theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{"FUNCODES"})).withFont((Font)theFont)).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
        this.toOut(theLines);
        theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withText(new String[]{"COMCODES"})).withFont((Font)theFont)).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
        this.toOut(theLines);
    }

    @Test
    public void testToAsciiArtArray() {
        FontImpl theFont = new FontImpl(FontType.MONOSPACED, FontStyle.BOLD, 26);
        String[] theLines = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withFont((Font)theFont).withText(new String[]{"Hallo", "JAKOB", ":-) :-)"})).withColumnWidth(80)).withAsciiColorPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
        this.toOut(theLines);
    }

    @Test
    public void testBoulderDashPixmap() {
        BoulderDashAnimationInputStreamsFactoryImpl theFactory = new BoulderDashAnimationInputStreamsFactoryImpl();
        InputStream[] theInputStreams = (InputStream[])theFactory.createInstance((Object)BoulderDashAnimation.ROCKFORD_FACING_FORWARD_BLINKING_TAPPING_FOOT);
        RgbPixmapImageBuilderImpl theBuilder = new RgbPixmapImageBuilderImpl();
        for (InputStream eStream : theInputStreams) {
            theBuilder.withImageInputStream(eStream);
            RgbPixmap thePixmap = theBuilder.toPixmap();
            String[] theLines = new AsciiArtBuilderImpl().withRgbPixmap(thePixmap).withAsciiColorPalette(AsciiColorPalette.HALFTONE_GRAY).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
            Assertions.assertEquals((int)theLines.length, (int)thePixmap.getPixmapWidth());
            Assertions.assertEquals((int)theLines[0].length(), (int)thePixmap.getPixmapHeight());
            this.toOut(theLines);
        }
    }

    @Test
    public void testScaledBoulderDashPixmap() {
        BoulderDashAnimationInputStreamsFactoryImpl theFactory = new BoulderDashAnimationInputStreamsFactoryImpl();
        InputStream[] theInputStreams = (InputStream[])theFactory.createInstance((Object)BoulderDashAnimation.ROCKFORD_FACING_FORWARD_BLINKING_TAPPING_FOOT);
        RgbPixmapImageBuilderImpl theBuilder = new RgbPixmapImageBuilderImpl();
        for (InputStream eStream : theInputStreams) {
            theBuilder.withImageInputStream(eStream);
            RgbPixmap thePixmap = theBuilder.toPixmap();
            String[] theLines = ((AsciiArtBuilder)new AsciiArtBuilderImpl().withPixmapRatioMode(PixmapRatioMode.CONSOLE).withColumnWidth(64)).withRgbPixmap(thePixmap).withAsciiColorPalette(AsciiColorPalette.HALFTONE_GRAY).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
            Assertions.assertEquals((int)theLines.length, (int)32);
            Assertions.assertEquals((int)theLines[0].length(), (int)64);
            this.toOut(theLines);
        }
    }

    @Test
    public void testRefcodesPixmap() {
        InputStream eStream = new LogoPixmapInputStreamFactoryImpl().createInstance(LogoPixmap.FUNCODES);
        RgbPixmapImageBuilderImpl theBuilder = new RgbPixmapImageBuilderImpl();
        theBuilder.withImageInputStream(eStream);
        RgbPixmap thePixmap = theBuilder.toPixmap();
        String[] theLines = ((AsciiArtBuilder)new AsciiArtBuilderImpl().withPixmapRatioMode(PixmapRatioMode.CONSOLE).withColumnWidth(SystemUtility.toConsoleWidth())).withRgbPixmap(thePixmap).withAsciiColorPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
        this.toOut(theLines);
    }

    @Test
    public void testScaledRefcodesPixmap() {
        InputStream in = new LogoPixmapInputStreamFactoryImpl().createInstance(LogoPixmap.FUNCODES);
        RgbPixmap thePixmap = new RgbPixmapImageBuilderImpl().withImageInputStream(in).toPixmap();
        String[] theLines = ((AsciiArtBuilder)new AsciiArtBuilderImpl().withPixmapRatioMode(PixmapRatioMode.CONSOLE).withColumnWidth(48)).withRgbPixmap(thePixmap).withAsciiColorPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withAsciiArtMode(AsciiArtMode.NORMAL).toStrings();
        this.toOut(theLines);
    }

    @Test
    public void testRefcodesPixmapAsString() {
        InputStream in = new LogoPixmapInputStreamFactoryImpl().createInstance(LogoPixmap.FUNCODES);
        RgbPixmap thePixmap = new RgbPixmapImageBuilderImpl().withImageInputStream(in).toPixmap();
        String theLine = ((AsciiArtBuilder)new AsciiArtBuilderImpl().withPixmapRatioMode(PixmapRatioMode.CONSOLE).withColumnWidth(SystemUtility.toConsoleWidth())).withRgbPixmap(thePixmap).withAsciiColorPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withAsciiArtMode(AsciiArtMode.NORMAL).toString();
        LOGGER.debug((Object)("\n" + theLine));
    }

    @Disabled(value="Referred to by the blog")
    @Test
    public void testRefcodesExample1() {
        AsciiArtBuilder theBuilder = (AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withFontStyle(FontStyle.BOLD).withFontType(FontType.SANS_SERIF)).withAsciiColorPalette(AsciiColorPalette.MAX_LEVEL_GRAY).withAsciiArtMode(AsciiArtMode.NORMAL).withColumnWidth(120);
        LOGGER.debug((Object)("\n" + theBuilder.toString(new String[]{"DON'T PANIC"})));
    }

    @Disabled(value="Referred to by the blog")
    @Test
    public void testRefcodesExample2() {
        AsciiArtBuilder theBuilder = (AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withFontStyle(FontStyle.BOLD_ITALIC).withFontType(FontType.SANS_SERIF)).withAsciiColorPalette(AsciiColorPalette.HALFTONE_GRAY).withColumnWidth(120);
        LOGGER.debug((Object)("\n" + theBuilder.toString(new String[]{"HELLO WORLD!"})));
    }

    @Disabled(value="Referred to by the blog")
    @Test
    public void testRefcodesExample3() {
        AsciiArtBuilder theBuilder = ((AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withFontStyle(FontStyle.BOLD_ITALIC).withFontType(FontType.SANS_SERIF)).withAsciiColorPalette(AsciiColorPalette.HALFTONE_GRAY).withColumnWidth(120)).withAsciiArtMode(AsciiArtMode.INVERSE);
        LOGGER.debug((Object)("\n" + theBuilder.toString(new String[]{"HELLO WORLD!"})));
    }

    @Disabled(value="Referred to by the blog")
    @Test
    public void testRefcodesExample4() {
        AsciiArtBuilder theBuilder = (AsciiArtBuilder)((AsciiArtBuilder)new AsciiArtBuilderImpl().withFontStyle(FontStyle.BOLD_ITALIC).withFontType(FontType.SANS_SERIF)).withAsciiColors(new char[]{'.', '/', '#'}).withColumnWidth(120);
        LOGGER.debug((Object)("\n" + theBuilder.toString(new String[]{"HELLO WORLD!"})));
    }

    protected void toOut(int[] aIntValues) {
        Object[] theNumCharObjs = new Integer[aIntValues.length];
        for (int i = 0; i < aIntValues.length; ++i) {
            theNumCharObjs[i] = aIntValues[i];
        }
        LOGGER.info((Object)("Calculated column widths = " + new VerboseTextBuilderImpl().withElements(theNumCharObjs).toString()));
    }

    private void toOut(String[] aLines) {
        for (String eLine : aLines) {
            LOGGER.info((Object)("\"" + eLine + "\" [" + eLine.length() + "]"));
        }
        LOGGER.info((Object)("\"" + new TextLineBuilderImpl().withColumnWidth(aLines[0].length()).withLineChar('-').toString() + "\""));
    }
}

