/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.refcodes.textual.CsvBuilder;
import org.refcodes.textual.CsvBuilderImpl;
import org.refcodes.textual.CsvEscapeMode;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class CsvBuilderTest {
    private static Logger LOGGER = Logger.getLogger(CsvBuilderTest.class);
    private static final String[] CSV_VALUES_1 = new String[]{"aaa", "\"bbb", "ccc\"", "\"ddd\"", "e\"ee", "\"f\"ff", "g\"gg\"", "h,hh", "\"i,ii", "j,jj\"", "\"k,kk\"", "l,l\"l", "m\"\"\"m,\"\"m"};
    private static final String CSV_TEXT_1 = "aaa,\"\"\"bbb\",\"ccc\"\"\",\"\"\"ddd\"\"\",\"e\"\"ee\",\"\"\"f\"\"ff\",\"g\"\"gg\"\"\",\"h,hh\",\"\"\"i,ii\",\"j,jj\"\"\",\"\"\"k,kk\"\"\",\"l,l\"\"l\",\"m\"\"\"\"\"\"m,\"\"\"\"m\"";
    private static String CSV_TEXT_2_IN = "\"12088860108\"|\"\"|\"12088860108\"|\"\"";
    private static String CSV_TEXT_2_OUT = "12088860108||12088860108|";
    private static String CSV_TEXT_3_IN = "\"|\"|\".\"|\",\"|\"-\"";
    private static String CSV_TEXT_3_OUT = "";

    @Test
    public void testToSeparatedValues1() {
        LOGGER.info((Object)"EXPECTED = aaa,\"\"\"bbb\",\"ccc\"\"\",\"\"\"ddd\"\"\",\"e\"\"ee\",\"\"\"f\"\"ff\",\"g\"\"gg\"\"\",\"h,hh\",\"\"\"i,ii\",\"j,jj\"\"\",\"\"\"k,kk\"\"\",\"l,l\"\"l\",\"m\"\"\"\"\"\"m,\"\"\"\"m\"");
        List<String> theList1 = Arrays.asList(CSV_VALUES_1);
        Iterator<String> e = theList1.iterator();
        StringBuffer theBuffer = new StringBuffer();
        theBuffer.append("LIST     = ");
        while (e.hasNext()) {
            theBuffer.append(e.next());
            if (!e.hasNext()) continue;
            theBuffer.append(';');
        }
        LOGGER.info((Object)theBuffer.toString());
        String theString1 = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{theList1}).withDelimiterChar(',').toRecord();
        LOGGER.info((Object)theString1);
        Assertions.assertEquals((Object)CSV_TEXT_1, (Object)theString1);
        theBuffer = new StringBuffer();
        theBuffer.append("TO CSV   = ");
        List theList2 = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withRecord(theString1).withDelimiterChar(',').toFields();
        e = theList2.iterator();
        while (e.hasNext()) {
            theBuffer.append(e.next());
            if (!e.hasNext()) continue;
            theBuffer.append(';');
        }
        LOGGER.info((Object)theBuffer.toString());
        Assertions.assertEquals(theList1, (Object)theList2);
        theBuffer = new StringBuffer();
        theBuffer.append("STRING 2  = ");
        String theString2 = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{theList2}).withDelimiterChar(',').toRecord();
        theBuffer.append(theString2);
        LOGGER.info((Object)theBuffer.toString());
        Assertions.assertEquals((Object)theString1, (Object)theString2);
    }

    @Test
    public void testToSeparatedValues2() {
        List theList = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withRecord(CSV_TEXT_2_IN).withDelimiterChar('|').toFields();
        StringBuffer theBuffer = new StringBuffer();
        theBuffer.append("LIST 2    = ");
        Iterator e = theList.iterator();
        while (e.hasNext()) {
            theBuffer.append((String)e.next());
            if (!e.hasNext()) continue;
            theBuffer.append(';');
        }
        LOGGER.info((Object)theBuffer.toString());
        String theOut = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{theList}).withDelimiterChar('|').toRecord();
        LOGGER.info((Object)("EXPECTED  = " + CSV_TEXT_2_OUT));
        LOGGER.info((Object)("CSV 2     = " + theOut));
        Assertions.assertEquals((Object)CSV_TEXT_2_OUT, (Object)theOut);
    }

    @Disabled(value="Bug when CSV line begins with a separator in quotation marks")
    @Test
    public void testToSeparatedValues3() {
        List theList = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withRecord(CSV_TEXT_3_IN).withDelimiterChar('|').toFields();
        StringBuffer theBuffer = new StringBuffer();
        theBuffer.append("LIST 3    = ");
        Iterator e = theList.iterator();
        while (e.hasNext()) {
            theBuffer.append((String)e.next());
            if (!e.hasNext()) continue;
            theBuffer.append(';');
        }
        LOGGER.info((Object)theBuffer.toString());
        String theOut = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED).withFields(new Object[]{theList}).withDelimiterChar('|').toRecord();
        LOGGER.info((Object)("EXPECTED  = " + CSV_TEXT_3_OUT));
        LOGGER.info((Object)("CSV 3     = " + theOut));
        Assertions.assertEquals((Object)CSV_TEXT_3_OUT, (Object)theOut);
    }

    @Test
    public void testTextManipulation() {
        String stringList = "element1, element2, element3";
        CsvBuilder theBuilder = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED);
        String[] stringArray = theBuilder.toFields(stringList);
        LOGGER.info((Object)"Testing 'toStringArray()' and back 'toString()':");
        LOGGER.info((Object)("String list  = <" + stringList + ">"));
        LOGGER.info((Object)("String list --> array --> list = <" + new VerboseTextBuilderImpl().toString(stringArray) + ">"));
        Assertions.assertEquals((Object)stringList, (Object)theBuilder.toRecord(stringArray));
    }

    @Test
    public void testThreadSafeTextManipulation() {
        String stringList = "element1, element2, element3";
        CsvBuilder theBuilder = new CsvBuilderImpl().withCsvEscapeMode(CsvEscapeMode.ESCAPED);
        String[] stringArray = theBuilder.toFields(stringList);
        LOGGER.info((Object)"Testing 'toStringArray()' and back 'toString()':");
        LOGGER.info((Object)("String list  = <" + stringList + ">"));
        LOGGER.info((Object)("String list --> array --> list = <" + new VerboseTextBuilderImpl().toString(stringArray) + ">"));
        Assertions.assertEquals((Object)stringList, (Object)theBuilder.toRecord(stringArray));
    }

    protected void toOut(int[] aIntValues) {
        Integer[] theNumCharObjs = new Integer[aIntValues.length];
        for (int i = 0; i < aIntValues.length; ++i) {
            theNumCharObjs[i] = aIntValues[i];
        }
        LOGGER.info((Object)("Calculated column widths = " + new VerboseTextBuilderImpl().toString(theNumCharObjs)));
    }
}

