/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.structure.Property;
import org.refcodes.structure.PropertyImpl;
import org.refcodes.textual.EscapeTextBuilder;
import org.refcodes.textual.EscapeTextBuilderImpl;
import org.refcodes.textual.EscapeTextMode;

public class EscapeTextBuilderTest {
    private static Logger LOGGER = Logger.getLogger(EscapeTextBuilderTest.class);
    private static String UNESCAPED_TEXT_1 = "12345-abcde+12345/abcde";
    private static String ESCAPED_TEXT_1 = "12345XXXMINUSXXXabcdeXXXPLUSXXX12345XXXSLASHXXXabcde";
    private static Property[] ESCAPE_MATRIX = new Property[]{new PropertyImpl("-", "XXXMINUSXXX"), new PropertyImpl("+", "XXXPLUSXXX"), new PropertyImpl("*", "XXXASTERISKXXX"), new PropertyImpl("/", "XXXSLASHXXX"), new PropertyImpl("~", "XXXTILDEXXX"), new PropertyImpl("#", "XXXHASHXXX")};

    @Test
    public void testFromEscapedToUnescaped() {
        LOGGER.info((Object)("UNESCAPED_TEXT   = " + UNESCAPED_TEXT_1));
        LOGGER.info((Object)("ESCAPED_TEXT     = " + ESCAPED_TEXT_1));
        String theEscapedText = ((EscapeTextBuilder)new EscapeTextBuilderImpl().withEscapeTextMode(EscapeTextMode.ESCAPE).withText(new String[]{UNESCAPED_TEXT_1})).withEscapeProperties(ESCAPE_MATRIX).toString();
        LOGGER.info((Object)("theEscapedText   = " + theEscapedText));
        Assertions.assertEquals((Object)ESCAPED_TEXT_1, (Object)theEscapedText);
        String theUnEscapedText = ((EscapeTextBuilder)new EscapeTextBuilderImpl().withEscapeTextMode(EscapeTextMode.UNESCAPE).withText(new String[]{theEscapedText})).withEscapeProperties(ESCAPE_MATRIX).toString();
        LOGGER.info((Object)("theUnEscapedText = " + theUnEscapedText));
        Assertions.assertEquals((Object)UNESCAPED_TEXT_1, (Object)theUnEscapedText);
    }
}

