/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.CharSet;
import org.refcodes.textual.ReplaceTextBuilder;
import org.refcodes.textual.ReplaceTextBuilderImpl;
import org.refcodes.textual.TruncateTextBuilderImpl;
import org.refcodes.textual.TruncateTextMode;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class TruncateTextBuilderTest {
    private static Logger LOGGER = Logger.getLogger(TruncateTextBuilderTest.class);

    @Test
    public void testTextStripBuilder() {
        String text = "Rock'n'Roll";
        String find = "'";
        String replace = "\\'";
        LOGGER.info((Object)"starting test()...");
        LOGGER.info((Object)("text = '" + text + "', find = '" + find + "', replace = '" + replace + "'."));
        String out = ((ReplaceTextBuilder)new ReplaceTextBuilderImpl().withText(new String[]{text})).withFindText(find).withReplaceText(replace).toString();
        LOGGER.info((Object)("result = '" + out + "'."));
        String str = "AAAAAA  BBBBB AAAAABBBAAABBBAAA";
        LOGGER.info((Object)("\"" + str + "\""));
        str = new TruncateTextBuilderImpl().withTruncateTextMode(TruncateTextMode.LEFT).withText(new String[]{str}).withStripChars(new char[]{'A'}).toString();
        LOGGER.info((Object)("Strip left all 'A' chars: \"" + str + "\""));
        str = new TruncateTextBuilderImpl().withTruncateTextMode(TruncateTextMode.RIGHT).withText(new String[]{str}).withStripChars(new char[]{'A'}).toString();
        LOGGER.info((Object)("Strip right all 'A' chars: \"" + str + "\""));
        if (!str.toString().equals("  BBBBB AAAAABBBAAABBB")) {
            Assertions.fail((String)"ERROR [100]");
        }
        String str2 = " \t\t\t\t\t\t\tHallo wie gehts?         ";
        String ret = new TruncateTextBuilderImpl().withTruncateTextMode(TruncateTextMode.LEFT_AND_RIGHT).withText(new String[]{" \t\t\t\t\t\t\tHallo wie gehts?         "}).withStripChars(CharSet.WHITE_SPACES.getCharSet()).toString();
        LOGGER.info((Object)"\" \t\t\t\t\t\t\tHallo wie gehts?         \"");
        LOGGER.info((Object)("Strip all left and all right WHITESPACE chars: \"" + ret + "\""));
        if (!ret.equals("Hallo wie gehts?")) {
            Assertions.fail((String)"ERROR [200]");
        }
    }

    protected void toOut(int[] aIntValues) {
        Object[] theNumCharObjs = new Integer[aIntValues.length];
        for (int i = 0; i < aIntValues.length; ++i) {
            theNumCharObjs[i] = aIntValues[i];
        }
        LOGGER.info((Object)("Calculated column widths = " + new VerboseTextBuilderImpl().withElements(theNumCharObjs).toString()));
    }
}

