/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.textual.VerboseTextBuilderImpl;

public class VerboseTextBuilderTest {
    private static Logger LOGGER = Logger.getLogger(VerboseTextBuilderTest.class);
    private static final byte[] PRIMITIVE_BYTES = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
    private static final Byte[] OBJECT_BYTES = new Byte[]{(byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)0};
    private static final String[] STRINGS = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "zero"};

    @Test
    public void testSingleElement() {
        String theVerbose = new VerboseTextBuilderImpl().withElements((Object)"Hallo").toString();
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ \"Hallo\" }", (Object)theVerbose);
    }

    @Test
    public void testSingleElementThreadSafe() {
        String theVerbose = new VerboseTextBuilderImpl().toString((Object)"Hallo");
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ \"Hallo\" }", (Object)theVerbose);
    }

    @Test
    public void testPrimitiveByteArray() {
        String theVerbose = new VerboseTextBuilderImpl().withElements(PRIMITIVE_BYTES).toString();
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 }", (Object)theVerbose);
    }

    @Test
    public void testPrimitiveByteArrayThreadSafe() {
        String theVerbose = new VerboseTextBuilderImpl().toString(PRIMITIVE_BYTES);
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 }", (Object)theVerbose);
    }

    @Test
    public void testObjectByteArray() {
        String theVerbose = new VerboseTextBuilderImpl().withElements((Object[])OBJECT_BYTES).toString();
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 }", (Object)theVerbose);
    }

    @Test
    public void testObjectByteArrayThreadSafe() {
        String theVerbose = new VerboseTextBuilderImpl().toString(OBJECT_BYTES);
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 }", (Object)theVerbose);
    }

    @Test
    public void testStringArray() {
        String theVerbose = new VerboseTextBuilderImpl().withElements((Object[])STRINGS).toString();
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ \"one\", \"two\", \"three\", \"four\", \"five\", \"six\", \"seven\", \"eight\", \"nine\", \"zero\" }", (Object)theVerbose);
    }

    @Test
    public void testStringArrayThreadSafe() {
        String theVerbose = new VerboseTextBuilderImpl().toString(STRINGS);
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ \"one\", \"two\", \"three\", \"four\", \"five\", \"six\", \"seven\", \"eight\", \"nine\", \"zero\" }", (Object)theVerbose);
    }

    @Test
    public void testObjectByteCollection() {
        String theVerbose = new VerboseTextBuilderImpl().withElements(Arrays.asList(OBJECT_BYTES)).toString();
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 }", (Object)theVerbose);
    }

    @Test
    public void testObjectByteCollectionThreadSafe() {
        String theVerbose = new VerboseTextBuilderImpl().toString(Arrays.asList(OBJECT_BYTES));
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 }", (Object)theVerbose);
    }

    @Test
    public void testStringCollection() {
        String theVerbose = new VerboseTextBuilderImpl().withElements(Arrays.asList(STRINGS)).toString();
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ \"one\", \"two\", \"three\", \"four\", \"five\", \"six\", \"seven\", \"eight\", \"nine\", \"zero\" }", (Object)theVerbose);
    }

    @Test
    public void testStringCollectionThreadSafe() {
        String theVerbose = new VerboseTextBuilderImpl().toString(Arrays.asList(STRINGS));
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{ \"one\", \"two\", \"three\", \"four\", \"five\", \"six\", \"seven\", \"eight\", \"nine\", \"zero\" }", (Object)theVerbose);
    }

    @Test
    public void testStringMap() {
        HashMap<String, Integer> theMap = new HashMap<String, Integer>();
        theMap.put("one", 1);
        theMap.put("two", 2);
        theMap.put("three", 3);
        theMap.put("four", 4);
        theMap.put("five", 5);
        theMap.put("six", 6);
        theMap.put("seven", 7);
        theMap.put("eight", 8);
        theMap.put("nine", 9);
        theMap.put("zero", 0);
        String theVerbose = new VerboseTextBuilderImpl().withElements(theMap).toString();
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{\n  zero = 0,\n  nine = 9,\n  six = 6,\n  four = 4,\n  one = 1,\n  seven = 7,\n  two = 2,\n  three = 3,\n  five = 5,\n  eight = 8\n}", (Object)theVerbose);
    }

    @Test
    public void testStringMapTreadSafe() {
        HashMap<String, Integer> theMap = new HashMap<String, Integer>();
        theMap.put("one", 1);
        theMap.put("two", 2);
        theMap.put("three", 3);
        theMap.put("four", 4);
        theMap.put("five", 5);
        theMap.put("six", 6);
        theMap.put("seven", 7);
        theMap.put("eight", 8);
        theMap.put("nine", 9);
        theMap.put("zero", 0);
        String theVerbose = new VerboseTextBuilderImpl().toString(theMap);
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{\n  zero = 0,\n  nine = 9,\n  six = 6,\n  four = 4,\n  one = 1,\n  seven = 7,\n  two = 2,\n  three = 3,\n  five = 5,\n  eight = 8\n}", (Object)theVerbose);
    }

    @Test
    public void testAnotherStringMap() {
        HashMap<String, int[]> theMap = new HashMap<String, int[]>();
        theMap.put("one", new int[]{1});
        theMap.put("two", new int[]{2, 2});
        theMap.put("three", new int[]{3, 3, 3});
        theMap.put("four", new int[]{4, 4, 4, 4});
        theMap.put("five", new int[]{5, 5, 5, 5, 5});
        theMap.put("six", new int[]{6, 6, 6, 6, 6, 6});
        theMap.put("seven", new int[]{7, 7, 7, 7, 7, 7, 7});
        theMap.put("eight", new int[]{8, 8, 8, 8, 8, 8, 8, 8});
        theMap.put("nine", new int[]{9, 9, 9, 9, 9, 9, 9, 9, 9});
        theMap.put("zero", new int[0]);
        String theVerbose = new VerboseTextBuilderImpl().withElements(theMap).toString();
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{\n  zero = {},\n  nine = { 9, 9, 9, 9, 9, 9, 9, 9, 9 },\n  six = { 6, 6, 6, 6, 6, 6 },\n  four = { 4, 4, 4, 4 },\n  one = { 1 },\n  seven = { 7, 7, 7, 7, 7, 7, 7 },\n  two = { 2, 2 },\n  three = { 3, 3, 3 },\n  five = { 5, 5, 5, 5, 5 },\n  eight = { 8, 8, 8, 8, 8, 8, 8, 8 }\n}", (Object)theVerbose);
    }

    @Test
    public void testAnotherStringMapThreadSafe() {
        HashMap<String, int[]> theMap = new HashMap<String, int[]>();
        theMap.put("one", new int[]{1});
        theMap.put("two", new int[]{2, 2});
        theMap.put("three", new int[]{3, 3, 3});
        theMap.put("four", new int[]{4, 4, 4, 4});
        theMap.put("five", new int[]{5, 5, 5, 5, 5});
        theMap.put("six", new int[]{6, 6, 6, 6, 6, 6});
        theMap.put("seven", new int[]{7, 7, 7, 7, 7, 7, 7});
        theMap.put("eight", new int[]{8, 8, 8, 8, 8, 8, 8, 8});
        theMap.put("nine", new int[]{9, 9, 9, 9, 9, 9, 9, 9, 9});
        theMap.put("zero", new int[0]);
        String theVerbose = new VerboseTextBuilderImpl().toString(theMap);
        LOGGER.debug((Object)theVerbose);
        Assertions.assertEquals((Object)"{\n  zero = {},\n  nine = { 9, 9, 9, 9, 9, 9, 9, 9, 9 },\n  six = { 6, 6, 6, 6, 6, 6 },\n  four = { 4, 4, 4, 4 },\n  one = { 1 },\n  seven = { 7, 7, 7, 7, 7, 7, 7 },\n  two = { 2, 2 },\n  three = { 3, 3, 3 },\n  five = { 5, 5, 5, 5, 5 },\n  eight = { 8, 8, 8, 8, 8, 8, 8, 8 }\n}", (Object)theVerbose);
    }
}

