/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.textual.Font;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.FontType;

public class FontImpl
implements Font {
    private FontType _fontType = FontType.SANS_SERIF;
    private int _fontSize = 16;
    private FontStyle _fontStyle = FontStyle.PLAIN;
    private String _fontName = this._fontType.getFontTypeName();

    public FontImpl() {
    }

    public FontImpl(FontType aFontType, FontStyle aFontStyle, int aFontSize) {
        this.setFontType(aFontType);
        this._fontStyle = aFontStyle;
        this._fontSize = aFontSize;
    }

    public FontImpl(FontType aFontType, FontStyle aFontStyle) {
        this(aFontType, aFontStyle, -1);
    }

    public FontImpl(String aFontName, FontStyle aFontStyle, int aFontSize) {
        this.setFontName(aFontName);
        this._fontStyle = aFontStyle;
        this._fontSize = aFontSize;
    }

    public FontImpl(String aFontName, FontStyle aFontStyle) {
        this(aFontName, aFontStyle, -1);
    }

    @Override
    public FontType getFontType() {
        return this._fontType;
    }

    @Override
    public void setFontType(FontType aFontType) {
        this._fontType = aFontType;
        this._fontName = aFontType.getFontTypeName();
    }

    @Override
    public Font withFontType(FontType aFontName) {
        this.setFontType(aFontName);
        return this;
    }

    @Override
    public FontStyle getFontStyle() {
        return this._fontStyle;
    }

    @Override
    public void setFontStyle(FontStyle aFontStyle) {
        this._fontStyle = aFontStyle;
    }

    @Override
    public Font withFontStyle(FontStyle aFontStyle) {
        this.setFontStyle(aFontStyle);
        return this;
    }

    @Override
    public int getFontSize() {
        return this._fontSize;
    }

    @Override
    public void setFontSize(int aFontSize) {
        this._fontSize = aFontSize;
    }

    @Override
    public Font withFontSize(int aFontSize) {
        this.setFontSize(aFontSize);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._fontType.getFontTypeName() + ", " + this._fontStyle + ", " + this._fontSize + ")@" + this.hashCode();
    }

    @Override
    public String getFontName() {
        return this._fontName;
    }

    @Override
    public void setFontName(String aFontName) {
        this._fontName = aFontName;
        this._fontType = FontType.fromFontTypeName(aFontName);
    }

    @Override
    public Font withFontName(String aFontName) {
        this.setFontName(aFontName);
        return this;
    }
}

