/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.textual.AbstractText;
import org.refcodes.textual.OverwriteTextBuilder;
import org.refcodes.textual.OverwriteTextMode;

public class OverwriteTextBuilderImpl
extends AbstractText<OverwriteTextBuilder>
implements OverwriteTextBuilder {
    private String _overwritingText = null;
    private OverwriteTextMode _overwriteTextMode = OverwriteTextMode.RIGHT;

    @Override
    public String getOverwritingText() {
        return this._overwritingText;
    }

    @Override
    public void setOverwritingText(String aOverwritingText) {
        this._overwritingText = aOverwritingText;
    }

    @Override
    public OverwriteTextMode getOverwriteTextMode() {
        return this._overwriteTextMode;
    }

    @Override
    public void setTextOverwriteMode(OverwriteTextMode aOverwriteTextMode) {
        this._overwriteTextMode = aOverwriteTextMode;
    }

    @Override
    public String[] toStrings() {
        return this.toStrings(this.getText());
    }

    @Override
    public String[] toStrings(String ... aText) {
        String[] theResult = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theResult[i] = OverwriteTextBuilderImpl.toOverwrite(aText[i], this._overwritingText, this._overwriteTextMode);
        }
        return theResult;
    }

    protected static String toOverwrite(String aText, String aWriteOverText, OverwriteTextMode aOverwriteTextMode) {
        switch (aOverwriteTextMode) {
            case LEFT: {
                return OverwriteTextBuilderImpl.toOverwriteLeft(aText, aWriteOverText);
            }
            case RIGHT: {
                return OverwriteTextBuilderImpl.toOverwriteRight(aText, aWriteOverText);
            }
        }
        throw new IllegalArgumentException("You must pass a valid overwrite text mode, though you actually passed <" + aOverwriteTextMode + ">!");
    }

    protected static String toOverwriteLeft(String aText, String aWriteOverText) {
        if (aWriteOverText.length() > aText.length()) {
            return aWriteOverText.substring(0, aText.length());
        }
        if (aWriteOverText.length() == aText.length()) {
            return aWriteOverText;
        }
        String theText = aWriteOverText + aText.substring(aWriteOverText.length());
        return theText;
    }

    protected static String toOverwriteRight(String aText, String aWriteOverText) {
        if (aWriteOverText.length() > aText.length()) {
            return aWriteOverText.substring(aWriteOverText.length() - aText.length());
        }
        if (aWriteOverText.length() == aText.length()) {
            return aWriteOverText;
        }
        String theText = aText.substring(0, aText.length() - aWriteOverText.length()) + aWriteOverText;
        return theText;
    }
}

