/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.Random;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextMode;

public class RandomTextGenerartorImpl
implements RandomTextGenerartor {
    private int _columnWidth = 64;
    private RandomTextMode _randomTextMode = RandomTextMode.ASCII;
    private Random _numberGenerator = new Random();
    private char[] _charSet = null;

    public RandomTextGenerartor withColumnWidth(int aColumnWidth) {
        this.setColumnWidth(aColumnWidth);
        return this;
    }

    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    public boolean hasNext() {
        return true;
    }

    public String next() {
        if (this._charSet != null) {
            return this.toRandom(this._charSet, this._columnWidth, this._numberGenerator);
        }
        return this.toRandom(this._randomTextMode.getCharSet(), this._columnWidth, this._numberGenerator);
    }

    @Override
    public RandomTextMode getRandomTextMode() {
        return this._randomTextMode;
    }

    @Override
    public void setRandomTextMode(RandomTextMode aRandomTextMode) {
        this._randomTextMode = aRandomTextMode;
        if (aRandomTextMode != null) {
            this._charSet = null;
        }
    }

    public char[] getCharSet() {
        return this._charSet;
    }

    public void setCharSet(char[] aCharSet) {
        this._charSet = aCharSet;
        if (aCharSet != null) {
            this._randomTextMode = null;
        }
    }

    public RandomTextGenerartor withCharSet(char[] aCharSet) {
        this.setCharSet(aCharSet);
        return this;
    }

    private String toRandom(char[] aCharSet, int aColumnWidth, Random aRndGenerator) {
        int theBound = aCharSet.length;
        char[] theRandom = new char[aColumnWidth];
        for (int i = 0; i < aColumnWidth; ++i) {
            theRandom[i] = aCharSet[aRndGenerator.nextInt(theBound)];
        }
        return new String(theRandom);
    }
}

