/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.Truncate;
import org.refcodes.exception.BugException;
import org.refcodes.mixin.TableHeader;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.textual.ColumnFormatMetrics;
import org.refcodes.textual.ColumnFormatMetricsImpl;
import org.refcodes.textual.ColumnWidthMetrics;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.HorizAlignTextBuilderImpl;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.MoreTextBuilder;
import org.refcodes.textual.MoreTextBuilderImpl;
import org.refcodes.textual.MoreTextMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableStatus;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.TextBlockBuilder;
import org.refcodes.textual.TextBlockBuilderImpl;
import org.refcodes.textual.TextFormatMode;
import org.refcodes.textual.TextLineBuilderImpl;
import org.refcodes.textual.VertAlignTextBuilder;
import org.refcodes.textual.VertAlignTextBuilderImpl;
import org.refcodes.textual.VertAlignTextMode;

public class TableBuilderImpl
implements TableBuilder {
    private TableStatus _tableStatus = TableStatus.NONE;
    private List<ColumnRecord> _columnRecords = new ArrayList<ColumnRecord>();
    private int[] _columnWidths = null;
    private int _rowWidth = SystemUtility.toConsoleWidth();
    private TableStyle _tableStyle = TableStyle.SINGLE;
    private String _lineBreak = SystemUtility.getLineBreak();
    private PrintStream _printStream = System.out;
    private HorizAlignTextMode _headerAlignMode = HorizAlignTextMode.CENTER;
    private HorizAlignTextMode _rowAlignMode = HorizAlignTextMode.LEFT;
    private SplitTextMode _headerSplitMode = SplitTextMode.AT_SPACE;
    private SplitTextMode _rowSplitMode = SplitTextMode.AT_SPACE;
    private MoreTextMode _headerMoreMode = MoreTextMode.NONE;
    private MoreTextMode _rowMoreMode = MoreTextMode.NONE;
    private String _rowEscCode = null;
    private String _borderEscCode = null;
    private String _headerEscCode = null;
    private String _resetEscCode = AnsiEscapeCode.RESET.getCode();
    private boolean _hasLeftBorder = true;
    private boolean _hasRightBorder = true;
    private TextFormatMode _headerFormatMode = TextFormatMode.TEXT;
    private TextFormatMode _rowFormatMode = TextFormatMode.TEXT;
    private boolean _isEscCoddesEnabled = true;

    public TableBuilderImpl() {
    }

    public TableBuilderImpl(int aRowWidth) {
        this._rowWidth = aRowWidth;
    }

    public int getRowWidth() {
        return this._rowWidth;
    }

    @Override
    public TableStatus getTableStatus() {
        return this._tableStatus;
    }

    @Override
    public TableBuilder setTableStatus(TableStatus aTableStatus) {
        this._tableStatus = aTableStatus;
        return this;
    }

    @Override
    public TableBuilder withLeftBorder(boolean hasLeftBorder) {
        this._hasLeftBorder = hasLeftBorder;
        return this;
    }

    @Override
    public TableBuilder withRightBorder(boolean hasRightBorder) {
        this._hasRightBorder = hasRightBorder;
        return this;
    }

    public TableBuilder withRowWidth(int aRowWidth) {
        this._rowWidth = aRowWidth;
        this.updateColumnWidths();
        return this;
    }

    @Override
    public TableBuilder withTableStyle(TableStyle aTableStyle) {
        this._tableStyle = aTableStyle;
        return this;
    }

    @Override
    public TableBuilder withLineBreak(String aLineBreak) {
        this._lineBreak = aLineBreak;
        return this;
    }

    public PrintStream getPrintStream() {
        return this._printStream;
    }

    public void setPrintStream(PrintStream aPrintStream) {
        this._printStream = aPrintStream;
    }

    @Override
    public TableBuilder withEscapeCodes(boolean isEscCodesEnabled) {
        this._isEscCoddesEnabled = isEscCodesEnabled;
        return this;
    }

    @Override
    public TableBuilder withEscapeCode(String aAnsiEscCode) {
        this.withBorderEscapeCode(aAnsiEscCode);
        this.withTextEscapeCode(aAnsiEscCode);
        return this;
    }

    @Override
    public TableBuilder withBorderEscapeCode(String aAnsiEscCode) {
        this._borderEscCode = aAnsiEscCode;
        return this;
    }

    @Override
    public TableBuilder withTextEscapeCode(String aAnsiEscCode) {
        if (aAnsiEscCode != null) {
            if (aAnsiEscCode.length() > 0 && !aAnsiEscCode.startsWith(AnsiEscapeCode.ESC.getCode())) {
                throw new IllegalArgumentException("The provided ANSI Escape-Code does not start with \"" + AnsiEscapeCode.ESC.toEscaped() + "\".");
            }
            if (aAnsiEscCode.length() == 0) {
                throw new IllegalArgumentException("Either use null to reset the ANSI Escape-Code or provide a valid ANSI Escape-Code with a length > 0.");
            }
        }
        this._headerEscCode = aAnsiEscCode;
        this._rowEscCode = aAnsiEscCode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderEscapeCode(aAnsiEscCode);
            eRecord.setRowEscapeCode(aAnsiEscCode);
        }
        return this;
    }

    @Override
    public TableBuilder withHeaderEscapeCode(String aAnsiEscCode) {
        if (aAnsiEscCode != null) {
            if (aAnsiEscCode.length() > 0 && !aAnsiEscCode.startsWith(AnsiEscapeCode.ESC.getCode())) {
                throw new IllegalArgumentException("The provided ANSI Escape-Code does not start with \"" + AnsiEscapeCode.ESC.toEscaped() + "\".");
            }
            if (aAnsiEscCode.length() == 0) {
                throw new IllegalArgumentException("Either use null to reset the ANSI Escape-Code or provide a valid ANSI Escape-Code with a length > 0.");
            }
        }
        this._headerEscCode = aAnsiEscCode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderEscapeCode(aAnsiEscCode);
        }
        return this;
    }

    @Override
    public TableBuilder withRowEscapeCode(String aAnsiEscCode) {
        if (aAnsiEscCode != null) {
            if (aAnsiEscCode.length() > 0 && !aAnsiEscCode.startsWith(AnsiEscapeCode.ESC.getCode())) {
                throw new IllegalArgumentException("The provided ANSI Escape-Code does not start with \"" + AnsiEscapeCode.ESC.toEscaped() + "\".");
            }
            if (aAnsiEscCode.length() == 0) {
                throw new IllegalArgumentException("Either use null to reset the ANSI Escape-Code or provide a valid ANSI Escape-Code with a length > 0.");
            }
        }
        this._rowEscCode = aAnsiEscCode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setRowEscapeCode(aAnsiEscCode);
        }
        return this;
    }

    @Override
    public TableBuilder withTextColumnEscapeCode(String aAnsiEscCode) {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.setHeaderEscapeCode(aAnsiEscCode);
        theColumnRecord.setRowEscapeCode(aAnsiEscCode);
        return this;
    }

    @Override
    public TableBuilder withHeaderColumnEscapeCode(String aAnsiEscCode) {
        this.currentColumnRecord().setHeaderEscapeCode(aAnsiEscCode);
        return this;
    }

    @Override
    public TableBuilder withRowColumnEscapeCode(String aAnsiEscCode) {
        this.currentColumnRecord().setRowEscapeCode(aAnsiEscCode);
        return this;
    }

    @Override
    public TableBuilder withResetEscapeCode(String aAnsiEscCode) {
        this._resetEscCode = aAnsiEscCode;
        return this;
    }

    @Override
    public TableBuilder withHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this._headerAlignMode = aHorizAlignTextMode;
        this._rowAlignMode = aHorizAlignTextMode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderHorizAlignTextMode(aHorizAlignTextMode);
            eRecord.setRowHorizAlignTextMode(aHorizAlignTextMode);
        }
        return this;
    }

    @Override
    public TableBuilder withColumnHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.setHeaderHorizAlignTextMode(aHorizAlignTextMode);
        theColumnRecord.setRowHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    @Override
    public TableBuilder withHeaderColumnHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this.currentColumnRecord().setHeaderHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    @Override
    public TableBuilder withRowColumnHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this.currentColumnRecord().setRowHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    @Override
    public TableBuilder withHeaderHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this.currentColumnRecord().setHeaderHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    @Override
    public TableBuilder withRowHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this.currentColumnRecord().setRowHorizAlignTextMode(aHorizAlignTextMode);
        return this;
    }

    @Override
    public TableBuilder withTextFormatMode(TextFormatMode aTableFormatMode) {
        this._headerFormatMode = aTableFormatMode;
        this._rowFormatMode = aTableFormatMode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderTextFormatMode(aTableFormatMode);
            eRecord.setRowTextFormatMode(aTableFormatMode);
        }
        return this;
    }

    @Override
    public TableBuilder withColumnTextFormatMode(TextFormatMode aTableFormatMode) {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.setHeaderTextFormatMode(aTableFormatMode);
        theColumnRecord.setRowTextFormatMode(aTableFormatMode);
        return this;
    }

    @Override
    public TableBuilder withHeaderColumnTextFormatMode(TextFormatMode aTableFormatMode) {
        this.currentColumnRecord().setHeaderTextFormatMode(aTableFormatMode);
        return this;
    }

    @Override
    public TableBuilder withRowColumnTextFormatMode(TextFormatMode aTableFormatMode) {
        this.currentColumnRecord().setRowTextFormatMode(aTableFormatMode);
        return this;
    }

    @Override
    public TableBuilder withHeaderTextFormatMode(TextFormatMode aTableFormatMode) {
        this.currentColumnRecord().setHeaderTextFormatMode(aTableFormatMode);
        return this;
    }

    @Override
    public TableBuilder withRowTextFormatMode(TextFormatMode aTableFormatMode) {
        this.currentColumnRecord().setRowTextFormatMode(aTableFormatMode);
        return this;
    }

    @Override
    public TableBuilder withSplitTextMode(SplitTextMode aLineSplitMode) {
        this._headerSplitMode = aLineSplitMode;
        this._rowSplitMode = aLineSplitMode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderSplitTextMode(aLineSplitMode);
            eRecord.setRowSplitTextMode(aLineSplitMode);
        }
        return this;
    }

    @Override
    public TableBuilder withColumnSplitTextMode(SplitTextMode aLineSplitMode) {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.setHeaderSplitTextMode(aLineSplitMode);
        theColumnRecord.setRowSplitTextMode(aLineSplitMode);
        return this;
    }

    @Override
    public TableBuilder withHeaderColumnSplitTextMode(SplitTextMode aLineSplitMode) {
        this.currentColumnRecord().setHeaderSplitTextMode(aLineSplitMode);
        return this;
    }

    @Override
    public TableBuilder withRowColumnSplitTextMode(SplitTextMode aLineSplitMode) {
        this.currentColumnRecord().setRowSplitTextMode(aLineSplitMode);
        return this;
    }

    @Override
    public TableBuilder withHeaderSplitTextMode(SplitTextMode aLineSplitMode) {
        this.currentColumnRecord().setHeaderSplitTextMode(aLineSplitMode);
        return this;
    }

    @Override
    public TableBuilder withRowSplitTextMode(SplitTextMode aLineSplitMode) {
        this.currentColumnRecord().setRowSplitTextMode(aLineSplitMode);
        return this;
    }

    @Override
    public TableBuilder withMoreTextMode(MoreTextMode aMoreTextMode) {
        this._headerMoreMode = aMoreTextMode;
        this._rowMoreMode = aMoreTextMode;
        for (ColumnRecord eRecord : this._columnRecords) {
            eRecord.setHeaderMoreTextMode(aMoreTextMode);
            eRecord.setRowMoreTextMode(aMoreTextMode);
        }
        return this;
    }

    @Override
    public TableBuilder withColumnMoreTextMode(MoreTextMode aMoreTextMode) {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.setHeaderMoreTextMode(aMoreTextMode);
        theColumnRecord.setRowMoreTextMode(aMoreTextMode);
        return this;
    }

    @Override
    public TableBuilder withHeaderColumnMoreTextMode(MoreTextMode aMoreTextMode) {
        this.currentColumnRecord().setHeaderMoreTextMode(aMoreTextMode);
        return this;
    }

    @Override
    public TableBuilder withRowColumnMoreTextMode(MoreTextMode aMoreTextMode) {
        this.currentColumnRecord().setRowMoreTextMode(aMoreTextMode);
        return this;
    }

    @Override
    public TableBuilder withHeaderMoreTextMode(MoreTextMode aMoreTextMode) {
        this.currentColumnRecord().setHeaderMoreTextMode(aMoreTextMode);
        return this;
    }

    @Override
    public TableBuilder withRowMoreTextMode(MoreTextMode aMoreTextMode) {
        this.currentColumnRecord().setRowMoreTextMode(aMoreTextMode);
        return this;
    }

    @Override
    public TableBuilder addColumn() {
        this._columnRecords.add(new ColumnRecord());
        this._columnWidths = null;
        return this;
    }

    @Override
    public TableBuilder withColumnWidth(int aWidth, ColumnWidthType aWidthType) throws IllegalStateException {
        this.currentColumnRecord().setColumnWidth(aWidth);
        this.currentColumnRecord().setColumnWidthType(aWidthType);
        this._columnWidths = null;
        return this;
    }

    @Override
    public TableBuilder withColumnWidth(int aColumnWidth) throws IllegalStateException {
        return this.withColumnWidth(aColumnWidth, ColumnWidthType.ABSOLUTE);
    }

    @Override
    public TableBuilder withColumnWidthMetrics(ColumnWidthMetrics aColumnWidthMetrics) throws IllegalStateException {
        this.currentColumnRecord().setColumnWidth(aColumnWidthMetrics.getColumnWidth());
        this.currentColumnRecord().setColumnWidthType(aColumnWidthMetrics.getColumnWidthType());
        this._columnWidths = null;
        return this;
    }

    @Override
    public TableBuilder withColumnFormatMetrics(ColumnFormatMetrics aColumnFormatMetrics) throws IllegalStateException {
        ColumnRecord theColumnRecord = this.currentColumnRecord();
        theColumnRecord.fromColumnFormatMetrics(aColumnFormatMetrics);
        this._columnWidths = null;
        return this;
    }

    @Override
    public String toHeaderBegin() {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column before printing the header.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnTopBorder(this._columnWidths, TableSection.HEADER, theBuilder);
        this._tableStatus = TableStatus.HEADER_BEGIN;
        return theBuilder.toString();
    }

    @Override
    public String toHeaderContinue(String ... aColumns) {
        if (this._columnRecords.size() == 0) {
            for (int i = 0; i < aColumns.length; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnLine(this._columnWidths, TableSection.HEADER, theBuilder, aColumns);
        this._tableStatus = TableStatus.HEADER_CONTINUE;
        return theBuilder.toString();
    }

    @Override
    public String toHeaderEnd(TableBuilder aTablePrinter) {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column to this table printer before joining the tables.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        if (aTablePrinter.toColumnWidths().length == 0) {
            throw new IllegalStateException("You must add least a column to the provided table printer before joining the tables.");
        }
        StringBuilder theBuilder = new StringBuilder();
        this.joinRow(aTablePrinter, TableSection.HEADER, theBuilder);
        return theBuilder.toString();
    }

    @Override
    public String toHeaderEnd() {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column before printing the header.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnBottomBorder(this._columnWidths, TableSection.HEADER, theBuilder);
        this._tableStatus = TableStatus.HEADER_END;
        return theBuilder.toString();
    }

    @Override
    public String toRowBegin() {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column before printing the header.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnTopBorder(this._columnWidths, TableSection.BODY, theBuilder);
        this._tableStatus = TableStatus.ROW_BEGIN;
        return theBuilder.toString();
    }

    @Override
    public String toRowContinue(String ... aColumns) {
        if (this._columnRecords.size() == 0 && this._columnRecords.size() == 0) {
            for (int i = 0; i < aColumns.length; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnLine(this._columnWidths, TableSection.BODY, theBuilder, aColumns);
        this._tableStatus = TableStatus.ROW_CONTINUE;
        return theBuilder.toString();
    }

    @Override
    public String toRowEnd(TableBuilder aTablePrinter) {
        if (this._columnRecords.size() == 0) {
            throw new IllegalStateException("You must add least a column to this table printer before joining the tables.");
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        if (aTablePrinter.toColumnWidths().length == 0) {
            throw new IllegalStateException("You must add least a column to the provided table printer before joining the tables.");
        }
        StringBuilder theBuilder = new StringBuilder();
        this.joinRow(aTablePrinter, TableSection.BODY, theBuilder);
        return theBuilder.toString();
    }

    @Override
    public String toHeader(String ... aColumns) {
        if (this._columnRecords.size() < aColumns.length) {
            int theAdd = aColumns.length - this._columnRecords.size();
            for (int i = 0; i < theAdd; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        this.printlnTopBorder(this._columnWidths, TableSection.HEADER, theBuilder);
        this.printlnLine(this._columnWidths, TableSection.HEADER, theBuilder, aColumns);
        this._tableStatus = TableStatus.HEADER_CONTINUE;
        return theBuilder.toString();
    }

    @Override
    public String toRow(String ... aColumns) {
        if (this._columnRecords.size() == 0 && this._columnRecords.size() == 0) {
            for (int i = 0; i < aColumns.length; ++i) {
                this.addColumn();
            }
        }
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        StringBuilder theBuilder = new StringBuilder();
        if (this._tableStatus == TableStatus.NONE) {
            this.printlnTopBorder(this._columnWidths, TableSection.BODY, theBuilder);
        } else if (this._tableStatus == TableStatus.ROW_CONTINUE) {
            this.printlnTopBorder(this._columnWidths, TableSection.BODY, theBuilder);
        } else if (this._tableStatus == TableStatus.HEADER_CONTINUE) {
            this.printlnTopBorder(this._columnWidths, TableSection.HEADER, theBuilder);
        }
        this.printlnLine(this._columnWidths, TableSection.BODY, theBuilder, aColumns);
        this._tableStatus = TableStatus.ROW_CONTINUE;
        return theBuilder.toString();
    }

    @Override
    public String toTail() {
        StringBuilder theBuilder = new StringBuilder();
        this.printlnBottomBorder(this._columnWidths, TableSection.TAIL, theBuilder);
        return theBuilder.toString();
    }

    @Override
    public int[] toColumnWidths() {
        if (this._columnWidths == null) {
            this.updateColumnWidths();
        }
        return this._columnWidths;
    }

    public static String[][] toColumns(String[][] aColumns, VertAlignTextMode aTextBlockMode) {
        int theMaxLines = TableBuilderImpl.toMaxLength(aColumns);
        String[][] theColumns = new String[aColumns.length][];
        for (int i = 0; i < aColumns.length; ++i) {
            theColumns[i] = ((VertAlignTextBuilder)((VertAlignTextBuilder)new VertAlignTextBuilderImpl().withText(aColumns[i])).withRowHeight(theMaxLines)).withVertAlignTextMode(aTextBlockMode).toStrings();
        }
        return theColumns;
    }

    protected static int[] toColumnWidths(int aTotalWidth, ColumnWidthMetrics ... aColumnWidths) {
        int i;
        int theNumCharWidths = -1;
        int theRelativeWidths = -1;
        block8: for (ColumnWidthMetrics columnWidthMetrics : aColumnWidths) {
            switch (columnWidthMetrics.getColumnWidthType()) {
                case ABSOLUTE: {
                    if (theNumCharWidths == -1) {
                        theNumCharWidths = columnWidthMetrics.getColumnWidth();
                        continue block8;
                    }
                    theNumCharWidths += columnWidthMetrics.getColumnWidth();
                    continue block8;
                }
                case RELATIVE: {
                    if (theRelativeWidths == -1) {
                        theRelativeWidths = columnWidthMetrics.getColumnWidth();
                        continue block8;
                    }
                    theRelativeWidths += columnWidthMetrics.getColumnWidth();
                    continue block8;
                }
                default: {
                    throw new BugException("Someone exteded the <ColumnWidthType> enumeration with an additional enumeration value not supported by this method.");
                }
            }
        }
        if (theNumCharWidths < aTotalWidth && theRelativeWidths == -1) {
            throw new IllegalArgumentException("Your provided overall number of char width <" + theNumCharWidths + "> does not add up to the total width avaialbale of <" + aTotalWidth + "> and you did not specify an percent (%) width to fill up the missing gap.");
        }
        if (theNumCharWidths > aTotalWidth) {
            throw new IllegalArgumentException("The total width avaialble <" + aTotalWidth + "> is exceeded by the provided overall number of char widths <" + theNumCharWidths + "> requested.");
        }
        int[] theColumnWidths = new int[aColumnWidths.length];
        int theRemainderWidth = aTotalWidth - theNumCharWidths;
        int theMaxRelativeWidth = 0;
        for (ColumnWidthMetrics eColumnWidth : aColumnWidths) {
            if (eColumnWidth.getColumnWidthType() != ColumnWidthType.RELATIVE) continue;
            theMaxRelativeWidth += eColumnWidth.getColumnWidth();
        }
        block10: for (i = 0; i < aColumnWidths.length; ++i) {
            ColumnWidthMetrics columnWidthMetrics = aColumnWidths[i];
            switch (columnWidthMetrics.getColumnWidthType()) {
                case ABSOLUTE: {
                    theColumnWidths[i] = columnWidthMetrics.getColumnWidth();
                    continue block10;
                }
                case RELATIVE: {
                    theColumnWidths[i] = (int)((double)theRemainderWidth / (double)theMaxRelativeWidth * (double)columnWidthMetrics.getColumnWidth());
                    continue block10;
                }
                default: {
                    throw new BugException("Someone exteded the <ColumnWidthType> enumeration with an additional enumeration value not supported by this method.");
                }
            }
        }
        block11: while (NumericalUtility.sum((int[])theColumnWidths) < aTotalWidth) {
            for (i = 0; i < theColumnWidths.length; ++i) {
                if (aColumnWidths[i].getColumnWidthType() != ColumnWidthType.RELATIVE) continue;
                int n = i;
                theColumnWidths[n] = theColumnWidths[n] + 1;
                if (NumericalUtility.sum((int[])theColumnWidths) == aTotalWidth) break block11;
            }
        }
        block13: while (NumericalUtility.sum((int[])theColumnWidths) > aTotalWidth) {
            i = 0;
            while (i < theColumnWidths.length) {
                int n = i++;
                theColumnWidths[n] = theColumnWidths[n] - 1;
                if (NumericalUtility.sum((int[])theColumnWidths) == aTotalWidth) break block13;
            }
        }
        block15: while (NumericalUtility.sum((int[])theColumnWidths) < aTotalWidth) {
            i = 0;
            while (i < theColumnWidths.length) {
                int n = i++;
                theColumnWidths[n] = theColumnWidths[n] + 1;
                if (NumericalUtility.sum((int[])theColumnWidths) == aTotalWidth) break block15;
            }
        }
        return theColumnWidths;
    }

    private void updateColumnWidths() {
        if (this._columnRecords.isEmpty()) {
            return;
        }
        int theWidth = this._rowWidth - (this._columnRecords.size() + 1);
        if (!this._hasLeftBorder) {
            ++theWidth;
        }
        if (!this._hasRightBorder) {
            ++theWidth;
        }
        this._columnWidths = TableBuilderImpl.toColumnWidths(theWidth, this._columnRecords.toArray(new ColumnRecord[this._columnRecords.size()]));
    }

    private ColumnRecord currentColumnRecord() {
        int columnSize = this._columnRecords.size();
        if (columnSize == 0) {
            this.addColumn();
            ++columnSize;
        }
        ColumnRecord theColumnRecord = this._columnRecords.get(columnSize - 1);
        return theColumnRecord;
    }

    private void printlnTopBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        this.printTopBorder(aColumnWidths, aTableSection, aBuilder);
        aBuilder.append(this._lineBreak);
    }

    private void printTopBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        this.appendAnsiBorder(aBuilder);
        this.buildTopBorder(aColumnWidths, aTableSection, aBuilder);
        this.appendAnsiReset(aBuilder);
    }

    private void buildTopBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        TableHeader<Character> theLineStyle;
        Object object = theLineStyle = aTableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getBody();
        if (this._hasLeftBorder) {
            if (this._tableStatus == TableStatus.NONE || this._tableStatus == TableStatus.ROW_END) {
                aBuilder.append(theLineStyle.getTopLeftEdge());
            } else {
                aBuilder.append(theLineStyle.getLeftEdge());
            }
        }
        for (int i = 0; i < aColumnWidths.length; ++i) {
            if (i > 0) {
                if (this._tableStatus == TableStatus.NONE || this._tableStatus == TableStatus.ROW_END) {
                    aBuilder.append(theLineStyle.getTopDividerEdge());
                } else {
                    aBuilder.append(theLineStyle.getDividerEdge());
                }
            }
            aBuilder.append(new TextLineBuilderImpl().withColumnWidth(aColumnWidths[i]).withLineChar(((Character)theLineStyle.getTopLine()).charValue()).toString());
        }
        if (this._hasRightBorder) {
            if (this._tableStatus == TableStatus.NONE || this._tableStatus == TableStatus.ROW_END) {
                aBuilder.append(theLineStyle.getTopRightEdge());
            } else {
                aBuilder.append(theLineStyle.getRightEdge());
            }
        }
    }

    private void printlnLine(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder, String ... aColumns) {
        int j;
        int i;
        if (this._columnRecords.size() != aColumns.length) {
            throw new IllegalStateException("You have passed <" + aColumns.length + "> column text arguments, you have added <" + this._columnRecords.size() + "> columns, though you must pass as many column text arguments as you have added columns.");
        }
        TableHeader<Character> theLineStyle = aTableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getBody();
        String[][] theColumns = new String[aColumns.length][];
        for (i = 0; i < aColumns.length; ++i) {
            aColumns[i] = ((MoreTextBuilder)new MoreTextBuilderImpl().withText(new String[]{aColumns[i]})).withColumnWidth(aColumnWidths[i]).withMoreText("" + Truncate.MORE_TEXT_BEFORE.getChar()).withMoreTextMode(this._columnRecords.get(i).getMoreTextMode(aTableSection)).toString();
            theColumns[i] = ((TextBlockBuilder)((TextBlockBuilder)new TextBlockBuilderImpl().withText(new String[]{aColumns[i]})).withColumnWidth(aColumnWidths[i])).withSplitTextMode(this._columnRecords.get(i).getSplitTextMode(aTableSection)).withHorizAlignTextMode(this._columnRecords.get(i).getHorizAlignTextMode(aTableSection)).toStrings();
            if (theColumns[i] == null) {
                theColumns[i] = new String[]{""};
            }
            for (j = 0; j < theColumns[i].length; ++j) {
                theColumns[i][j] = HorizAlignTextBuilderImpl.toAlign(theColumns[i][j], aColumnWidths[i], ' ', this._columnRecords.get(i).getHorizAlignTextMode(aTableSection));
            }
        }
        theColumns = TableBuilderImpl.toColumns(theColumns, VertAlignTextMode.TOP);
        for (i = 0; i < theColumns.length; ++i) {
            theColumns[i] = this.toAnsiColumn(this._columnRecords.get(i), aTableSection, theColumns[i], aColumns[i]);
        }
        for (i = 0; i < theColumns[0].length; ++i) {
            if (this._hasLeftBorder) {
                this.appendAnsiBorder(aBuilder);
                aBuilder.append(theLineStyle.getLeftLine());
                this.appendAnsiReset(aBuilder);
            }
            for (j = 0; j < theColumns.length; ++j) {
                if (j > 0) {
                    this.appendAnsiBorder(aBuilder);
                    aBuilder.append(theLineStyle.getDividerLine());
                    this.appendAnsiReset(aBuilder);
                }
                aBuilder.append(theColumns[j][i]);
            }
            if (this._hasRightBorder) {
                this.appendAnsiBorder(aBuilder);
                aBuilder.append(theLineStyle.getRightLine());
                this.appendAnsiReset(aBuilder);
            }
            aBuilder.append(this._lineBreak);
        }
    }

    private void printlnBottomBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        this.printBottomBorder(aColumnWidths, aTableSection, aBuilder);
        aBuilder.append(this._lineBreak);
    }

    private void printBottomBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        this.appendAnsiBorder(aBuilder);
        this.buildBottomBorder(aColumnWidths, aTableSection, aBuilder);
        this.appendAnsiReset(aBuilder);
    }

    private void buildBottomBorder(int[] aColumnWidths, TableSection aTableSection, StringBuilder aBuilder) {
        TableHeader<Character> theTableStyle;
        Object object = theTableStyle = aTableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getTail();
        if (this._hasLeftBorder) {
            aBuilder.append(theTableStyle.getBottomLeftEdge());
        }
        for (int i = 0; i < aColumnWidths.length; ++i) {
            if (i > 0) {
                aBuilder.append(theTableStyle.getBottomDividerEdge());
            }
            aBuilder.append(new TextLineBuilderImpl().withColumnWidth(aColumnWidths[i]).withLineChar(((Character)theTableStyle.getBottomLine()).charValue()).toString());
        }
        if (this._hasRightBorder) {
            aBuilder.append(theTableStyle.getBottomRightEdge());
        }
    }

    private String[] toAnsiColumn(ColumnRecord aColumnRecord, TableSection aTableSection, String[] aColumns, String aIdentifier) {
        String theEscCode;
        if (this._isEscCoddesEnabled && (theEscCode = aColumnRecord.toEscapeCode(aTableSection, aIdentifier)) != null) {
            block0: for (int i = 0; i < aColumns.length; ++i) {
                if (aColumnRecord.getTextFormatMode(aTableSection) == TextFormatMode.TEXT) {
                    int j;
                    if (aColumns[i].length() > 0) {
                        if (aColumns[i].charAt(0) != ' ') {
                            aColumns[i] = theEscCode + aColumns[i];
                        } else {
                            for (j = 0; j < aColumns[i].length(); ++j) {
                                if (aColumns[i].charAt(j) == ' ') continue;
                                aColumns[i] = aColumns[i].substring(0, j) + theEscCode + aColumns[i].substring(j);
                                break;
                            }
                        }
                    }
                    if (aColumns[i].charAt(aColumns[i].length() - 1) != ' ') {
                        aColumns[i] = aColumns[i] + this._resetEscCode;
                        continue;
                    }
                    for (j = aColumns[i].length() - 1; j >= 0; --j) {
                        if (aColumns[i].charAt(j) == ' ') continue;
                        aColumns[i] = aColumns[i].substring(0, j + 1) + this._resetEscCode + aColumns[i].substring(j + 1);
                        continue block0;
                    }
                    continue;
                }
                if (aColumnRecord.getTextFormatMode(aTableSection) != TextFormatMode.CELL) continue;
                aColumns[i] = theEscCode + aColumns[i] + this._resetEscCode;
            }
        }
        return aColumns;
    }

    private void appendAnsiBorder(StringBuilder aBuilder) {
        if (this._isEscCoddesEnabled && this._borderEscCode != null) {
            aBuilder.append(this._borderEscCode);
        }
    }

    private void appendAnsiReset(StringBuilder aBuilder) {
        if (this._isEscCoddesEnabled && this._borderEscCode != null) {
            aBuilder.append(this._resetEscCode);
        }
    }

    private void joinRow(TableBuilder aTablePrinter, TableSection aTableSection, StringBuilder aBuilder) {
        int i;
        StringBuilder theShortBuilder;
        StringBuilder theLongBuilder;
        this._tableStatus = TableStatus.ROW_END;
        TableHeader<Character> theTableStyle = aTableSection == TableSection.HEADER ? this._tableStyle.getHeader() : this._tableStyle.getBody();
        StringBuilder theTopBuilder = new StringBuilder();
        this.buildTopBorder(this.toColumnWidths(), aTableSection, theTopBuilder);
        StringBuilder theBottomBuilder = new StringBuilder();
        this.buildTopBorder(aTablePrinter.toColumnWidths(), aTableSection, theBottomBuilder);
        if (theBottomBuilder.length() < theTopBuilder.length()) {
            theLongBuilder = theTopBuilder;
            theShortBuilder = theBottomBuilder;
        } else {
            theShortBuilder = theTopBuilder;
            theLongBuilder = theBottomBuilder;
        }
        if (this._hasLeftBorder) {
            theLongBuilder.replace(0, 1, "" + theTableStyle.getLeftEdge());
        }
        for (i = 1; i < theShortBuilder.length() - 1; ++i) {
            if (theShortBuilder.charAt(i) != theLongBuilder.charAt(i)) {
                if (theBottomBuilder.charAt(i) == ((Character)theTableStyle.getTopLine()).charValue()) {
                    theLongBuilder.replace(i, i + 1, "" + theTopBuilder.charAt(i));
                    continue;
                }
                if (theTopBuilder.charAt(i) != ((Character)theTableStyle.getTopLine()).charValue()) continue;
                theLongBuilder.replace(i, i + 1, "" + theTableStyle.getBottomDividerEdge());
                continue;
            }
            if (theTopBuilder.charAt(i) == ((Character)theTableStyle.getTopLine()).charValue()) continue;
            theLongBuilder.replace(i, i + 1, "" + theTableStyle.getDividerEdge());
        }
        if (theShortBuilder.length() != theLongBuilder.length()) {
            if (theShortBuilder.charAt(theShortBuilder.length() - 1) != theLongBuilder.charAt(theShortBuilder.length() - 1)) {
                if (theShortBuilder == theTopBuilder) {
                    if (theLongBuilder.charAt(theShortBuilder.length() - 1) == ((Character)theTableStyle.getTopDividerEdge()).charValue()) {
                        theLongBuilder.replace(theShortBuilder.length() - 1, theShortBuilder.length(), "" + theTableStyle.getDividerEdge());
                    } else {
                        theLongBuilder.replace(theShortBuilder.length() - 1, theShortBuilder.length(), "" + theTableStyle.getTopDividerEdge());
                    }
                    if (this._hasRightBorder) {
                        theLongBuilder.replace(theLongBuilder.length() - 1, theLongBuilder.length(), "" + theTableStyle.getBottomRightEdge());
                    }
                } else if (theLongBuilder.charAt(theShortBuilder.length() - 1) == ((Character)theTableStyle.getTopDividerEdge()).charValue()) {
                    theLongBuilder.replace(theShortBuilder.length() - 1, theShortBuilder.length(), "" + theTableStyle.getDividerEdge());
                } else {
                    theLongBuilder.replace(theShortBuilder.length() - 1, theShortBuilder.length(), "" + theTableStyle.getBottomDividerEdge());
                }
            }
            if (theLongBuilder == theBottomBuilder) {
                for (i = theShortBuilder.length(); i < theLongBuilder.length() - 1; ++i) {
                    if (theLongBuilder.charAt(i) != ((Character)theTableStyle.getTopDividerEdge()).charValue()) continue;
                    theLongBuilder.replace(i, i + 1, "" + theTableStyle.getBottomDividerEdge());
                }
            }
        } else if (this._hasRightBorder) {
            theLongBuilder.replace(theLongBuilder.length() - 1, theLongBuilder.length(), "" + theTableStyle.getRightEdge());
        }
        this.appendAnsiBorder(aBuilder);
        aBuilder.append(theLongBuilder.toString());
        this.appendAnsiReset(aBuilder);
        aBuilder.append(this._lineBreak);
    }

    @SafeVarargs
    private static <T> int toMaxLength(T[] ... aObjects) {
        int theMaxLength = -1;
        for (T[] eArray : aObjects) {
            if (eArray == null || eArray.length <= theMaxLength) continue;
            theMaxLength = eArray.length;
        }
        return theMaxLength;
    }

    private class ColumnRecord
    extends ColumnFormatMetricsImpl {
        public ColumnRecord() {
            super(1, ColumnWidthType.RELATIVE);
            this.setHeaderHorizAlignTextMode(TableBuilderImpl.this._headerAlignMode);
            this.setRowHorizAlignTextMode(TableBuilderImpl.this._rowAlignMode);
            this.setHeaderSplitTextMode(TableBuilderImpl.this._headerSplitMode);
            this.setRowSplitTextMode(TableBuilderImpl.this._rowSplitMode);
            this.setHeaderEscapeCode(TableBuilderImpl.this._headerEscCode);
            this.setRowEscapeCode(TableBuilderImpl.this._rowEscCode);
            this.setHeaderTextFormatMode(TableBuilderImpl.this._headerFormatMode);
            this.setRowTextFormatMode(TableBuilderImpl.this._rowFormatMode);
            this.setHeaderMoreTextMode(TableBuilderImpl.this._headerMoreMode);
            this.setRowMoreTextMode(TableBuilderImpl.this._rowMoreMode);
        }

        private HorizAlignTextMode getHorizAlignTextMode(TableSection aTableSection) {
            if (aTableSection == TableSection.HEADER) {
                return this.getHeaderHorizAlignTextMode();
            }
            if (aTableSection == TableSection.BODY) {
                return this.getRowHorizAlignTextMode();
            }
            throw new RuntimeException("Unknown table section <" + aTableSection + ">, allowed values are <" + TableSection.HEADER + "> and <" + TableSection.BODY + ">.");
        }

        private SplitTextMode getSplitTextMode(TableSection aTableSection) {
            if (aTableSection == TableSection.HEADER) {
                return this.getHeaderSplitTextMode();
            }
            if (aTableSection == TableSection.BODY) {
                return this.getRowSplitTextMode();
            }
            throw new RuntimeException("Unknown table section <" + aTableSection + ">, allowed values are <" + TableSection.HEADER + "> and <" + TableSection.BODY + ">.");
        }

        private String toEscapeCode(TableSection aTableSection, String aIdentifier) {
            if (aTableSection == TableSection.HEADER) {
                return this.toHeaderEscapeCode(aIdentifier);
            }
            if (aTableSection == TableSection.BODY) {
                return this.toRowEscapeCode(aIdentifier);
            }
            throw new RuntimeException("Unknown table section <" + aTableSection + ">, allowed values are <" + TableSection.HEADER + "> and <" + TableSection.BODY + ">.");
        }

        private TextFormatMode getTextFormatMode(TableSection aTableSection) {
            if (aTableSection == TableSection.HEADER) {
                return this.getHeaderTextFormatMode();
            }
            if (aTableSection == TableSection.BODY) {
                return this.getRowTextFormatMode();
            }
            throw new RuntimeException("Unknown table section <" + aTableSection + ">, allowed values are <" + TableSection.HEADER + "> and <" + TableSection.BODY + ">.");
        }

        private MoreTextMode getMoreTextMode(TableSection aTableSection) {
            if (aTableSection == TableSection.HEADER) {
                return this.getHeaderMoreTextMode();
            }
            if (aTableSection == TableSection.BODY) {
                return this.getRowMoreTextMode();
            }
            throw new RuntimeException("Unknown table section <" + aTableSection + ">, allowed values are <" + TableSection.HEADER + "> and <" + TableSection.BODY + ">.");
        }
    }

    private static enum TableSection {
        HEADER,
        BODY,
        TAIL;

    }
}

