/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.refcodes.data.CharSet;
import org.refcodes.runtime.SystemUtility;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextBuilderImpl;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TextBlockBuilder;
import org.refcodes.textual.TextLineBuilder;
import org.refcodes.textual.TextLineBuilderImpl;

public class TextBlockBuilderImpl
extends AbstractText<TextBlockBuilder>
implements TextBlockBuilder {
    protected static final String NO_SINGLE_LINE_CHARS = new String(new char[]{'\t', '\n', '\r'});
    private int _columnWidth = SystemUtility.toConsoleWidth();
    private HorizAlignTextMode _alignTextMode = HorizAlignTextMode.LEFT;
    private SplitTextMode _splitTextMode = SplitTextMode.AT_SPACE;

    public TextBlockBuilder withColumnWidth(int aColumnWidth) {
        this.setColumnWidth(aColumnWidth);
        return this;
    }

    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public void setHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this._alignTextMode = aHorizAlignTextMode;
    }

    @Override
    public HorizAlignTextMode getHorizAlignTextMode() {
        return this._alignTextMode;
    }

    @Override
    public SplitTextMode getSplitTextMode() {
        return this._splitTextMode;
    }

    @Override
    public void setSplitTextMode(SplitTextMode aSplitTextMode) {
        this._splitTextMode = aSplitTextMode;
    }

    @Override
    public String[] toStrings() {
        return this.toStrings(this.getText());
    }

    @Override
    public String[] toStrings(String ... aText) {
        ArrayList<String> theText = new ArrayList<String>();
        for (int i = 0; i < aText.length; ++i) {
            String eLine = aText[i];
            Collections.addAll(theText, TextBlockBuilderImpl.toTextBlock(eLine, this.getColumnWidth(), this.getHorizAlignTextMode(), this.getSplitTextMode()));
            if (i >= aText.length - 1) continue;
            theText.add(((TextLineBuilder)new TextLineBuilderImpl().withLineChar(' ').withColumnWidth(((String)theText.get(0)).length())).toString());
        }
        return theText.toArray(new String[theText.size()]);
    }

    protected static String[] toTextBlock(String aText, int aLength) {
        return TextBlockBuilderImpl.toTextBlock(aText, aLength, null, null);
    }

    protected static String[] toTextBlock(String aText, int aLength, SplitTextMode aLineSplitMode) {
        return TextBlockBuilderImpl.toTextBlock(aText, aLength, null, aLineSplitMode);
    }

    protected static String[] toTextBlock(String aText, int aLength, HorizAlignTextMode aHorizAlignTextMode) {
        return TextBlockBuilderImpl.toTextBlock(aText, aLength, aHorizAlignTextMode, null);
    }

    protected static String[] toTextBlock(String aText, int aLength, HorizAlignTextMode aHorizAlignTextMode, SplitTextMode aLineSplitMode) {
        if (aText == null) {
            return null;
        }
        if (aLineSplitMode == null) {
            aLineSplitMode = SplitTextMode.AT_FIXED_WIDTH;
        }
        switch (aLineSplitMode) {
            case AT_END_OF_LINE: {
                return TextBlockBuilderImpl.toSplitAtEndOfLineTextBlock(aText, aLength, aHorizAlignTextMode);
            }
            case AT_FIRST_END_OF_LINE: {
                return TextBlockBuilderImpl.toSplitAtFirstEndOfLineTextBlock(aText, aLength, aHorizAlignTextMode);
            }
            case AT_SPACE: {
                return TextBlockBuilderImpl.toSplitAtSpaceTextBlock(aText, aLength, aHorizAlignTextMode);
            }
        }
        return TextBlockBuilderImpl.toSplitAtFixedWidthTextBlock(aText, aLength, aHorizAlignTextMode);
    }

    protected static String toNonBreakingLine(String aText) {
        if (aText == null) {
            return null;
        }
        StringBuffer theStringBuffer = new StringBuffer();
        StringTokenizer e = new StringTokenizer(aText, NO_SINGLE_LINE_CHARS);
        while (e.hasMoreTokens()) {
            String eText = e.nextToken();
            theStringBuffer.append(eText);
            if (!e.hasMoreTokens() || theStringBuffer.length() <= 0 || theStringBuffer.charAt(theStringBuffer.length() - 1) == ' ') continue;
            boolean hasEndOfLineChar = false;
            for (int i = 0; i < CharSet.LINE_BREAK_MARKERS.getCharSet().length; ++i) {
                if (theStringBuffer.charAt(theStringBuffer.length() - 1) != CharSet.LINE_BREAK_MARKERS.getCharSet()[i]) continue;
                hasEndOfLineChar = true;
                break;
            }
            if (!hasEndOfLineChar) {
                theStringBuffer.append('.');
            }
            theStringBuffer.append(' ');
        }
        return theStringBuffer.toString();
    }

    private static String[] toSplitAtSpaceTextBlock(String aText, int aLength, HorizAlignTextMode aHorizAlignTextMode) {
        String[] theSubstringArray;
        ArrayList<String> theStringList = new ArrayList<String>();
        String eText = TextBlockBuilderImpl.toNonBreakingLine(aText);
        while (eText.length() > aLength) {
            eText = TextBlockBuilderImpl.toTruncatePrefixedSpaces(eText);
            String eSubstring = TextBlockBuilderImpl.toLastSpaceIndex(eText, aLength);
            eSubstring = TextBlockBuilderImpl.toTruncateTrailingSpaces(eSubstring);
            theStringList.add(((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(aHorizAlignTextMode).withText(new String[]{eSubstring})).withColumnWidth(aLength)).withFillChar(' ').toString());
            eText = eText.substring(eSubstring.length());
        }
        if (eText.length() > 0) {
            eText = TextBlockBuilderImpl.toTruncatePrefixedSpaces(eText);
            if ((eText = TextBlockBuilderImpl.toTruncateTrailingSpaces(eText)).length() > 0) {
                theStringList.add(((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(aHorizAlignTextMode).withText(new String[]{eText})).withColumnWidth(aLength)).withFillChar(' ').toString());
            }
        }
        if (theStringList.size() == 0) {
            theSubstringArray = new String[]{aText};
        } else {
            theSubstringArray = new String[theStringList.size()];
            for (int i = 0; i < theSubstringArray.length; ++i) {
                theSubstringArray[i] = (String)theStringList.get(i);
            }
        }
        return theSubstringArray;
    }

    private static String toLastSpaceIndex(String aText, int aLength) {
        int eLength = aLength;
        block0: for (int i = 0; i < aLength + 1; ++i) {
            if (aText.length() <= i) continue;
            for (int l = 0; l < CharSet.SPACE_MARKERS.getCharSet().length; ++l) {
                if (aText.charAt(i) != CharSet.SPACE_MARKERS.getCharSet()[l]) continue;
                eLength = i + 1;
                continue block0;
            }
        }
        return aText.substring(0, eLength);
    }

    private static String[] toSplitAtFixedWidthTextBlock(String aText, int aLength, HorizAlignTextMode aHorizAlignTextMode) {
        String[] theSubstringArray;
        ArrayList<String> theStringList = new ArrayList<String>();
        String eText = aText;
        while (eText.length() > aLength) {
            String eSubstring = eText.substring(0, aLength);
            eText = eText.substring(aLength);
            theStringList.add(((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withText(new String[]{eSubstring})).withColumnWidth(aLength)).withFillChar(' ').withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (eText.length() > 0) {
            theStringList.add(((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withText(new String[]{eText})).withColumnWidth(aLength)).withFillChar(' ').withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (theStringList.size() == 0) {
            theSubstringArray = new String[]{aText};
        } else {
            theSubstringArray = new String[theStringList.size()];
            for (int i = 0; i < theSubstringArray.length; ++i) {
                theSubstringArray[i] = (String)theStringList.get(i);
            }
        }
        return theSubstringArray;
    }

    private static String[] toSplitAtFirstEndOfLineTextBlock(String aText, int aLength, HorizAlignTextMode aHorizAlignTextMode) {
        String[] theSubstringArray;
        int eTempIndex;
        int i;
        int eLineBreakIndex;
        String eSubstring;
        ArrayList<String> theStringList = new ArrayList<String>();
        String eText = aText;
        while (eText.length() > aLength) {
            eSubstring = eText.substring(0, aLength + 1);
            eSubstring = TextBlockBuilderImpl.toTruncateTrailingSpaces(eSubstring);
            eLineBreakIndex = -1;
            for (i = 0; i < CharSet.END_OF_LINE.getCharSet().length; ++i) {
                eTempIndex = eSubstring.indexOf(CharSet.END_OF_LINE.getCharSet()[i]);
                if (eLineBreakIndex != -1 && (eTempIndex == -1 || eTempIndex >= eLineBreakIndex)) continue;
                eLineBreakIndex = eTempIndex;
            }
            if (eLineBreakIndex > aLength) {
                for (i = 0; i < CharSet.LINE_BREAK_MARKERS.getCharSet().length; ++i) {
                    eTempIndex = eSubstring.lastIndexOf(CharSet.LINE_BREAK_MARKERS.getCharSet()[i]);
                    if (eLineBreakIndex != -1 && (eTempIndex == -1 || eTempIndex <= eLineBreakIndex)) continue;
                    eLineBreakIndex = eTempIndex;
                }
            }
            if (eLineBreakIndex != -1) {
                eSubstring = eText.substring(0, eLineBreakIndex + 1);
                eSubstring = TextBlockBuilderImpl.toTruncateTrailingSpaces(eSubstring);
                if (eText.length() > eLineBreakIndex) {
                    eText = eText.substring(eLineBreakIndex + 1);
                    eText = TextBlockBuilderImpl.toTruncatePrefixedSpaces(eText);
                } else {
                    eText = "";
                }
            } else if (eText.length() > aLength) {
                eSubstring = eText.substring(0, aLength);
                eText = eText.substring(aLength);
            } else {
                eText = "";
            }
            theStringList.add(((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withText(new String[]{TextBlockBuilderImpl.toNonBreakingLine(eSubstring)})).withColumnWidth(aLength)).withFillChar(' ').withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (eText.length() > 0) {
            do {
                eLineBreakIndex = -1;
                for (i = 0; i < CharSet.END_OF_LINE.getCharSet().length; ++i) {
                    eTempIndex = eText.indexOf(CharSet.END_OF_LINE.getCharSet()[i]);
                    if (eLineBreakIndex != -1 && (eTempIndex == -1 || eTempIndex >= eLineBreakIndex)) continue;
                    eLineBreakIndex = eTempIndex;
                }
                if (eLineBreakIndex == -1) continue;
                eSubstring = eText.substring(0, eLineBreakIndex + 1);
                eSubstring = TextBlockBuilderImpl.toTruncateTrailingSpaces(eSubstring);
                if (eText.length() > eLineBreakIndex) {
                    eText = eText.substring(eLineBreakIndex + 1);
                    eText = TextBlockBuilderImpl.toTruncatePrefixedSpaces(eText);
                    theStringList.add(((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withText(new String[]{TextBlockBuilderImpl.toNonBreakingLine(eSubstring)})).withColumnWidth(aLength)).withFillChar(' ').withHorizAlignTextMode(aHorizAlignTextMode).toString());
                    continue;
                }
                eText = "";
            } while (eLineBreakIndex != -1);
        }
        if (eText.length() > 0) {
            theStringList.add(((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withText(new String[]{TextBlockBuilderImpl.toNonBreakingLine(eText)})).withColumnWidth(aLength)).withFillChar(' ').withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (theStringList.size() == 0) {
            theSubstringArray = new String[]{aText};
        } else {
            theSubstringArray = new String[theStringList.size()];
            for (int i2 = 0; i2 < theSubstringArray.length; ++i2) {
                theSubstringArray[i2] = (String)theStringList.get(i2);
            }
        }
        return theSubstringArray;
    }

    private static String[] toSplitAtEndOfLineTextBlock(String aText, int aLength, HorizAlignTextMode aHorizAlignTextMode) {
        String[] theSubstringArray;
        ArrayList<String> theStringList = new ArrayList<String>();
        String eText = aText;
        while (eText.length() > aLength) {
            String eSubstring = eText.substring(0, aLength + 1);
            eSubstring = TextBlockBuilderImpl.toTruncateTrailingSpaces(eSubstring);
            int eLineBreakIndex = -1;
            for (int i = 0; i < CharSet.LINE_BREAK_MARKERS.getCharSet().length; ++i) {
                int eTempIndex = eSubstring.lastIndexOf(CharSet.LINE_BREAK_MARKERS.getCharSet()[i]);
                if (eLineBreakIndex != -1 && (eTempIndex == -1 || eTempIndex <= eLineBreakIndex)) continue;
                eLineBreakIndex = eTempIndex;
            }
            if (eLineBreakIndex != -1) {
                eSubstring = eText.substring(0, eLineBreakIndex + 1);
                eSubstring = TextBlockBuilderImpl.toTruncateTrailingSpaces(eSubstring);
                if (eText.length() > eLineBreakIndex) {
                    eText = eText.substring(eLineBreakIndex + 1);
                    eText = TextBlockBuilderImpl.toTruncatePrefixedSpaces(eText);
                } else {
                    eText = "";
                }
            } else if (eText.length() > aLength) {
                eSubstring = eText.substring(0, aLength);
                eText = eText.substring(aLength);
            } else {
                eText = "";
            }
            theStringList.add(((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withText(new String[]{TextBlockBuilderImpl.toNonBreakingLine(eSubstring)})).withColumnWidth(aLength)).withFillChar(' ').withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (eText.length() > 0) {
            theStringList.add(((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withText(new String[]{TextBlockBuilderImpl.toNonBreakingLine(eText)})).withColumnWidth(aLength)).withFillChar(' ').withHorizAlignTextMode(aHorizAlignTextMode).toString());
        }
        if (theStringList.size() == 0) {
            theSubstringArray = new String[]{aText};
        } else {
            theSubstringArray = new String[theStringList.size()];
            for (int i = 0; i < theSubstringArray.length; ++i) {
                theSubstringArray[i] = (String)theStringList.get(i);
            }
        }
        return theSubstringArray;
    }

    private static String toTruncateTrailingSpaces(String aText) {
        while (aText.length() > 0 && aText.charAt(aText.length() - 1) == ' ') {
            aText = aText.substring(0, aText.length() - 1);
        }
        return aText;
    }

    private static String toTruncatePrefixedSpaces(String aText) {
        if (aText.length() > 1) {
            while (aText.charAt(0) == ' ') {
                aText = aText.substring(1);
            }
        }
        return aText;
    }
}

