/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.TextBorder;
import org.refcodes.graphical.BoxBorderMode;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.TableStyle;
import org.refcodes.textual.TextBorderBuilder;

public class TextBorderBuilderImpl
extends AbstractText<TextBorderBuilder>
implements TextBorderBuilder {
    private char _borderChar = (char)35;
    private BoxBorderMode _boxBorderMode = BoxBorderMode.ALL;
    private TableStyle _tableStyle = TableStyle.ASCII;
    private int _borderWidth = 1;

    public BoxBorderMode getBoxBorderMode() {
        return this._boxBorderMode;
    }

    public void setBoxBorderMode(BoxBorderMode aBoxBorderMode) {
        this._boxBorderMode = aBoxBorderMode;
    }

    public TextBorderBuilder withBoxBorderMode(BoxBorderMode aBoxBorderMode) {
        this.setBoxBorderMode(aBoxBorderMode);
        return this;
    }

    @Override
    public TableStyle getTableStyle() {
        return this._tableStyle;
    }

    @Override
    public void setTableStyle(TableStyle aTableStyle) {
        this._tableStyle = aTableStyle;
        this._borderChar = '\u0000';
    }

    @Override
    public TextBorderBuilder withTableStyle(TableStyle aTableStyle) {
        this.setTableStyle(aTableStyle);
        return this;
    }

    @Override
    public char getBorderChar() {
        return this._borderChar;
    }

    @Override
    public void setBorderChar(char aBorderChar) {
        this._borderChar = aBorderChar;
        this._tableStyle = null;
    }

    @Override
    public int getBorderWidth() {
        return this._borderWidth;
    }

    @Override
    public void setBorderWidth(int aBorderWidth) {
        this._borderWidth = aBorderWidth;
    }

    @Override
    public String[] toStrings() {
        return this.toStrings(this.getText());
    }

    @Override
    public String[] toStrings(String ... aText) {
        if (this._tableStyle != null) {
            return TextBorderBuilderImpl.toBorder(aText, ((Character)this._tableStyle.getBody().getTopLeftEdge()).charValue(), ((Character)this._tableStyle.getBody().getTopRightEdge()).charValue(), ((Character)this._tableStyle.getBody().getBottomLeftEdge()).charValue(), ((Character)this._tableStyle.getBody().getBottomRightEdge()).charValue(), ((Character)this._tableStyle.getBody().getTopLine()).charValue(), ((Character)this._tableStyle.getBody().getRightLine()).charValue(), ((Character)this._tableStyle.getBody().getTopLine()).charValue(), ((Character)this._tableStyle.getBody().getLeftLine()).charValue(), this._boxBorderMode);
        }
        return TextBorderBuilderImpl.toBorder(aText, this._borderWidth, this._borderChar, this._boxBorderMode);
    }

    protected static String[] toLeftBorder(String[] aText, int aBorderWidth, char aBorderChar) {
        String theBorder = TextBorderBuilderImpl.toLine(aBorderWidth, aBorderChar);
        String[] theText = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theText[i] = theBorder + aText[i];
        }
        return theText;
    }

    protected static String[] toRightBorder(String[] aText, int aBorderWidth, char aBorderChar) {
        String theBorder = TextBorderBuilderImpl.toLine(aBorderWidth, aBorderChar);
        String[] theText = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theText[i] = aText[i] + theBorder;
        }
        return theText;
    }

    protected static String[] toTopBorder(String[] aText, int aBorderWidth, char aBorderChar) {
        int i;
        String[] theText = new String[aText.length + aBorderWidth];
        String theBorder = TextBorderBuilderImpl.toLine(aText[0].length(), aBorderChar);
        for (i = 0; i < aBorderWidth; ++i) {
            theText[i] = theBorder;
        }
        for (i = 0; i < aText.length; ++i) {
            theText[i + aBorderWidth] = aText[i];
        }
        return theText;
    }

    protected static String[] toBottomBorder(String[] aText, int aBorderWidth, char aBorderChar) {
        String[] theText = new String[aText.length + aBorderWidth];
        for (int i = 0; i < aText.length; ++i) {
            theText[i] = aText[i];
        }
        String theBorder = TextBorderBuilderImpl.toLine(aText[aText.length - 1].length(), aBorderChar);
        for (int i = 0; i < aBorderWidth; ++i) {
            theText[aText.length + i] = theBorder;
        }
        return theText;
    }

    protected static String[] toBorder(String[] aText, int aBorderWidth, char aBorderChar, BoxBorderMode aBoxBorderMode) {
        if (aBoxBorderMode.isLeftBorder()) {
            aText = TextBorderBuilderImpl.toLeftBorder(aText, aBorderWidth, aBorderChar);
        }
        if (aBoxBorderMode.isRightBorder()) {
            aText = TextBorderBuilderImpl.toRightBorder(aText, aBorderWidth, aBorderChar);
        }
        if (aBoxBorderMode.isTopBorder()) {
            aText = TextBorderBuilderImpl.toTopBorder(aText, aBorderWidth, aBorderChar);
        }
        if (aBoxBorderMode.isBottomBorder()) {
            aText = TextBorderBuilderImpl.toBottomBorder(aText, aBorderWidth, aBorderChar);
        }
        return aText;
    }

    protected static String[] toBorder(String[] aText, char aTopLeftBorderChar, char aTopRightBorderChar, char aBottomLeftBorderChar, char aBottomRightBorderChar, char aTopBorderChar, char aRightBorderChar, char aBottomBorderChar, char aLeftBorderChar, BoxBorderMode aBoxBorderMode) {
        if (aBoxBorderMode.isLeftBorder()) {
            aText = TextBorderBuilderImpl.toLeftBorder(aText, 1, aLeftBorderChar);
        }
        if (aBoxBorderMode.isRightBorder()) {
            aText = TextBorderBuilderImpl.toRightBorder(aText, 1, aRightBorderChar);
        }
        if (aBoxBorderMode.isTopBorder()) {
            aText = TextBorderBuilderImpl.toTopBorder(aText, 1, aTopBorderChar);
        }
        if (aBoxBorderMode.isBottomBorder()) {
            aText = TextBorderBuilderImpl.toBottomBorder(aText, 1, aBottomBorderChar);
        }
        if (aBoxBorderMode.isLeftBorder() && aBoxBorderMode.isTopBorder()) {
            aText[0] = aTopLeftBorderChar + aText[0].substring(1);
        }
        if (aBoxBorderMode.isLeftBorder() && aBoxBorderMode.isBottomBorder()) {
            aText[aText.length - 1] = aBottomLeftBorderChar + aText[aText.length - 1].substring(1);
        }
        if (aBoxBorderMode.isRightBorder() && aBoxBorderMode.isTopBorder()) {
            aText[0] = aText[0].substring(0, aText[0].length() - 1) + aTopRightBorderChar;
        }
        if (aBoxBorderMode.isRightBorder() && aBoxBorderMode.isBottomBorder()) {
            aText[aText.length - 1] = aText[aText.length - 1].substring(0, aText[aText.length - 1].length() - 1) + aBottomRightBorderChar;
        }
        return aText;
    }

    protected static String[] toSingleBorder(String[] aText) {
        return TextBorderBuilderImpl.toBorder(aText, TextBorder.SINGLE_TOP_LEFT_EDGE.getChar(), TextBorder.SINGLE_TOP_RIGHT_EDGE.getChar(), TextBorder.SINGLE_BOTTOM_LEFT_EDGE.getChar(), TextBorder.SINGLE_BOTTOM_RIGHT_EDGE.getChar(), TextBorder.SINGLE_HORIZONTAL_LINE.getChar(), TextBorder.SINGLE_VERTICAL_LINE.getChar(), TextBorder.SINGLE_HORIZONTAL_LINE.getChar(), TextBorder.SINGLE_VERTICAL_LINE.getChar(), BoxBorderMode.ALL);
    }

    protected static String[] toDoubleBorder(String[] aText) {
        return TextBorderBuilderImpl.toBorder(aText, TextBorder.DOUBLE_TOP_LEFT_EDGE.getChar(), TextBorder.DOUBLE_TOP_RIGHT_EDGE.getChar(), TextBorder.DOUBLE_BOTTOM_LEFT_EDGE.getChar(), TextBorder.DOUBLE_BOTTOM_RIGHT_EDGE.getChar(), TextBorder.DOUBLE_HORIZONTAL_LINE.getChar(), TextBorder.DOUBLE_VERTICAL_LINE.getChar(), TextBorder.DOUBLE_HORIZONTAL_LINE.getChar(), TextBorder.DOUBLE_VERTICAL_LINE.getChar(), BoxBorderMode.ALL);
    }

    protected static String[] toAsciiBorder(String[] aText) {
        return TextBorderBuilderImpl.toBorder(aText, TextBorder.ASCII_TOP_LEFT_EDGE.getChar(), TextBorder.ASCII_TOP_RIGHT_EDGE.getChar(), TextBorder.ASCII_BOTTOM_LEFT_EDGE.getChar(), TextBorder.ASCII_BOTTOM_RIGHT_EDGE.getChar(), TextBorder.ASCII_HORIZONTAL_LINE.getChar(), TextBorder.ASCII_VERTICAL_LINE.getChar(), TextBorder.ASCII_HORIZONTAL_LINE.getChar(), TextBorder.ASCII_VERTICAL_LINE.getChar(), BoxBorderMode.ALL);
    }

    protected static String toLine(int aLength, char aFillChar) {
        if (aLength <= 0) {
            return "";
        }
        StringBuffer theBuffer = new StringBuffer();
        while (theBuffer.length() < aLength) {
            theBuffer.append(aFillChar);
        }
        return theBuffer.toString();
    }
}

