/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.io.File;
import java.io.FileNotFoundException;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.RgbPixmapImageBuilder;
import org.refcodes.graphical.RgbPixmapImageBuilderImpl;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.textual.AsciiArtMode;
import org.refcodes.textual.FontAccessor;
import org.refcodes.textual.FontNameAccessor;
import org.refcodes.textual.FontSizeAccessor;
import org.refcodes.textual.FontStyleAccessor;
import org.refcodes.textual.FontTypeAccessor;
import org.refcodes.textual.PixmapRatioMode;
import org.refcodes.textual.Text;

public interface AsciiArtBuilder
extends Text<AsciiArtBuilder>,
FontAccessor.FontProperty,
FontAccessor.FontBuilder<AsciiArtBuilder>,
FontTypeAccessor.FontTypeProperty,
FontTypeAccessor.FontTypeBuilder<AsciiArtBuilder>,
FontStyleAccessor.FontStyleProperty,
FontStyleAccessor.FontStyleBuilder<AsciiArtBuilder>,
FontSizeAccessor.FontSizeProperty,
FontSizeAccessor.FontSizeBuilder<AsciiArtBuilder>,
FontNameAccessor.FontNameProperty,
FontNameAccessor.FontNameBuilder<AsciiArtBuilder>,
ColumnWidthAccessor.ColumnWidthBuilder<AsciiArtBuilder>,
ColumnWidthAccessor.ColumnWidthProperty {
    public AsciiArtMode getAsciiArtMode();

    public void setAsciiArtMode(AsciiArtMode var1);

    default public AsciiArtBuilder withAsciiArtMode(AsciiArtMode aAsciiArtMode) {
        this.setAsciiArtMode(aAsciiArtMode);
        return this;
    }

    public PixmapRatioMode getPixmapRatioMode();

    public void setPixmapRatioMode(PixmapRatioMode var1);

    default public AsciiArtBuilder withPixmapRatioMode(PixmapRatioMode aPixmapRatioMode) {
        this.setPixmapRatioMode(aPixmapRatioMode);
        return this;
    }

    public char[] getAsciiColors();

    public void setAsciiColors(char ... var1);

    default public AsciiArtBuilder withAsciiColors(char ... aAsciiColors) {
        this.setAsciiColors(aAsciiColors);
        return this;
    }

    default public void setAsciiColors(String aAsciiColors) {
        char[] theChars = new char[aAsciiColors.length()];
        aAsciiColors.getChars(0, aAsciiColors.length(), theChars, 0);
        this.setAsciiColors(theChars);
    }

    default public AsciiArtBuilder withAsciiColors(String aAsciiColors) {
        this.setAsciiColors(aAsciiColors);
        return this;
    }

    public AsciiColorPalette getAsciiColorPalette();

    public void setAsciiColorPalette(AsciiColorPalette var1);

    default public AsciiArtBuilder withAsciiColorPalette(AsciiColorPalette aAsciiColorPalette) {
        this.setAsciiColorPalette(aAsciiColorPalette);
        return this;
    }

    public RgbPixmap getRgbPixmap();

    public void setRgbPixmap(RgbPixmap var1);

    default public AsciiArtBuilder withRgbPixmap(RgbPixmap aPixmap) {
        this.setRgbPixmap(aPixmap);
        return this;
    }

    default public void setImageFile(File aImageFile) throws FileNotFoundException {
        this.setRgbPixmap(new RgbPixmapImageBuilderImpl().withImageFile(aImageFile).toPixmap());
    }

    default public AsciiArtBuilder withImageFile(File aImageFile) throws FileNotFoundException {
        this.setImageFile(aImageFile);
        return this;
    }

    public String toString(RgbPixmap var1);

    public String[] toStrings(RgbPixmap var1);

    default public String toString(File aImageFile) throws FileNotFoundException {
        RgbPixmapImageBuilder theBuilder = new RgbPixmapImageBuilderImpl().withWidth(this.getColumnWidth());
        return this.toString(theBuilder.toPixmap(aImageFile));
    }

    default public String[] toStrings(File aImageFile) throws FileNotFoundException {
        RgbPixmapImageBuilder theBuilder = new RgbPixmapImageBuilderImpl().withWidth(this.getColumnWidth());
        return this.toStrings(theBuilder.toPixmap(aImageFile));
    }
}

