/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.textual.Case;
import org.refcodes.textual.CaseStyleBuilder;
import org.refcodes.textual.CaseStyleBuilderImpl;

public enum CaseStyle {
    NONE(null),
    CAMEL_CASE(new CaseStyleBuilderImpl()),
    PASCAL_CASE(new CaseStyleBuilderImpl()),
    SNAKE_CASE(new CaseStyleBuilderImpl().withCase(Case.LOWER)),
    KEBAB_CASE(new CaseStyleBuilderImpl().withCase(Case.LOWER)),
    SNAKE_UPPER_CASE(new CaseStyleBuilderImpl().withCase(Case.UPPER)),
    KEBAB_UPPER_CASE(new CaseStyleBuilderImpl().withCase(Case.UPPER));

    private CaseStyleBuilder _caseStyleBuilder;

    private CaseStyle(CaseStyleBuilder aCaseStyleBuilder) {
        this._caseStyleBuilder = aCaseStyleBuilder;
    }

    public String toCaseStyle(String aText) {
        switch (this) {
            case CAMEL_CASE: {
                return this._caseStyleBuilder.toCamelCase(aText);
            }
            case KEBAB_CASE: {
                return this._caseStyleBuilder.toKebabCase(aText);
            }
            case KEBAB_UPPER_CASE: {
                return this._caseStyleBuilder.toKebabCase(aText);
            }
            case PASCAL_CASE: {
                return this._caseStyleBuilder.toPascalCase(aText);
            }
            case SNAKE_CASE: {
                return this._caseStyleBuilder.toSnakeCase(aText);
            }
            case SNAKE_UPPER_CASE: {
                return this._caseStyleBuilder.toSnakeCase(aText);
            }
        }
        return aText;
    }
}

