/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.refcodes.structure.Property;
import org.refcodes.structure.PropertyImpl;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.EscapeTextBuilder;
import org.refcodes.textual.EscapeTextMode;

public class EscapeTextBuilderImpl
extends AbstractText<EscapeTextBuilder>
implements EscapeTextBuilder {
    private List<Property> _properties;
    private EscapeTextMode _escapeTextMode = EscapeTextMode.ESCAPE;

    @Override
    public EscapeTextMode getEscapeTextMode() {
        return this._escapeTextMode;
    }

    @Override
    public void setEscapeTextMode(EscapeTextMode aEscapeTextMode) {
        this._escapeTextMode = aEscapeTextMode;
    }

    @Override
    public Property[] getEscapeProperties() {
        return this._properties.toArray(new Property[this._properties.size()]);
    }

    @Override
    public void setEscapeProperties(Property ... aProperties) {
        this._properties = new ArrayList<Property>();
        Collections.addAll(this._properties, aProperties);
    }

    @Override
    public EscapeTextBuilder addEscapeProperty(Property aProperty) {
        if (this._properties == null) {
            this._properties = new ArrayList<Property>();
        }
        this._properties.add(aProperty);
        return this;
    }

    @Override
    public EscapeTextBuilder addEscapeProperty(String aKey, String aValue) {
        return this.addEscapeProperty((Property)new PropertyImpl(aKey, aValue));
    }

    @Override
    public String[] toStrings() throws IllegalStateException {
        return this.toEscaped(this.getText(), this._properties, this._escapeTextMode);
    }

    @Override
    public String[] toStrings(String ... aText) {
        return this.toEscaped(aText, this._properties, this._escapeTextMode);
    }

    protected String[] toEscaped(String[] aText, List<Property> aProperties, EscapeTextMode aEscapeTextMode) {
        String[] theResult = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theResult[i] = this.toEscaped(aText[i], aProperties, aEscapeTextMode);
        }
        return theResult;
    }

    protected String toEscaped(String aText, List<Property> aProperties, EscapeTextMode aEscapeTextMode) {
        switch (aEscapeTextMode) {
            case ESCAPE: {
                return EscapeTextBuilderImpl.toEscaped(aText, EscapeTextBuilderImpl.toEscapeMatrix(aProperties));
            }
            case UNESCAPE: {
                return EscapeTextBuilderImpl.toUnEscaped(aText, EscapeTextBuilderImpl.toEscapeMatrix(aProperties));
            }
        }
        throw new IllegalArgumentException("You must pass a valid escape text mode, though you actually passed <" + (Object)((Object)aEscapeTextMode) + ">!");
    }

    public static String toEscaped(String aUnEscaped, String[][] aEscapeMatrix) {
        for (int i = 0; i < aEscapeMatrix.length; ++i) {
            aUnEscaped = aUnEscaped.replaceAll(EscapeTextBuilderImpl.toRegExEscaped(aEscapeMatrix[i][0]), aEscapeMatrix[i][1]);
        }
        return aUnEscaped;
    }

    public static String toUnEscaped(String aEscaped, String[][] aEscapeMatrix) {
        for (int i = 0; i < aEscapeMatrix.length; ++i) {
            aEscaped = aEscaped.replaceAll(EscapeTextBuilderImpl.toRegExEscaped(aEscapeMatrix[i][1]), aEscapeMatrix[i][0]);
        }
        return aEscaped;
    }

    static String toEscapedRegexp(char aDelimiter) {
        return ("" + aDelimiter).replaceAll("\\.", "\\\\.").replaceAll("\\|", "\\\\|");
    }

    static String toRegExEscaped(String aText) {
        aText = aText.replaceAll("\\+", "\\\\+").replaceAll("\\*", "\\\\*").replaceAll("\\.", "\\\\.");
        return aText;
    }

    private static String[][] toEscapeMatrix(List<Property> aProperties) {
        String[][] theStrings = new String[aProperties.size()][2];
        for (int i = 0; i < aProperties.size(); ++i) {
            theStrings[i][0] = (String)aProperties.get(i).getKey();
            theStrings[i][1] = (String)aProperties.get(i).getValue();
        }
        return theStrings;
    }
}

