/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.CharSet;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.TruncateTextBuilder;
import org.refcodes.textual.TruncateTextMode;

public class TruncateTextBuilderImpl
extends AbstractText<TruncateTextBuilder>
implements TruncateTextBuilder {
    private TruncateTextMode _truncateTextMode = TruncateTextMode.RIGHT;
    private char[] _stripChars = CharSet.WHITE_SPACES.getCharSet();

    @Override
    public TruncateTextMode getTruncateTextMode() {
        return this._truncateTextMode;
    }

    @Override
    public void setTruncateTextMode(TruncateTextMode aTruncateTextMode) {
        this._truncateTextMode = aTruncateTextMode;
    }

    @Override
    public char[] getTruncateChars() {
        return this._stripChars;
    }

    @Override
    public void setTruncateChars(char ... aStripChars) {
        this._stripChars = aStripChars;
    }

    @Override
    public String[] toStrings() {
        return this.toStrings(this.getText());
    }

    @Override
    public String[] toStrings(String ... aText) {
        String[] theResult = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theResult[i] = TruncateTextBuilderImpl.toStrip(aText[i], this._stripChars, this._truncateTextMode);
        }
        return theResult;
    }

    protected static String toStrip(String aText, char[] aChars, TruncateTextMode aTruncateTextMode) {
        switch (aTruncateTextMode) {
            case LEFT: {
                return TruncateTextBuilderImpl.toStripLeft(aText, aChars);
            }
            case LEFT_AND_RIGHT: {
                return TruncateTextBuilderImpl.toStrip(aText, aChars);
            }
            case RIGHT: {
                return TruncateTextBuilderImpl.toStripRight(aText, aChars);
            }
        }
        throw new IllegalArgumentException("You must pass a valid text strip mode, though you actually passed <" + (Object)((Object)aTruncateTextMode) + ">!");
    }

    protected static void doStripLeft(StringBuffer aStringBuffer, char aChar) {
        for (int i = 0; i < aStringBuffer.length() && aStringBuffer.charAt(i) == aChar; ++i) {
            aStringBuffer.deleteCharAt(i);
            --i;
        }
    }

    protected static String toStripLeft(String aText, char[] aChars) {
        StringBuffer theStringBuffer = new StringBuffer(aText);
        for (int i = 0; i < aChars.length; ++i) {
            TruncateTextBuilderImpl.doStripLeft(theStringBuffer, aChars[i]);
        }
        return theStringBuffer.toString();
    }

    protected static void doStripRight(StringBuffer aStringBuffer, char aChar) {
        for (int i = aStringBuffer.length() - 1; i >= 0 && aStringBuffer.charAt(i) == aChar; --i) {
            aStringBuffer.deleteCharAt(i);
        }
    }

    protected static void doStrip(StringBuffer aStringBuffer, char aChar) {
        TruncateTextBuilderImpl.doStripLeft(aStringBuffer, aChar);
        TruncateTextBuilderImpl.doStripRight(aStringBuffer, aChar);
    }

    protected static String toStripRight(String aText, char[] aChars) {
        StringBuffer theStringBuffer = new StringBuffer(aText);
        for (int i = 0; i < aChars.length; ++i) {
            TruncateTextBuilderImpl.doStripRight(theStringBuffer, aChars[i]);
        }
        return theStringBuffer.toString();
    }

    protected static String toStrip(String aText, char[] aChars) {
        return TruncateTextBuilderImpl.toStripRight(TruncateTextBuilderImpl.toStripLeft(aText, aChars), aChars);
    }
}

