/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.ConsoleDimension;
import org.refcodes.data.Text;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.TextLineBuilderImpl;
import org.refcodes.textual.VertAlignTextBuilder;
import org.refcodes.textual.VertAlignTextMode;

public class VertAlignTextBuilderImpl
extends AbstractText<VertAlignTextBuilder>
implements VertAlignTextBuilder {
    private int _rowHeight = ConsoleDimension.MIN_HEIGHT.getValue();
    private VertAlignTextMode _alignTextMode = VertAlignTextMode.TOP;
    private char _fillChar = (char)32;

    public VertAlignTextBuilder withRowHeight(int aRowHeight) {
        this.setRowHeight(aRowHeight);
        return this;
    }

    public void setRowHeight(int aRowHeight) {
        this._rowHeight = aRowHeight;
    }

    public int getRowHeight() {
        return this._rowHeight;
    }

    @Override
    public void setVertAlignTextMode(VertAlignTextMode aVertAlignTextMode) {
        this._alignTextMode = aVertAlignTextMode;
    }

    @Override
    public VertAlignTextMode getVertAlignTextMode() {
        return this._alignTextMode;
    }

    @Override
    public char getFillChar() {
        return this._fillChar;
    }

    @Override
    public void setFillChar(char aFillChar) {
        this._fillChar = aFillChar;
    }

    @Override
    public String[] toStrings() {
        return VertAlignTextBuilderImpl.toTextBlock(this.getText(), this._rowHeight, this._fillChar, this._alignTextMode);
    }

    @Override
    public String[] toStrings(String ... aText) {
        return VertAlignTextBuilderImpl.toTextBlock(aText, this._rowHeight, this._fillChar, this._alignTextMode);
    }

    protected static String[] toTextBlock(String[] aTextBlock, int aHeight, char aFillChar, VertAlignTextMode aVertAlignTextMode) {
        if (aTextBlock == null || aHeight == aTextBlock.length) {
            return aTextBlock;
        }
        String theLine = null;
        String[] theLines = new String[aHeight];
        switch (aVertAlignTextMode) {
            case BOTTOM: {
                throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
            }
            case CENTER: {
                throw new RuntimeException(Text.NOT_YET_IMPLEMENTED.getText());
            }
            case TOP: {
                for (int i = 0; i < theLines.length; ++i) {
                    if (i < aTextBlock.length) {
                        theLines[i] = aTextBlock[i];
                        continue;
                    }
                    if (theLine == null && aTextBlock != null && aTextBlock.length > 0) {
                        theLine = new TextLineBuilderImpl().withColumnWidth(aTextBlock[0].length()).withLineChar(aFillChar).toString();
                    }
                    theLines[i] = theLine;
                }
                return theLines;
            }
        }
        throw new IllegalArgumentException("You must provided a supported value for the vertical align mode, though you provided <" + (Object)((Object)aVertAlignTextMode) + ">. The code seems to be out of date, please participate in getting the code even better. See <http://www.refcodes.org> and <https://birbucket.org/refcodes>.");
    }
}

