/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.Delimiter;
import org.refcodes.mixin.TextAccessor;
import org.refcodes.runtime.PropertyBuilder;
import org.refcodes.textual.Case;
import org.refcodes.textual.CaseAccessor;

public class CaseStyleBuilder
implements TextAccessor.TextProperty,
TextAccessor.TextBuilder<CaseStyleBuilder>,
CaseAccessor.CaseProperty,
CaseAccessor.CaseBuilder<CaseStyleBuilder> {
    private String _text = null;
    private Case _case = Case.UPPER;

    public String getText() {
        return this._text;
    }

    public void setText(String string) {
        this._text = string;
    }

    public CaseStyleBuilder withText(String string) {
        this.setText(string);
        return this;
    }

    @Override
    public Case getCase() {
        return this._case;
    }

    @Override
    public void setCase(Case case_) {
        this._case = case_;
    }

    public String toCamelCase() {
        return this.toCamelCase(this.getText());
    }

    public String toSnakeCase() {
        return this.toSnakeCase(this.getText());
    }

    public String toPascalCase() {
        return this.toPascalCase(this.getText());
    }

    public String toKebabCase() {
        return this.toKebabCase(this.getText());
    }

    public String toCamelCase(String string) {
        return CaseStyleBuilder.asCamelCase(string);
    }

    public String toSnakeCase(String string) {
        Case case_ = this._case;
        return CaseStyleBuilder.asSnakeCase(string, case_);
    }

    public String toPascalCase(String string) {
        return CaseStyleBuilder.asPascalCase(string);
    }

    public String toKebabCase(String string) {
        Case case_ = this._case;
        return CaseStyleBuilder.asKebabCase(string, case_);
    }

    @Override
    public CaseStyleBuilder withCase(Case case_) {
        this.setCase(case_);
        return this;
    }

    public static String asCamelCase(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        String string2 = NormalizeCaseUtility.toNormalized(string, Delimiter.SNAKE_CASE.getChar()).replaceAll("_\u00e4", "\u00c4").replaceAll("_\u00f6", "\u00d6").replaceAll("_\u00fc", "\u00dc").replaceAll("_a", "A").replaceAll("_b", "B").replaceAll("_c", "C").replaceAll("_d", "D").replaceAll("_e", "E").replaceAll("_f", "F").replaceAll("_g", "G").replaceAll("_h", "H").replaceAll("_i", "I").replaceAll("_j", "J").replaceAll("_k", "K").replaceAll("_l", "L").replaceAll("_m", "M").replaceAll("_n", "N").replaceAll("_o", "O").replaceAll("_p", "P").replaceAll("_q", "Q").replaceAll("_r", "R").replaceAll("_s", "S").replaceAll("_t", "T").replaceAll("_u", "U").replaceAll("_v", "V").replaceAll("_w", "W").replaceAll("_x", "X").replaceAll("_y", "Y").replaceAll("_z", "Z");
        return string2;
    }

    public static String asSnakeCase(String string) {
        return CaseStyleBuilder.asSnakeCase(string, Case.UPPER);
    }

    public static String asSnakeCase(String string, Case case_) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return case_.toCase(NormalizeCaseUtility.toNormalized(string, Delimiter.SNAKE_CASE.getChar()));
    }

    public static String asPascalCase(String object) {
        if (object == null || ((String)object).length() == 0) {
            return object;
        }
        object = CaseStyleBuilder.asCamelCase((String)object);
        object = Character.toUpperCase(((String)object).charAt(0)) + ((String)object).substring(1);
        return object;
    }

    public static String asKebabCase(String string) {
        return CaseStyleBuilder.asKebabCase(string, Case.UPPER);
    }

    public static String asKebabCase(String string, Case case_) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return case_.toCase(NormalizeCaseUtility.toNormalized(string, Delimiter.KEBAB_CASE.getChar()));
    }

    static class NormalizeCaseUtility
    extends PropertyBuilder {
        NormalizeCaseUtility() {
        }

        protected static String toNormalized(String string, char c) {
            return PropertyBuilder.asNormalized((String)string, (char)c);
        }
    }
}

