/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;

public class FontImpl
implements Font {
    private FontFamily _family = FontFamily.SANS_SERIF;
    private int _size = 16;
    private FontStyle _style = FontStyle.PLAIN;
    private String _name = this._family.getName();

    public FontImpl() {
    }

    public FontImpl(java.awt.Font font) {
        this.setSize(font.getSize());
        this.setStyle(FontStyle.fromFontStyleCode(font.getStyle()));
        this.setFamily(FontFamily.fromName(font.getFamily()));
    }

    public FontImpl(FontFamily fontFamily, FontStyle fontStyle, int n) {
        this.setFamily(fontFamily);
        this._style = fontStyle;
        this._size = n;
    }

    public FontImpl(FontFamily fontFamily, FontStyle fontStyle) {
        this(fontFamily, fontStyle, -1);
    }

    public FontImpl(String string, FontStyle fontStyle, int n) {
        this.setName(string);
        this._style = fontStyle;
        this._size = n;
    }

    public FontImpl(String string, FontStyle fontStyle) {
        this(string, fontStyle, -1);
    }

    public FontFamily getFamily() {
        return this._family;
    }

    public void setFamily(FontFamily fontFamily) {
        this._family = fontFamily;
        this._name = fontFamily.getName();
    }

    public Font withFamily(FontFamily fontFamily) {
        this.setFamily(fontFamily);
        return this;
    }

    public FontStyle getStyle() {
        return this._style;
    }

    public void setStyle(FontStyle fontStyle) {
        this._style = fontStyle;
    }

    public Font withStyle(FontStyle fontStyle) {
        this.setStyle(fontStyle);
        return this;
    }

    public int getSize() {
        return this._size;
    }

    public void setSize(int n) {
        this._size = n;
    }

    public Font withSize(int n) {
        this.setSize(n);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._family.getName() + ", " + this._style + ", " + this._size + ")@" + this.hashCode();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
        this._family = FontFamily.fromName(string);
    }

    public Font withName(String string) {
        this.setName(string);
        return this;
    }
}

