/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.Literal;
import org.refcodes.data.MoreText;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.MoreTextMode;
import org.refcodes.textual.Text;

public class MoreTextBuilder
extends AbstractText<MoreTextBuilder>
implements Text<MoreTextBuilder>,
ColumnWidthAccessor.ColumnWidthProperty,
ColumnWidthAccessor.ColumnWidthBuilder<MoreTextBuilder> {
    private int _columnWidth = Terminal.toPreferredTerminalWidth();
    private MoreTextMode _moreTextMode = MoreTextMode.RIGHT;
    private String _moreText = "" + MoreText.MORE_TEXT_BEFORE.getChar();

    public String getMoreText() {
        return this._moreText;
    }

    public void setMoreText(String string) {
        this._moreText = string;
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    public void setColumnWidth(int n) {
        this._columnWidth = n;
    }

    public MoreTextBuilder withColumnWidth(int n) {
        this._columnWidth = n;
        return this;
    }

    public MoreTextMode getMoreTextMode() {
        return this._moreTextMode;
    }

    public void setMoreTextMode(MoreTextMode moreTextMode) {
        this._moreTextMode = moreTextMode;
    }

    @Override
    public String[] toStrings() {
        return MoreTextBuilder.asMoreText(this.getText(), this._columnWidth, this._moreText, this._moreTextMode);
    }

    @Override
    public String[] toStrings(String ... stringArray) {
        return MoreTextBuilder.asMoreText(stringArray, this._columnWidth, this._moreText, this._moreTextMode);
    }

    public MoreTextBuilder withMoreTextMode(MoreTextMode moreTextMode) {
        this.setMoreTextMode(moreTextMode);
        return this;
    }

    public MoreTextBuilder withMoreText(String string) {
        this.setMoreText(string);
        return this;
    }

    @Override
    public String toString() throws IllegalStateException {
        return super.toString();
    }

    public static String[] asMoreText(String[] stringArray, int n, String string, MoreTextMode moreTextMode) {
        return MoreTextBuilder.asMoreText(stringArray, n, string, moreTextMode, false);
    }

    public static String[] asMoreText(String[] stringArray, int n, String string, MoreTextMode moreTextMode, boolean bl) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = MoreTextBuilder.asMoreText(stringArray[i], n, string, moreTextMode, bl);
        }
        return stringArray2;
    }

    public static String asMoreText(String string, int n, String string2, MoreTextMode moreTextMode) {
        return MoreTextBuilder.asMoreText(string, n, string2, moreTextMode, false);
    }

    public static String asMoreText(String string, int n, String string2, MoreTextMode moreTextMode, boolean bl) {
        switch (moreTextMode) {
            case LEFT: {
                return MoreTextBuilder.toMoreLeft(string, n, string2, bl);
            }
            case CENTER: {
                return MoreTextBuilder.toMoreCenter(string, n, string2, bl);
            }
            case RIGHT: {
                return MoreTextBuilder.toMoreRight(string, n, string2, bl);
            }
        }
        return string;
    }

    private static String toMoreLeft(String string, int n, String string2, boolean bl) {
        if (string == null) {
            string = Literal.NULL.getValue();
        }
        if (MoreTextBuilder.toLength(string2, bl) > n && MoreTextBuilder.toLength(string, bl) > n) {
            return string2.substring(0, n);
        }
        if (MoreTextBuilder.toLength(string, bl) <= n) {
            return string;
        }
        string = string.substring(MoreTextBuilder.toLength(string, bl) - n + MoreTextBuilder.toLength(string2, bl));
        return string2 + string;
    }

    private static String toMoreRight(String string, int n, String string2, boolean bl) {
        if (MoreTextBuilder.toLength(string2, bl) > n && MoreTextBuilder.toLength(string, bl) > n) {
            return string2.substring(0, n);
        }
        if (MoreTextBuilder.toLength(string, bl) <= n) {
            return string;
        }
        string = string.substring(0, n - MoreTextBuilder.toLength(string2, bl));
        return string + string2;
    }

    private static String toMoreCenter(String string, int n, String string2, boolean bl) {
        if (MoreTextBuilder.toLength(string2, bl) > n && MoreTextBuilder.toLength(string, bl) > n) {
            return string2.substring(0, n);
        }
        if (MoreTextBuilder.toLength(string, bl) <= n) {
            return string;
        }
        if (MoreTextBuilder.toLength(string = string.substring(0, MoreTextBuilder.toLength(string, bl) - MoreTextBuilder.toLength(string2, bl)), bl) - MoreTextBuilder.toLength(string2, bl) == n) {
            return string + string2;
        }
        while (MoreTextBuilder.toLength(string, bl) + MoreTextBuilder.toLength(string2, bl) * 2 > n) {
            if (MoreTextBuilder.toLength(string = string.substring(MoreTextBuilder.toLength(string2, bl)), bl) + MoreTextBuilder.toLength(string2, bl) * 2 == n) {
                return string2 + string + string2;
            }
            if (MoreTextBuilder.toLength(string = string.substring(0, MoreTextBuilder.toLength(string, bl) - MoreTextBuilder.toLength(string2, bl)), bl) + MoreTextBuilder.toLength(string2, bl) * 2 != n) continue;
            return string2 + string + string2;
        }
        return string2 + string + string2;
    }

    private static int toLength(String string, boolean bl) {
        if (bl) {
            return AnsiEscapeCode.toUnescapedLength((String)string);
        }
        return string.length();
    }
}

