/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.data.CharSet;
import org.refcodes.mixin.ColumnWidthAccessor;
import org.refcodes.runtime.Terminal;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.FillCharAccessor;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.HorizAlignTextModeAccessor;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.Text;
import org.refcodes.textual.TextLineBuilder;

public class TextBlockBuilder
extends AbstractText<TextBlockBuilder>
implements FillCharAccessor.FillCharProperty,
FillCharAccessor.FillCharBuilder<TextBlockBuilder>,
ColumnWidthAccessor.ColumnWidthBuilder<TextBlockBuilder>,
ColumnWidthAccessor.ColumnWidthProperty,
Text<TextBlockBuilder>,
HorizAlignTextModeAccessor.HorizAlignTextModeProperty,
HorizAlignTextModeAccessor.HorizAlignTextModeBuilder<TextBlockBuilder> {
    public static final String LINE_BREAKS = new String(new char[]{'\t', '\n', '\r'});
    private int _columnWidth = Terminal.toPreferredTerminalWidth();
    private HorizAlignTextMode _alignTextMode = HorizAlignTextMode.LEFT;
    private SplitTextMode _splitTextMode = SplitTextMode.AT_SPACE;
    private char _fillChar = (char)32;

    @Override
    public char getFillChar() {
        return this._fillChar;
    }

    @Override
    public void setFillChar(char c) {
        this._fillChar = c;
    }

    public TextBlockBuilder withColumnWidth(int n) {
        this.setColumnWidth(n);
        return this;
    }

    public void setColumnWidth(int n) {
        this._columnWidth = n;
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public void setHorizAlignTextMode(HorizAlignTextMode horizAlignTextMode) {
        this._alignTextMode = horizAlignTextMode;
    }

    @Override
    public HorizAlignTextMode getHorizAlignTextMode() {
        return this._alignTextMode;
    }

    public SplitTextMode getSplitTextMode() {
        return this._splitTextMode;
    }

    public void setSplitTextMode(SplitTextMode splitTextMode) {
        this._splitTextMode = splitTextMode;
    }

    @Override
    public String[] toStrings() {
        return this.toStrings(this.getText());
    }

    @Override
    public String[] toStrings(String ... stringArray) {
        return TextBlockBuilder.asTextBlock(stringArray, this.getColumnWidth(), this.getHorizAlignTextMode(), this.getSplitTextMode(), this.getFillChar());
    }

    @Override
    public TextBlockBuilder withHorizAlignTextMode(HorizAlignTextMode horizAlignTextMode) {
        this.setHorizAlignTextMode(horizAlignTextMode);
        return this;
    }

    @Override
    public TextBlockBuilder withFillChar(char c) {
        this.setFillChar(c);
        return this;
    }

    public TextBlockBuilder withSplitTextMode(SplitTextMode splitTextMode) {
        this.setSplitTextMode(splitTextMode);
        return this;
    }

    public static String[] asTextBlock(String string, int n) {
        return TextBlockBuilder.asTextBlock(string, n, false);
    }

    public static String[] asTextBlock(String string, int n, SplitTextMode splitTextMode) {
        return TextBlockBuilder.asTextBlock(string, n, splitTextMode, false);
    }

    public static String[] asTextBlock(String string, int n, HorizAlignTextMode horizAlignTextMode) {
        return TextBlockBuilder.asTextBlock(string, n, horizAlignTextMode, false);
    }

    public static String[] asTextBlock(String string, int n, HorizAlignTextMode horizAlignTextMode, SplitTextMode splitTextMode, char c) {
        return TextBlockBuilder.asTextBlock(string, n, horizAlignTextMode, splitTextMode, c, false);
    }

    public static String[] asTextBlock(String[] stringArray, int n) {
        return TextBlockBuilder.asTextBlock(stringArray, n, false);
    }

    public static String[] asTextBlock(String[] stringArray, int n, SplitTextMode splitTextMode) {
        return TextBlockBuilder.asTextBlock(stringArray, n, splitTextMode, false);
    }

    public static String[] asTextBlock(String[] stringArray, int n, HorizAlignTextMode horizAlignTextMode) {
        return TextBlockBuilder.asTextBlock(stringArray, n, horizAlignTextMode, false);
    }

    public static String[] asTextBlock(String[] stringArray, int n, HorizAlignTextMode horizAlignTextMode, SplitTextMode splitTextMode, char c) {
        return TextBlockBuilder.asTextBlock(stringArray, n, horizAlignTextMode, splitTextMode, c, false);
    }

    public static String[] asTextBlock(String string, int n, boolean bl) {
        return TextBlockBuilder.asTextBlock(string, n, null, null, ' ', bl);
    }

    public static String[] asTextBlock(String string, int n, SplitTextMode splitTextMode, boolean bl) {
        return TextBlockBuilder.asTextBlock(string, n, null, splitTextMode, ' ', bl);
    }

    public static String[] asTextBlock(String string, int n, HorizAlignTextMode horizAlignTextMode, boolean bl) {
        return TextBlockBuilder.asTextBlock(string, n, horizAlignTextMode, null, ' ', bl);
    }

    public static String[] asTextBlock(String string, int n, HorizAlignTextMode horizAlignTextMode, SplitTextMode splitTextMode, char c, boolean bl) {
        if (string == null) {
            return null;
        }
        if (splitTextMode == null) {
            splitTextMode = SplitTextMode.AT_FIXED_WIDTH;
        }
        switch (splitTextMode) {
            case AT_END_OF_LINE: {
                return TextBlockBuilder.toSplitAtEndOfLineTextBlock(string, n, horizAlignTextMode, c, bl);
            }
            case AT_FIRST_END_OF_LINE: {
                return TextBlockBuilder.toSplitAtFirstEndOfLineTextBlock(string, n, horizAlignTextMode, c, bl);
            }
            case AT_SPACE: {
                return TextBlockBuilder.toSplitAtSpaceTextBlock(string, n, horizAlignTextMode, c, bl);
            }
        }
        return TextBlockBuilder.toSplitAtFixedWidthTextBlock(string, n, horizAlignTextMode, c, bl);
    }

    public static String[] asTextBlock(String[] stringArray, int n, boolean bl) {
        return TextBlockBuilder.asTextBlock(stringArray, n, null, null, ' ', bl);
    }

    public static String[] asTextBlock(String[] stringArray, int n, SplitTextMode splitTextMode, boolean bl) {
        return TextBlockBuilder.asTextBlock(stringArray, n, null, splitTextMode, ' ', bl);
    }

    public static String[] asTextBlock(String[] stringArray, int n, HorizAlignTextMode horizAlignTextMode, boolean bl) {
        return TextBlockBuilder.asTextBlock(stringArray, n, horizAlignTextMode, null, ' ', bl);
    }

    public static String[] asTextBlock(String[] stringArray, int n, HorizAlignTextMode horizAlignTextMode, SplitTextMode splitTextMode, char c, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Collections.addAll(arrayList, TextBlockBuilder.asTextBlock(string, n, horizAlignTextMode, splitTextMode, c, bl));
            if (i >= stringArray.length - 1) continue;
            arrayList.add(new TextLineBuilder().withLineChar(' ').withColumnWidth(((String)arrayList.get(0)).length()).toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String toNonBreakingLine(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, LINE_BREAKS);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            if (!stringTokenizer.hasMoreTokens() || stringBuffer.length() <= 0 || stringBuffer.charAt(stringBuffer.length() - 1) == ' ') continue;
            if (!TextBlockBuilder.hasAtEndOfLine(stringBuffer, CharSet.LINE_BREAK_MARKERS) && !TextBlockBuilder.hasAtEndOfLine(stringBuffer, CharSet.OPENING_BRACES) && stringBuffer.charAt(stringBuffer.length() - 1) != '.') {
                stringBuffer.append('.');
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private static boolean hasAtEndOfLine(StringBuffer stringBuffer, CharSet charSet) {
        boolean bl = false;
        for (int i = 0; i < charSet.getCharSet().length; ++i) {
            if (stringBuffer.charAt(stringBuffer.length() - 1) != charSet.getCharSet()[i]) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static String[] toSplitAtSpaceTextBlock(String string, int n, HorizAlignTextMode horizAlignTextMode, char c, boolean bl) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = TextBlockBuilder.toNonBreakingLine(string);
        while (AnsiEscapeCode.toLength((String)string2, (boolean)bl) > n) {
            string2 = TextBlockBuilder.toTruncatePrefixedSpaces(string2, bl);
            String string3 = TextBlockBuilder.toLastSpaceIndex(string2, n, bl);
            string3 = TextBlockBuilder.toTruncateTrailingSpaces(string3, bl);
            arrayList.add(HorizAlignTextBuilder.asAligned(string3, n, c, horizAlignTextMode, bl));
            string2 = string2.substring(string3.length());
        }
        if (AnsiEscapeCode.toLength((String)string2, (boolean)bl) > 0) {
            string2 = TextBlockBuilder.toTruncatePrefixedSpaces(string2, bl);
            if (AnsiEscapeCode.toLength((String)(string2 = TextBlockBuilder.toTruncateTrailingSpaces(string2, bl)), (boolean)bl) > 0) {
                arrayList.add(HorizAlignTextBuilder.asAligned(string2, n, c, horizAlignTextMode, bl));
            }
        }
        if (arrayList.size() == 0) {
            stringArray = new String[]{string};
        } else {
            stringArray = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
        }
        return stringArray;
    }

    private static String toLastSpaceIndex(String string, int n, boolean bl) {
        String string2 = string;
        while (AnsiEscapeCode.toLength((String)string2, (boolean)bl) > n) {
            int n2 = TextBlockBuilder.lastIndexOf(string2, CharSet.SPACE_MARKERS.getCharSet());
            if (n2 == -1) {
                return string.substring(0, n);
            }
            string2 = string2.substring(0, n2);
        }
        return string2;
    }

    private static int lastIndexOf(String string, char[] cArray) {
        for (int i = string.length() - 1; i > 0; --i) {
            for (int j = 0; j < cArray.length; ++j) {
                if (string.charAt(i) != CharSet.SPACE_MARKERS.getCharSet()[j]) continue;
                return i;
            }
        }
        return -1;
    }

    private static String[] toSplitAtFixedWidthTextBlock(String string, int n, HorizAlignTextMode horizAlignTextMode, char c, boolean bl) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        while (AnsiEscapeCode.toLength((String)string2, (boolean)bl) > n) {
            String string3 = string2.substring(0, n);
            string2 = string2.substring(n);
            arrayList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{string3})).withColumnWidth(n).withFillChar(c).withHorizAlignTextMode(horizAlignTextMode).toString());
        }
        if (AnsiEscapeCode.toLength((String)string2, (boolean)bl) > 0) {
            arrayList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{string2})).withColumnWidth(n).withFillChar(c).withHorizAlignTextMode(horizAlignTextMode).toString());
        }
        if (arrayList.size() == 0) {
            stringArray = new String[]{string};
        } else {
            stringArray = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
        }
        return stringArray;
    }

    private static String[] toSplitAtFirstEndOfLineTextBlock(String string, int n, HorizAlignTextMode horizAlignTextMode, char c, boolean bl) {
        String[] stringArray;
        int n2;
        int n3;
        int n4;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = string;
        while (AnsiEscapeCode.toLength((String)string3, (boolean)bl) > n) {
            string2 = string3.substring(0, n + 1);
            string2 = TextBlockBuilder.toTruncateTrailingSpaces(string2, bl);
            n4 = -1;
            for (n3 = 0; n3 < CharSet.END_OF_LINE.getCharSet().length; ++n3) {
                n2 = string2.indexOf(CharSet.END_OF_LINE.getCharSet()[n3]);
                if (n4 != -1 && (n2 == -1 || n2 >= n4)) continue;
                n4 = n2;
            }
            if (n4 > n) {
                for (n3 = 0; n3 < CharSet.LINE_BREAK_MARKERS.getCharSet().length; ++n3) {
                    n2 = string2.lastIndexOf(CharSet.LINE_BREAK_MARKERS.getCharSet()[n3]);
                    if (n4 != -1 && (n2 == -1 || n2 <= n4)) continue;
                    n4 = n2;
                }
            }
            if (n4 != -1) {
                string2 = string3.substring(0, n4 + 1);
                string2 = TextBlockBuilder.toTruncateTrailingSpaces(string2, bl);
                if (AnsiEscapeCode.toLength((String)string3, (boolean)bl) > n4) {
                    string3 = string3.substring(n4 + 1);
                    string3 = TextBlockBuilder.toTruncatePrefixedSpaces(string3, bl);
                } else {
                    string3 = "";
                }
            } else if (AnsiEscapeCode.toLength((String)string3, (boolean)bl) > n) {
                string2 = string3.substring(0, n);
                string3 = string3.substring(n);
            } else {
                string3 = "";
            }
            arrayList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{TextBlockBuilder.toNonBreakingLine(string2)})).withColumnWidth(n).withFillChar(c).withHorizAlignTextMode(horizAlignTextMode).toString());
        }
        if (AnsiEscapeCode.toLength((String)string3, (boolean)bl) > 0) {
            do {
                n4 = -1;
                for (n3 = 0; n3 < CharSet.END_OF_LINE.getCharSet().length; ++n3) {
                    n2 = string3.indexOf(CharSet.END_OF_LINE.getCharSet()[n3]);
                    if (n4 != -1 && (n2 == -1 || n2 >= n4)) continue;
                    n4 = n2;
                }
                if (n4 == -1) continue;
                string2 = string3.substring(0, n4 + 1);
                string2 = TextBlockBuilder.toTruncateTrailingSpaces(string2, bl);
                if (AnsiEscapeCode.toLength((String)string3, (boolean)bl) > n4) {
                    string3 = string3.substring(n4 + 1);
                    string3 = TextBlockBuilder.toTruncatePrefixedSpaces(string3, bl);
                    arrayList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{TextBlockBuilder.toNonBreakingLine(string2)})).withColumnWidth(n).withFillChar(c).withHorizAlignTextMode(horizAlignTextMode).toString());
                    continue;
                }
                string3 = "";
            } while (n4 != -1);
        }
        if (AnsiEscapeCode.toLength((String)string3, (boolean)bl) > 0) {
            arrayList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{TextBlockBuilder.toNonBreakingLine(string3)})).withColumnWidth(n).withFillChar(c).withHorizAlignTextMode(horizAlignTextMode).toString());
        }
        if (arrayList.size() == 0) {
            stringArray = new String[]{string};
        } else {
            stringArray = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
        }
        return stringArray;
    }

    private static String[] toSplitAtEndOfLineTextBlock(String string, int n, HorizAlignTextMode horizAlignTextMode, char c, boolean bl) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        while (AnsiEscapeCode.toLength((String)string2, (boolean)bl) > n) {
            String string3 = string2.substring(0, n + 1);
            string3 = TextBlockBuilder.toTruncateTrailingSpaces(string3, bl);
            int n2 = -1;
            for (int i = 0; i < CharSet.LINE_BREAK_MARKERS.getCharSet().length; ++i) {
                int n3 = string3.lastIndexOf(CharSet.LINE_BREAK_MARKERS.getCharSet()[i]);
                if (n2 != -1 && (n3 == -1 || n3 <= n2)) continue;
                n2 = n3;
            }
            if (n2 != -1) {
                string3 = string2.substring(0, n2 + 1);
                string3 = TextBlockBuilder.toTruncateTrailingSpaces(string3, bl);
                if (AnsiEscapeCode.toLength((String)string2, (boolean)bl) > n2) {
                    string2 = string2.substring(n2 + 1);
                    string2 = TextBlockBuilder.toTruncatePrefixedSpaces(string2, bl);
                } else {
                    string2 = "";
                }
            } else if (AnsiEscapeCode.toLength((String)string2, (boolean)bl) > n) {
                string3 = string2.substring(0, n);
                string2 = string2.substring(n);
            } else {
                string2 = "";
            }
            arrayList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{TextBlockBuilder.toNonBreakingLine(string3)})).withColumnWidth(n).withFillChar(c).withHorizAlignTextMode(horizAlignTextMode).toString());
        }
        if (AnsiEscapeCode.toLength((String)string2, (boolean)bl) > 0) {
            arrayList.add(((HorizAlignTextBuilder)new HorizAlignTextBuilder().withText(new String[]{TextBlockBuilder.toNonBreakingLine(string2)})).withColumnWidth(n).withFillChar(c).withHorizAlignTextMode(horizAlignTextMode).toString());
        }
        if (arrayList.size() == 0) {
            stringArray = new String[]{string};
        } else {
            stringArray = new String[arrayList.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)arrayList.get(i);
            }
        }
        return stringArray;
    }

    private static String toTruncateTrailingSpaces(String string, boolean bl) {
        while (AnsiEscapeCode.toLength((String)string, (boolean)bl) > 0 && string.charAt(string.length() - 1) == ' ') {
            string = string.substring(0, AnsiEscapeCode.toLength((String)string, (boolean)bl) - 1);
        }
        return string;
    }

    private static String toTruncatePrefixedSpaces(String string, boolean bl) {
        if (AnsiEscapeCode.toLength((String)string, (boolean)bl) > 1) {
            while (string.charAt(0) == ' ') {
                string = string.substring(1);
            }
        }
        return string;
    }
}

