/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.data.CharSet;
import org.refcodes.mixin.TruncateMode;
import org.refcodes.mixin.TruncateModeAccessor;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.Text;

public class TruncateTextBuilder
extends AbstractText<TruncateTextBuilder>
implements Text<TruncateTextBuilder>,
TruncateModeAccessor.TruncateModeProperty,
TruncateModeAccessor.TruncateModeBuilder<TruncateTextBuilder> {
    private TruncateMode _truncateTextMode = TruncateMode.TAIL;
    private char[] _truncateChars = CharSet.WHITE_SPACES.getCharSet();

    public TruncateMode getTruncateMode() {
        return this._truncateTextMode;
    }

    public void setTruncateMode(TruncateMode truncateMode) {
        this._truncateTextMode = truncateMode;
    }

    public char[] getTruncateChars() {
        return this._truncateChars;
    }

    public void setTruncateChars(char ... cArray) {
        this._truncateChars = cArray;
    }

    @Override
    public String[] toStrings() {
        return this.toStrings(this.getText());
    }

    @Override
    public String[] toStrings(String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = TruncateTextBuilder.asTruncated(stringArray[i], this._truncateTextMode, this._truncateChars);
        }
        return stringArray2;
    }

    public TruncateTextBuilder withTruncateMode(TruncateMode truncateMode) {
        this.setTruncateMode(truncateMode);
        return this;
    }

    @Override
    public TruncateTextBuilder withText(String ... stringArray) {
        this.setText(stringArray);
        return this;
    }

    public TruncateTextBuilder withStripChars(char ... cArray) {
        this.setTruncateChars(cArray);
        return this;
    }

    @Override
    public String toString() throws IllegalStateException {
        return super.toString();
    }

    public static String asTruncated(String string, TruncateMode truncateMode) {
        return TruncateTextBuilder.asTruncated(string, truncateMode, CharSet.WHITE_SPACES.getCharSet());
    }

    public static String asTruncated(String string, TruncateMode truncateMode, char ... cArray) {
        switch (truncateMode) {
            case HEAD: {
                return TruncateTextBuilder.asTruncatedLeft(string, cArray);
            }
            case HEAD_AND_TAIL: {
                return TruncateTextBuilder.toStrip(string, cArray);
            }
            case TAIL: {
                return TruncateTextBuilder.asTruncatedRight(string, cArray);
            }
        }
        throw new IllegalArgumentException("You must pass a valid text strip mode, though you actually passed <" + truncateMode + ">!");
    }

    public static String asTruncatedLeft(String string) {
        return TruncateTextBuilder.asTruncatedRight(string, CharSet.WHITE_SPACES.getCharSet());
    }

    public static String asTruncatedLeft(String string, char ... cArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < cArray.length; ++i) {
            TruncateTextBuilder.doStripLeft(stringBuffer, cArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String asTruncatedRight(String string) {
        return TruncateTextBuilder.asTruncatedRight(string, CharSet.WHITE_SPACES.getCharSet());
    }

    public static String asTruncatedRight(String string, char ... cArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < cArray.length; ++i) {
            TruncateTextBuilder.doStripRight(stringBuffer, cArray[i]);
        }
        return stringBuffer.toString();
    }

    protected static void doStripLeft(StringBuffer stringBuffer, char c) {
        for (int i = 0; i < stringBuffer.length() && stringBuffer.charAt(i) == c; ++i) {
            stringBuffer.deleteCharAt(i);
            --i;
        }
    }

    protected static void doStripRight(StringBuffer stringBuffer, char c) {
        for (int i = stringBuffer.length() - 1; i >= 0 && stringBuffer.charAt(i) == c; --i) {
            stringBuffer.deleteCharAt(i);
        }
    }

    protected static void doStrip(StringBuffer stringBuffer, char c) {
        TruncateTextBuilder.doStripLeft(stringBuffer, c);
        TruncateTextBuilder.doStripRight(stringBuffer, c);
    }

    protected static String toStrip(String string, char[] cArray) {
        return TruncateTextBuilder.asTruncatedRight(TruncateTextBuilder.asTruncatedLeft(string, cArray), cArray);
    }
}

