/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.time;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public final class DateUtility {
    private DateUtility() {
    }

    public static Date toDate(String aDateString, DateTimeFormatter[] aDateTimeFormatters) {
        Throwable theFirstException = null;
        for (DateTimeFormatter eDateFormat : aDateTimeFormatters) {
            try {
                TemporalAccessor eTemporal = eDateFormat.parse(aDateString);
                Instant theInstant = Instant.from(eTemporal);
                return new Date(theInstant.toEpochMilli());
            }
            catch (Exception e) {
                try {
                    if (theFirstException != null) {
                        theFirstException = e;
                    }
                    LocalDate theLocalDate = LocalDate.parse(aDateString, eDateFormat);
                    return Date.from(theLocalDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                }
                catch (Exception e2) {
                    if (theFirstException == null) continue;
                    theFirstException = e2;
                }
            }
        }
        if (theFirstException != null) {
            if (theFirstException instanceof DateTimeException) {
                throw (DateTimeException)theFirstException;
            }
            throw new DateTimeException("Unable to parse date for date string <" + aDateString + ">: " + theFirstException.getMessage(), theFirstException);
        }
        throw new DateTimeException("Unable to parse date for date string <" + aDateString + ">.");
    }

    public static LocalDate toLocalDate(String aDateString, DateTimeFormatter[] aDateTimeFormatters) {
        Throwable theFirstException = null;
        for (DateTimeFormatter eDateFormat : aDateTimeFormatters) {
            try {
                return LocalDate.parse(aDateString, eDateFormat);
            }
            catch (Exception e) {
                if (theFirstException == null) continue;
                theFirstException = e;
            }
        }
        if (theFirstException != null) {
            if (theFirstException instanceof DateTimeException) {
                throw (DateTimeException)theFirstException;
            }
            throw new DateTimeException("Unable to parse date for date string <" + aDateString + ">: " + theFirstException.getMessage(), theFirstException);
        }
        throw new DateTimeException("Unable to parse date for date string <" + aDateString + ">.");
    }

    public static LocalDateTime toLocalDateTime(String aDateString, DateTimeFormatter[] aDateTimeFormatters) {
        Throwable theFirstException = null;
        for (DateTimeFormatter eDateFormat : aDateTimeFormatters) {
            try {
                return LocalDateTime.parse(aDateString, eDateFormat);
            }
            catch (Exception e) {
                if (theFirstException == null) continue;
                theFirstException = e;
            }
        }
        if (theFirstException != null) {
            if (theFirstException instanceof DateTimeException) {
                throw (DateTimeException)theFirstException;
            }
            throw new DateTimeException("Unable to parse date for date string <" + aDateString + ">: " + theFirstException.getMessage(), theFirstException);
        }
        throw new DateTimeException("Unable to parse date for date string <" + aDateString + ">.");
    }
}

