/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test.conformance.declaredmethods;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.VoidTypeInfo;
import org.reflext.test.ReflectUnitTest;

public class DeclaredMethodsUnitTest
extends ReflectUnitTest {
    protected void execute() throws Exception {
        this.testA();
        this.testB();
        this.testC();
        this.testD();
        this.testE();
        this.testF();
    }

    private void testA() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getTypeInfo("A");
        this.assertHasMethods(ti);
    }

    private void testB() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getTypeInfo("B");
        this.assertHasNoMethods(ti);
    }

    private void testC() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getTypeInfo("C");
        this.assertHasNoMethods(ti);
    }

    private void testD() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getTypeInfo("D");
        this.assertHasMethods(ti);
    }

    private void testE() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getTypeInfo("E");
        this.assertHasMethods(ti);
    }

    private void testF() {
        ClassTypeInfo ti = (ClassTypeInfo)this.getTypeInfo("F");
        this.assertHasNoMethods(ti);
    }

    private void assertHasMethods(ClassTypeInfo cti) {
        List list = cti.getDeclaredMethods();
        Collections.sort(list, new Comparator<MethodInfo>(){

            @Override
            public int compare(MethodInfo o1, MethodInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        DeclaredMethodsUnitTest.assertEquals((int)2, (int)list.size());
        MethodInfo m1 = (MethodInfo)list.get(0);
        DeclaredMethodsUnitTest.assertEquals((String)"m1", (String)m1.getName());
        TypeInfo m1rt = m1.getReturnType();
        DeclaredMethodsUnitTest.assertTrue((String)("Was expecting return type to be void instead of " + m1rt), (boolean)(m1rt instanceof VoidTypeInfo));
        MethodInfo m2 = (MethodInfo)list.get(1);
        DeclaredMethodsUnitTest.assertEquals((String)"m2", (String)m2.getName());
        DeclaredMethodsUnitTest.assertTrue((boolean)(m2.getReturnType() instanceof ClassTypeInfo));
        ClassTypeInfo m2rt = (ClassTypeInfo)m2.getReturnType();
        DeclaredMethodsUnitTest.assertEquals((String)String.class.getName(), (String)m2rt.getName());
    }

    private void assertHasNoMethods(ClassTypeInfo cti) {
        List list = cti.getDeclaredMethods();
        DeclaredMethodsUnitTest.assertEquals((int)0, (int)list.size());
    }
}

