/*
 * Decompiled with CFR 0.152.
 */
package org.reflext.test.conformance.simpletype;

import org.reflext.api.LiteralType;
import org.reflext.api.SimpleTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.test.ReflectUnitTest;

public class SimpleTypeUnitTest
extends ReflectUnitTest {
    private void assertSimple(String id, LiteralType literalType, boolean primitive, Class expectedClass) {
        TypeInfo typeInfo = this.getTypeInfo(id);
        SimpleTypeUnitTest.assertTrue((boolean)(typeInfo instanceof SimpleTypeInfo));
        SimpleTypeInfo simpleType = (SimpleTypeInfo)typeInfo;
        SimpleTypeUnitTest.assertEquals((Object)literalType, (Object)simpleType.getLiteralType());
        SimpleTypeUnitTest.assertEquals((boolean)primitive, (boolean)simpleType.isPrimitive());
        SimpleTypeUnitTest.assertEquals((String)expectedClass.getName(), (String)simpleType.getName());
    }

    protected void execute() throws Exception {
        this.testTypes();
    }

    private void testTypes() {
        this.assertSimple("boolean", LiteralType.BOOLEAN, true, Boolean.TYPE);
        this.assertSimple("byte", LiteralType.BYTE, true, Byte.TYPE);
        this.assertSimple("short", LiteralType.SHORT, true, Short.TYPE);
        this.assertSimple("int", LiteralType.INT, true, Integer.TYPE);
        this.assertSimple("long", LiteralType.LONG, true, Long.TYPE);
        this.assertSimple("float", LiteralType.FLOAT, true, Float.TYPE);
        this.assertSimple("double", LiteralType.DOUBLE, true, Double.TYPE);
        this.assertSimple("Boolean", LiteralType.BOOLEAN, false, Boolean.class);
        this.assertSimple("Byte", LiteralType.BYTE, false, Byte.class);
        this.assertSimple("Short", LiteralType.SHORT, false, Short.class);
        this.assertSimple("Integer", LiteralType.INT, false, Integer.class);
        this.assertSimple("Long", LiteralType.LONG, false, Long.class);
        this.assertSimple("Float", LiteralType.FLOAT, false, Float.class);
        this.assertSimple("Double", LiteralType.DOUBLE, false, Double.class);
    }
}

