/*
 * Decompiled with CFR 0.152.
 */
package org.requs.maven;

import com.jcabi.log.Logger;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.requs.Compiler;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="compile", threadSafe=true, defaultPhase=LifecyclePhase.COMPILE)
public final class CompileMojo
extends AbstractMojo {
    @NotNull
    @Parameter(required=true, defaultValue="${basedir}/src/main/requs")
    private transient File input;
    @NotNull
    @Parameter(required=true, defaultValue="${project.build.directory}/requs")
    private transient File output;

    public void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        try {
            new Compiler(this.input, this.output).compile();
            XMLDocument srs = new XMLDocument(new File(this.output, "main.xml"));
            List errors = srs.nodes("//errors/error");
            if (!errors.isEmpty()) {
                for (XML error : errors) {
                    Logger.error((Object)((Object)this), (String)"%s:%s %s", (Object[])new Object[]{error.xpath("@line").get(0), error.xpath("@pos").get(0), error.xpath("text()").get(0)});
                }
                throw new MojoFailureException(String.format("%d requs error(s), see log above", errors.size()));
            }
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("IO failure", ex);
        }
    }

    public String toString() {
        return "CompileMojo(input=" + this.input + ", output=" + this.output + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompileMojo)) {
            return false;
        }
        CompileMojo other = (CompileMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    public boolean canEqual(Object other) {
        return other instanceof CompileMojo;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

