/*
 * Decompiled with CFR 0.152.
 */
package org.requs.maven;

import com.jcabi.log.Logger;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.validation.constraints.NotNull;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.requs.Compiler;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="default")
public final class ReportMojo
extends AbstractMavenReport {
    @NotNull
    @Component
    private transient MavenProject project;
    @NotNull
    @Parameter(property="project.reporting.outputDirectory", required=true)
    private transient File output;
    @NotNull
    @Parameter(required=true, defaultValue="${basedir}/src/main/requs")
    private transient File source;
    @NotNull
    @Component
    private transient Renderer renderer;

    public String getOutputName() {
        return "requs";
    }

    public String getName(Locale locale) {
        return "Requs";
    }

    public String getDescription(Locale locale) {
        return "Requs Facet";
    }

    public Renderer getSiteRenderer() {
        return this.renderer;
    }

    public String getOutputDirectory() {
        return this.output.getAbsolutePath();
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        throw new MavenReportException("not supported");
    }

    public void generate(Sink snk, SinkFactory factory, Locale locale) throws MavenReportException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        File home = new File(this.getOutputDirectory(), this.getOutputName());
        if (home.mkdirs()) {
            Logger.info((Object)((Object)this), (String)"site directory %s created", (Object[])new Object[]{home});
        }
        snk.section1();
        snk.sectionTitle1();
        snk.text("Requs Facets");
        snk.sectionTitle1_();
        snk.table();
        snk.tableRow();
        snk.tableHeaderCell();
        snk.text("Facet");
        snk.tableHeaderCell_();
        snk.tableHeaderCell();
        snk.text("Description");
        snk.tableHeaderCell_();
        snk.tableRow_();
        for (XML facet : this.facets(home)) {
            snk.tableRow();
            snk.tableCell();
            snk.link(String.format("%s/%s", this.getOutputName(), facet.xpath("file/text()").get(0)));
            snk.text((String)facet.xpath("@id").get(0));
            snk.link_();
            snk.tableCell_();
            snk.tableCell();
            snk.text((String)facet.xpath("description/text()").get(0));
            snk.tableCell_();
            snk.tableRow_();
        }
        snk.table_();
        snk.paragraph();
        snk.text("More information you can get at ");
        snk.link("http://www.requs.org");
        snk.text("www.requs.org");
        snk.link_();
        snk.text(".");
        snk.paragraph_();
        snk.section1_();
    }

    private Iterable<XML> facets(File dir) throws MavenReportException {
        try {
            new Compiler(this.source, dir).compile();
            return new XMLDocument(new File(dir, "index.xml")).nodes("/index/facets/facet");
        }
        catch (IOException ex) {
            throw new MavenReportException("failed to compile", (Exception)ex);
        }
    }

    public String toString() {
        return "ReportMojo(project=" + this.getProject() + ", output=" + this.output + ", source=" + this.source + ", renderer=" + this.renderer + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportMojo)) {
            return false;
        }
        ReportMojo other = (ReportMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    public boolean canEqual(Object other) {
        return other instanceof ReportMojo;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }
}

