/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.application;

import java.net.UnknownHostException;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipURI;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.InstanceIdDao;
import org.restcomm.connect.dao.entities.InstanceId;

public class GenerateInstanceId {
    private final Logger logger = Logger.getLogger(GenerateInstanceId.class);
    private final ServletContext servletContext;
    private final InstanceIdDao instanceIdDao;
    private final String host;

    public GenerateInstanceId(ServletContext servletContext, SipURI sipURI) throws UnknownHostException {
        this.servletContext = servletContext;
        this.host = sipURI.getHost() + ":" + sipURI.getPort();
        this.logger.info((Object)("Host for InstanceId: " + this.host));
        this.instanceIdDao = ((DaoManager)servletContext.getAttribute(DaoManager.class.getName())).getInstanceIdDao();
    }

    public InstanceId instanceId() {
        InstanceId instanceId = this.instanceIdDao.getInstanceIdByHost(this.host);
        if (instanceId != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Restcomm Instance ID: " + instanceId.toString()));
            }
        } else {
            instanceId = new InstanceId(Sid.generate((Sid.Type)Sid.Type.INSTANCE), this.host, DateTime.now(), DateTime.now());
            this.instanceIdDao.addInstancecId(instanceId);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Restcomm Instance ID created: " + instanceId.toString()));
            }
        }
        this.servletContext.setAttribute(InstanceId.class.getName(), (Object)instanceId);
        return instanceId;
    }
}

