/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.application;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActorFactory;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.MsControlFactory;
import javax.media.mscontrol.spi.Driver;
import javax.media.mscontrol.spi.DriverManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipURI;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.mobicents.servlet.sip.SipConnector;
import org.restcomm.connect.application.GenerateInstanceId;
import org.restcomm.connect.application.RvdProjectsMigrator;
import org.restcomm.connect.application.config.ConfigurationStringLookup;
import org.restcomm.connect.commons.Version;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.loader.ObjectFactory;
import org.restcomm.connect.commons.loader.ObjectInstantiationException;
import org.restcomm.connect.commons.util.DNSUtils;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.InstanceId;
import org.restcomm.connect.dao.entities.Organization;
import org.restcomm.connect.dao.entities.shiro.ShiroResources;
import org.restcomm.connect.extension.controller.ExtensionBootstrapper;
import org.restcomm.connect.identity.IdentityContext;
import org.restcomm.connect.monitoringservice.MonitoringService;
import org.restcomm.connect.mrb.api.StartMediaResourceBroker;
import org.restcomm.connect.mscontrol.api.MediaServerControllerFactory;
import org.restcomm.connect.mscontrol.api.MediaServerInfo;
import org.restcomm.connect.mscontrol.jsr309.Jsr309ControllerFactory;
import org.restcomm.connect.mscontrol.mms.MmsControllerFactory;
import scala.concurrent.ExecutionContext;

public final class Bootstrapper
extends SipServlet
implements SipServletListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Bootstrapper.class);
    private ActorSystem system;
    private ExecutionContext ec;

    public void destroy() {
        this.system.shutdown();
        this.system.awaitTermination();
    }

    private MediaServerControllerFactory mediaServerControllerFactory(Configuration configuration, ClassLoader loader, DaoManager storage) throws ServletException {
        MmsControllerFactory factory;
        String compatibility;
        switch (compatibility = configuration.subset("mscontrol").getString("compatibility", "rms")) {
            case "rms": {
                try {
                    Configuration settings = configuration.subset("media-server-manager");
                    ActorRef mrb = this.mediaResourceBroker(settings, storage, loader);
                    factory = new MmsControllerFactory(mrb);
                    break;
                }
                catch (UnknownHostException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            case "xms": {
                try {
                    Configuration settings = configuration.subset("mscontrol");
                    String driverName = settings.getString("media-server[@class]");
                    Driver driver = DriverManager.getDriver((String)driverName);
                    DriverManager.registerDriver((Driver)driver);
                    Properties properties = this.getDialogicXmsProperties(settings);
                    MsControlFactory msControlFactory = driver.getFactory(properties);
                    MediaServerInfo mediaServerInfo = this.mediaServerInfo(settings);
                    factory = new Jsr309ControllerFactory(mediaServerInfo, msControlFactory);
                    break;
                }
                catch (UnknownHostException | MsControlException e) {
                    throw new ServletException(e);
                }
            }
            default: {
                throw new IllegalArgumentException("MSControl unknown compatibility mode: " + compatibility);
            }
        }
        return factory;
    }

    private MediaServerInfo mediaServerInfo(Configuration configuration) throws UnknownHostException {
        String name = configuration.getString("media-server[@name]");
        String address = configuration.getString("media-server.address");
        int port = configuration.getInt("media-server.port");
        int timeout = configuration.getInt("media-server.timeout", 5);
        return new MediaServerInfo(name, DNSUtils.getByName((String)address), port, timeout);
    }

    private Properties getDialogicXmsProperties(Configuration configuration) {
        Properties properties = new Properties();
        String mediaTransport = configuration.getString("media-server.transport", "udp");
        if (logger.isInfoEnabled()) {
            logger.info((Object)"JSR 309 - media-server.transport: udp");
        }
        properties.setProperty("connector.sip.transport", mediaTransport);
        SipURI sipURI = this.outboundInterface(this.getServletContext(), mediaTransport);
        properties.setProperty("connector.sip.address", sipURI.getHost());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("JSR 309 - connector.sip.address: " + sipURI.getHost()));
        }
        properties.setProperty("connector.sip.port", String.valueOf(sipURI.getPort()));
        if (logger.isInfoEnabled()) {
            logger.info((Object)("JSR 309 - connector.sip.port: " + String.valueOf(sipURI.getPort())));
        }
        String mediaAddress = configuration.getString("media-server.address", "127.0.0.1");
        properties.setProperty("mediaserver.sip.ipaddress", mediaAddress);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("JSR 309 - mediaserver.sip.ipaddress: " + mediaAddress));
        }
        String mediaPort = configuration.getString("media-server.port", "5060");
        properties.setProperty("mediaserver.sip.port", mediaPort);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("JSR 309 - mediaserver.sip.port: " + mediaPort));
        }
        properties.setProperty("connector.conferenceControlLeg", "no");
        return properties;
    }

    private SipURI outboundInterface(ServletContext context, String transport) {
        SipURI result = null;
        List uris = (List)context.getAttribute("javax.servlet.sip.outboundInterfaces");
        if (uris != null && uris.size() > 0) {
            for (SipURI uri : uris) {
                String interfaceTransport = uri.getTransportParam();
                if (!transport.equalsIgnoreCase(interfaceTransport)) continue;
                result = uri;
            }
            if (logger.isInfoEnabled()) {
                if (result == null) {
                    logger.info((Object)("Outbound interface is NULL! Looks like there was no " + transport + " in the list of connectors"));
                } else {
                    logger.info((Object)("Outbound interface found: " + result.toString()));
                }
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)"ServletContext return null or empty list of connectors");
        }
        return result;
    }

    private ActorRef mediaResourceBroker(Configuration configuration, DaoManager storage, ClassLoader loader) throws UnknownHostException {
        Props props = new Props((UntypedActorFactory)new /* Unavailable Anonymous Inner Class!! */);
        ActorRef mrb = this.system.actorOf(props);
        mrb.tell((Object)new StartMediaResourceBroker(configuration, storage, loader), null);
        return mrb;
    }

    private String home(ServletContext context) {
        String path = context.getRealPath("/");
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    private DaoManager storage(Configuration configuration, Configuration daoManagerConfiguration, ClassLoader loader, ExecutionContext ec) throws ObjectInstantiationException {
        String classpath = daoManagerConfiguration.getString("dao-manager[@class]");
        DaoManager daoManager = (DaoManager)new ObjectFactory(loader).getObjectInstance(classpath);
        daoManager.configure(configuration, daoManagerConfiguration, ec);
        daoManager.start();
        return daoManager;
    }

    private ActorRef monitoringService(Configuration configuration, DaoManager daoManager, ClassLoader loader) {
        Props props = new Props((UntypedActorFactory)new /* Unavailable Anonymous Inner Class!! */);
        return this.system.actorOf(props);
    }

    private String uri(ServletContext context) {
        return context.getContextPath();
    }

    private boolean generateDefaultDomainName(Configuration configuration, DaoManager storage) {
        try {
            Sid defaultOrganization = new Sid("ORafbe225ad37541eba518a74248f0ac4c");
            String hostname = configuration.getString("hostname");
            if (hostname != null && !hostname.trim().equals("")) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Generate Default Domain Name based on RC hostname: " + hostname));
                }
            } else {
                logger.error((Object)"Unable to generateDefaultDomainName hostname property is null in restcomm.xml");
                return false;
            }
            Organization organization = storage.getOrganizationsDao().getOrganization(defaultOrganization);
            if (organization == null) {
                storage.getOrganizationsDao().addOrganization(new Organization(defaultOrganization, hostname, DateTime.now(), DateTime.now()));
            } else {
                organization = organization.setDomainName(hostname);
                storage.getOrganizationsDao().updateOrganization(organization);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Unable to generateDefaultDomainName {}", (Throwable)e);
            return false;
        }
        return true;
    }

    public void servletInitialized(SipServletContextEvent event) {
        if (event.getSipServlet().getClass().equals(Bootstrapper.class)) {
            ServletContext context = event.getServletContext();
            String path = context.getRealPath("WEB-INF/conf/restcomm.xml");
            String extensionConfigurationPath = context.getRealPath("WEB-INF/conf/extensions.xml");
            String daoManagerConfigurationPath = context.getRealPath("WEB-INF/conf/dao-manager.xml");
            ConfigurationStringLookup strings = new ConfigurationStringLookup();
            strings.addProperty("home", this.home(context));
            strings.addProperty("uri", this.uri(context));
            ConfigurationInterpolator.registerGlobalLookup((String)"restcomm", (StrLookup)strings);
            XMLConfiguration xml = null;
            XMLConfiguration extensionConf = null;
            XMLConfiguration daoManagerConf = null;
            try {
                XMLConfiguration xmlConfiguration = new XMLConfiguration();
                xmlConfiguration.setDelimiterParsingDisabled(true);
                xmlConfiguration.setAttributeSplittingDisabled(true);
                xmlConfiguration.load(path);
                xml = xmlConfiguration;
                extensionConf = new XMLConfiguration();
                extensionConf.setDelimiterParsingDisabled(true);
                extensionConf.setAttributeSplittingDisabled(true);
                extensionConf.load(extensionConfigurationPath);
                daoManagerConf = new XMLConfiguration();
                daoManagerConf.setDelimiterParsingDisabled(true);
                daoManagerConf.setAttributeSplittingDisabled(true);
                daoManagerConf.load(daoManagerConfigurationPath);
            }
            catch (ConfigurationException exception) {
                logger.error((Object)exception);
            }
            xml.setProperty("runtime-settings.home-directory", (Object)this.home(context));
            xml.setProperty("runtime-settings.root-uri", (Object)this.uri(context));
            DNSUtils.initializeDnsUtilImplClassName((Configuration)xml);
            RestcommConfiguration.createOnce((Configuration)xml);
            context.setAttribute(Configuration.class.getName(), (Object)xml);
            context.setAttribute("ExtensionConfiguration", (Object)extensionConf);
            ClassLoader loader = this.getClass().getClassLoader();
            Config settings = ConfigFactory.load();
            this.system = ActorSystem.create((String)"RestComm", (Config)settings, (ClassLoader)loader);
            context.setAttribute(ActorSystem.class.getName(), (Object)this.system);
            this.ec = this.system.dispatchers().lookup("restcomm-blocking-dispatcher");
            DaoManager storage = null;
            try {
                storage = this.storage((Configuration)xml, (Configuration)daoManagerConf, loader, this.ec);
            }
            catch (ObjectInstantiationException exception) {
                logger.error((Object)"ObjectInstantiationException during initialization: ", (Throwable)exception);
            }
            context.setAttribute(DaoManager.class.getName(), (Object)storage);
            ShiroResources.getInstance().set(Configuration.class, (Object)xml.subset("runtime-settings"));
            IdentityContext identityContext = new IdentityContext((Configuration)xml);
            context.setAttribute(IdentityContext.class.getName(), (Object)identityContext);
            ActorRef monitoring = this.monitoringService((Configuration)xml, storage, loader);
            if (monitoring != null) {
                context.setAttribute(MonitoringService.class.getName(), (Object)monitoring);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Monitoring Service created and stored in the context");
                }
            } else {
                logger.error((Object)"Monitoring Service is null");
            }
            XMLConfiguration extensionConfiguration = null;
            try {
                extensionConfiguration = new XMLConfiguration(extensionConfigurationPath);
            }
            catch (ConfigurationException exception) {
                // empty catch block
            }
            ExtensionBootstrapper extensionBootstrapper = new ExtensionBootstrapper(context, (Configuration)extensionConfiguration);
            try {
                extensionBootstrapper.start();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                logger.error((Object)("Exception during extension scanner start: " + e.getStackTrace()));
            }
            MediaServerControllerFactory mscontrollerFactory = null;
            try {
                mscontrollerFactory = this.mediaServerControllerFactory((Configuration)xml, loader, storage);
            }
            catch (ServletException exception) {
                logger.error((Object)"ServletException during initialization: ", (Throwable)exception);
            }
            context.setAttribute(MediaServerControllerFactory.class.getName(), (Object)mscontrollerFactory);
            Boolean rvdMigrationEnabled = new Boolean(xml.subset("runtime-settings").getString("rvd-workspace-migration-enabled", "false"));
            if (rvdMigrationEnabled.booleanValue()) {
                try {
                    RvdProjectsMigrator rvdProjectMigrator = new RvdProjectsMigrator(context, (Configuration)xml);
                    rvdProjectMigrator.executeMigration();
                }
                catch (Exception exception) {
                    logger.error((Object)"RVD Porjects migration failed during initialization: ", (Throwable)exception);
                }
            }
            Version.printVersion();
            GenerateInstanceId generateInstanceId = null;
            InstanceId instanceId = null;
            try {
                SipURI sipURI = this.outboundInterface(context, "udp");
                if (sipURI != null) {
                    generateInstanceId = new GenerateInstanceId(context, sipURI);
                } else if (logger.isInfoEnabled()) {
                    logger.info((Object)"SipURI is NULL!!! Cannot proceed to generate InstanceId");
                }
                instanceId = generateInstanceId.instanceId();
            }
            catch (UnknownHostException e) {
                logger.error((Object)("UnknownHostException during the generation of InstanceId: " + e));
            }
            context.setAttribute(InstanceId.class.getName(), (Object)instanceId);
            monitoring.tell((Object)instanceId, null);
            RestcommConfiguration.getInstance().getMain().setInstanceId(instanceId.getId().toString());
            if (!this.generateDefaultDomainName(xml.subset("http-client"), storage)) {
                logger.error((Object)"Unable to generate DefaultDomainName, Restcomm Akka system will exit now...");
                this.system.shutdown();
                this.system.awaitTermination();
            }
            SipConnector[] connectors = (SipConnector[])context.getAttribute("org.mobicents.servlet.sip.SIP_CONNECTORS");
            Properties loadBalancerCustomInfo = new Properties();
            loadBalancerCustomInfo.setProperty("Restcomm-Instance-Id", instanceId.getId().toString());
            for (SipConnector sipConnector : connectors) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Passing InstanceId " + instanceId.getId().toString() + " to connector " + sipConnector));
                }
                sipConnector.setLoadBalancerCustomInformation(loadBalancerCustomInfo);
            }
        }
    }
}

