/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.http.CallsEndpoint;

@Path(value="/Accounts/{accountSid}/Calls")
@ThreadSafe
public final class CallsXmlEndpoint
extends CallsEndpoint {
    @Path(value="/{sid}.json")
    @GET
    public Response getCallAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getCall(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @GET
    public Response getCallAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getCall(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @GET
    public Response getCalls(@PathParam(value="accountSid") String accountSid, @Context UriInfo info) {
        return this.getCalls(accountSid, info, MediaType.APPLICATION_XML_TYPE);
    }

    @POST
    public Response putCall(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putCall(accountSid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}")
    @POST
    public Response modifyCall(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateCall(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @GET
    @Path(value="/{callSid}/Recordings.json")
    @Produces(value={"application/json"})
    public Response getRecordingsByCallJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="callSid") String callSid) {
        return this.getRecordingsByCall(accountSid, callSid, MediaType.APPLICATION_JSON_TYPE);
    }

    @GET
    @Path(value="/{callSid}/Recordings")
    @Produces(value={"application/xml"})
    public Response getRecordingsByCallXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="callSid") String callSid) {
        return this.getRecordingsByCall(accountSid, callSid, MediaType.APPLICATION_XML_TYPE);
    }
}

