/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public class ClientConverter
extends AbstractConverter
implements JsonSerializer<Client> {
    public ClientConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Client.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Client client = (Client)object;
        writer.startNode("Client");
        this.writeSid(client.getSid(), writer);
        this.writeDateCreated(client.getDateCreated(), writer);
        this.writeDateUpdated(client.getDateUpdated(), writer);
        this.writeAccountSid(client.getAccountSid(), writer);
        this.writeApiVersion(client.getApiVersion(), writer);
        this.writeFriendlyName(client.getFriendlyName(), writer);
        this.writeLogin(client.getLogin(), writer);
        this.writePassword(client.getPassword(), writer);
        this.writeStatus(client.getStatus().toString(), writer);
        this.writeVoiceUrl(client.getVoiceUrl(), writer);
        this.writeVoiceMethod(client.getVoiceMethod(), writer);
        this.writeVoiceFallbackUrl(client.getVoiceFallbackUrl(), writer);
        this.writeVoiceFallbackMethod(client.getVoiceFallbackMethod(), writer);
        this.writeVoiceApplicationSid(client.getVoiceApplicationSid(), writer);
        this.writeUri(client.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Client client, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(client.getSid(), object);
        this.writeDateCreated(client.getDateCreated(), object);
        this.writeDateUpdated(client.getDateUpdated(), object);
        this.writeAccountSid(client.getAccountSid(), object);
        this.writeApiVersion(client.getApiVersion(), object);
        this.writeFriendlyName(client.getFriendlyName(), object);
        this.writeLogin(client.getLogin(), object);
        this.writePassword(client.getPassword(), object);
        this.writeStatus(client.getStatus().toString(), object);
        this.writeVoiceUrl(client.getVoiceUrl(), object);
        this.writeVoiceMethod(client.getVoiceMethod(), object);
        this.writeVoiceFallbackUrl(client.getVoiceFallbackUrl(), object);
        this.writeVoiceFallbackMethod(client.getVoiceFallbackMethod(), object);
        this.writeVoiceApplicationSid(client.getVoiceApplicationSid(), object);
        this.writeUri(client.getUri(), object);
        return object;
    }

    protected void writeLogin(String login, HierarchicalStreamWriter writer) {
        writer.startNode("Login");
        writer.setValue(login);
        writer.endNode();
    }

    protected void writeLogin(String login, JsonObject object) {
        object.addProperty("login", login);
    }

    protected void writePassword(String password, HierarchicalStreamWriter writer) {
        writer.startNode("Password");
        writer.setValue(password);
        writer.endNode();
    }

    protected void writePassword(String password, JsonObject object) {
        object.addProperty("password", password);
    }
}

