/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.util.StringUtils;
import org.restcomm.connect.dao.entities.ConferenceDetailRecord;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class ConferenceDetailRecordConverter
extends AbstractConverter
implements JsonSerializer<ConferenceDetailRecord> {
    private final String apiVersion;
    private final String rootUri;

    public ConferenceDetailRecordConverter(Configuration configuration) {
        super(configuration);
        this.apiVersion = configuration.getString("api-version");
        this.rootUri = StringUtils.addSuffixIfNotPresent((String)configuration.getString("root-uri"), (String)"/");
    }

    @Override
    public boolean canConvert(Class klass) {
        return ConferenceDetailRecord.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        ConferenceDetailRecord cdr = (ConferenceDetailRecord)object;
        writer.startNode("Conference");
        this.writeSid(cdr.getSid(), writer);
        this.writeDateCreated(cdr.getDateCreated(), writer);
        this.writeDateUpdated(cdr.getDateUpdated(), writer);
        this.writeAccountSid(cdr.getAccountSid(), writer);
        this.writeStatus(cdr.getStatus(), writer);
        this.writeApiVersion(cdr.getApiVersion(), writer);
        this.writeFriendlyName(cdr.getFriendlyName(), writer);
        this.writeUri(cdr.getUri(), writer);
        this.writeSubResources(cdr, writer);
        writer.endNode();
    }

    public JsonElement serialize(ConferenceDetailRecord cdr, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(cdr.getSid(), object);
        this.writeDateCreated(cdr.getDateCreated(), object);
        this.writeDateUpdated(cdr.getDateUpdated(), object);
        this.writeAccountSid(cdr.getAccountSid(), object);
        this.writeStatus(cdr.getStatus(), object);
        this.writeApiVersion(cdr.getApiVersion(), object);
        this.writeFriendlyName(cdr.getFriendlyName(), object);
        this.writeUri(cdr.getUri(), object);
        this.writeSubResources(cdr, object);
        return object;
    }

    private void writeSubResources(ConferenceDetailRecord cdr, HierarchicalStreamWriter writer) {
        writer.startNode("SubresourceUris");
        this.writeParticipants(cdr, writer);
        writer.endNode();
    }

    private void writeSubResources(ConferenceDetailRecord cdr, JsonObject object) {
        JsonObject other = new JsonObject();
        this.writeParticipants(cdr, object);
        object.add("subresource_uris", (JsonElement)other);
    }

    private void writeParticipants(ConferenceDetailRecord cdr, HierarchicalStreamWriter writer) {
        writer.startNode("Participants");
        writer.setValue(this.prefix(cdr) + "/Participants");
        writer.endNode();
    }

    private void writeParticipants(ConferenceDetailRecord cdr, JsonObject object) {
        object.addProperty("participants", this.prefix(cdr) + "/Participants");
    }

    private String prefix(ConferenceDetailRecord cdr) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.rootUri).append(this.apiVersion).append("/Accounts/");
        buffer.append(cdr.getAccountSid().toString()).append("/Conferences/");
        buffer.append(cdr.getSid());
        return buffer.toString();
    }
}

