/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.entities.Gateway;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class GatewayConverter
extends AbstractConverter
implements JsonSerializer<Gateway> {
    public GatewayConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Gateway.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Gateway gateway = (Gateway)object;
        writer.startNode("Gateway");
        this.writeSid(gateway.getSid(), writer);
        this.writeDateCreated(gateway.getDateCreated(), writer);
        this.writeDateUpdated(gateway.getDateUpdated(), writer);
        this.writeFriendlyName(gateway.getFriendlyName(), writer);
        this.writePassword(gateway.getPassword(), writer);
        this.writeProxy(gateway.getProxy(), writer);
        this.writeRegister(gateway.register(), writer);
        this.writeUserName(gateway.getUserName(), writer);
        this.writeTimeToLive(gateway.getTimeToLive(), writer);
        this.writeUri(gateway.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Gateway gateway, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(gateway.getSid(), object);
        this.writeDateCreated(gateway.getDateCreated(), object);
        this.writeDateUpdated(gateway.getDateUpdated(), object);
        this.writeFriendlyName(gateway.getFriendlyName(), object);
        this.writePassword(gateway.getPassword(), object);
        this.writeProxy(gateway.getProxy(), object);
        this.writeRegister(gateway.register(), object);
        this.writeUserName(gateway.getUserName(), object);
        this.writeTimeToLive(gateway.getTimeToLive(), object);
        this.writeUri(gateway.getUri(), object);
        return object;
    }

    private void writePassword(String password, HierarchicalStreamWriter writer) {
        writer.startNode("Password");
        writer.setValue(password);
        writer.endNode();
    }

    private void writePassword(String password, JsonObject object) {
        object.addProperty("password", password);
    }

    private void writeProxy(String proxy, HierarchicalStreamWriter writer) {
        writer.startNode("Proxy");
        writer.setValue(proxy);
        writer.endNode();
    }

    private void writeProxy(String proxy, JsonObject object) {
        object.addProperty("proxy", proxy);
    }

    private void writeRegister(boolean register, HierarchicalStreamWriter writer) {
        writer.startNode("Register");
        writer.setValue(Boolean.toString(register));
        writer.endNode();
    }

    private void writeRegister(boolean register, JsonObject object) {
        object.addProperty("register", Boolean.valueOf(register));
    }
}

