/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.entities.Registration;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class RegistrationConverter
extends AbstractConverter
implements JsonSerializer<Registration> {
    public RegistrationConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Registration.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Registration registration = (Registration)object;
        writer.startNode("Registration");
        this.writeSid(registration.getSid(), writer);
        this.writeDateCreated(registration.getDateCreated(), writer);
        this.writeDateUpdated(registration.getDateUpdated(), writer);
        this.writeDateExpires(registration.getDateExpires(), writer);
        this.writeAddressOfRecord(registration.getAddressOfRecord(), writer);
        this.writeDisplayName(registration.getDisplayName(), writer);
        this.writeUserName(registration.getUserName(), writer);
        this.writeTimeToLive(registration.getTimeToLive(), writer);
        this.writeLocation(registration.getLocation(), writer);
        this.writeUserAgent(registration.getUserAgent(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Registration registration, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(registration.getSid(), object);
        this.writeDateCreated(registration.getDateCreated(), object);
        this.writeDateUpdated(registration.getDateUpdated(), object);
        this.writeDateExpires(registration.getDateExpires(), object);
        this.writeAddressOfRecord(registration.getAddressOfRecord(), object);
        this.writeDisplayName(registration.getDisplayName(), object);
        this.writeUserName(registration.getUserName(), object);
        this.writeTimeToLive(registration.getTimeToLive(), object);
        this.writeLocation(registration.getLocation(), object);
        this.writeUserAgent(registration.getUserAgent(), object);
        return object;
    }

    private void writeDateExpires(DateTime dateExpires, HierarchicalStreamWriter writer) {
        writer.startNode("DateExpires");
        writer.setValue(dateExpires.toString());
        writer.endNode();
    }

    private void writeDateExpires(DateTime dateExpires, JsonObject object) {
        object.addProperty("date_expires", dateExpires.toString());
    }

    private void writeAddressOfRecord(String addressOfRecord, HierarchicalStreamWriter writer) {
        writer.startNode("AddressOfRecord");
        writer.setValue(addressOfRecord);
        writer.endNode();
    }

    private void writeAddressOfRecord(String addressOfRecord, JsonObject object) {
        object.addProperty("address_of_record", addressOfRecord.toString());
    }

    private void writeDisplayName(String displayName, HierarchicalStreamWriter writer) {
        writer.startNode("DisplayName");
        writer.setValue(displayName);
        writer.endNode();
    }

    private void writeDisplayName(String displayName, JsonObject object) {
        object.addProperty("display_name", displayName.toString());
    }

    private void writeLocation(String location, HierarchicalStreamWriter writer) {
        writer.startNode("Location");
        writer.setValue(location);
        writer.endNode();
    }

    private void writeLocation(String location, JsonObject object) {
        object.addProperty("location", location.toString());
    }

    private void writeUserAgent(String userAgent, HierarchicalStreamWriter writer) {
        writer.startNode("UserAgent");
        writer.setValue(userAgent);
        writer.endNode();
    }

    private void writeUserAgent(String userAgent, JsonObject object) {
        object.addProperty("user_agent", userAgent.toString());
    }
}

