/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.loader.ObjectInstantiationException;
import org.restcomm.connect.dao.entities.AvailablePhoneNumber;
import org.restcomm.connect.dao.entities.AvailablePhoneNumberList;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.AvailablePhoneNumberConverter;
import org.restcomm.connect.http.converter.AvailablePhoneNumberListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.provisioning.number.api.PhoneNumber;
import org.restcomm.connect.provisioning.number.api.PhoneNumberProvisioningManager;
import org.restcomm.connect.provisioning.number.api.PhoneNumberProvisioningManagerProvider;
import org.restcomm.connect.provisioning.number.api.PhoneNumberSearchFilters;

@ThreadSafe
public abstract class AvailablePhoneNumbersEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected PhoneNumberProvisioningManager phoneNumberProvisioningManager;
    private XStream xstream;
    protected Gson gson;

    @PostConstruct
    public void init() throws ObjectInstantiationException {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        super.init(this.configuration.subset("runtime-settings"));
        this.phoneNumberProvisioningManager = new PhoneNumberProvisioningManagerProvider(this.configuration, this.context).get();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)new AvailablePhoneNumberConverter(this.configuration));
        this.xstream.registerConverter((Converter)new AvailablePhoneNumberListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        this.gson = builder.create();
    }

    protected Response getAvailablePhoneNumbers(String accountSid, String isoCountryCode, PhoneNumberSearchFilters listFilters, String filterPattern, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:AvailablePhoneNumbers");
        String searchPattern = "";
        if (filterPattern != null && !filterPattern.isEmpty()) {
            for (int i = 0; i < filterPattern.length(); ++i) {
                boolean isStar;
                char c = filterPattern.charAt(i);
                boolean isDigit = c >= '0' && c <= '9';
                boolean bl = isStar = c == '*';
                searchPattern = !isDigit && !isStar ? searchPattern.concat(AvailablePhoneNumbersEndpoint.getNumber(c)) : (isStar ? searchPattern.concat("\\d") : searchPattern.concat(Character.toString(c)));
            }
            searchPattern = "((" + searchPattern + ")+).*";
            Pattern pattern = Pattern.compile(searchPattern);
            listFilters.setFilterPattern(pattern);
        }
        List phoneNumbers = this.phoneNumberProvisioningManager.searchForNumbers(isoCountryCode, listFilters);
        List<AvailablePhoneNumber> availablePhoneNumbers = this.toAvailablePhoneNumbers(phoneNumbers);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            return Response.ok((Object)this.xstream.toXML((Object)new RestCommResponse((Object)new AvailablePhoneNumberList(availablePhoneNumbers))), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)phoneNumbers), (String)"application/json").build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    private List<AvailablePhoneNumber> toAvailablePhoneNumbers(List<PhoneNumber> phoneNumbers) {
        ArrayList<AvailablePhoneNumber> availablePhoneNumbers = new ArrayList<AvailablePhoneNumber>();
        for (PhoneNumber phoneNumber : phoneNumbers) {
            AvailablePhoneNumber number = new AvailablePhoneNumber(phoneNumber.getFriendlyName(), phoneNumber.getPhoneNumber(), phoneNumber.getLata(), phoneNumber.getRateCenter(), phoneNumber.getLatitude(), phoneNumber.getLongitude(), phoneNumber.getRegion(), phoneNumber.getPostalCode(), phoneNumber.getIsoCountry(), phoneNumber.getCost(), phoneNumber.isVoiceCapable(), phoneNumber.isSmsCapable(), phoneNumber.isMmsCapable(), phoneNumber.isFaxCapable());
            availablePhoneNumbers.add(number);
        }
        return availablePhoneNumbers;
    }

    public static String getNumber(char letter) {
        if (letter == 'A' || letter == 'B' || letter == 'C' || letter == 'a' || letter == 'b' || letter == 'c') {
            return "1";
        }
        if (letter == 'D' || letter == 'E' || letter == 'F' || letter == 'd' || letter == 'e' || letter == 'f') {
            return "2";
        }
        if (letter == 'G' || letter == 'H' || letter == 'I' || letter == 'g' || letter == 'h' || letter == 'i') {
            return "3";
        }
        if (letter == 'J' || letter == 'K' || letter == 'L' || letter == 'j' || letter == 'k' || letter == 'l') {
            return "4";
        }
        if (letter == 'M' || letter == 'N' || letter == 'O' || letter == 'm' || letter == 'n' || letter == 'o') {
            return "5";
        }
        if (letter == 'P' || letter == 'Q' || letter == 'R' || letter == 'S' || letter == 'p' || letter == 'q' || letter == 'r' || letter == 's') {
            return "6";
        }
        if (letter == 'T' || letter == 'U' || letter == 'V' || letter == 't' || letter == 'u' || letter == 'v') {
            return "7";
        }
        if (letter == 'W' || letter == 'X' || letter == 'Y' || letter == 'Z' || letter == 'w' || letter == 'x' || letter == 'y' || letter == 'z') {
            return "9";
        }
        return "0";
    }
}

