/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.connect.commons.Version;
import org.restcomm.connect.commons.VersionEntity;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.UsageDao;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.http.converter.VersionConverter;

@ThreadSafe
public class VersionEndpoint
extends SecuredEndpoint {
    private static Logger logger = Logger.getLogger(VersionEndpoint.class);
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected UsageDao dao;
    protected Gson gson;
    protected XStream xstream;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        this.dao = storage.getUsageDao();
        this.accountsDao = storage.getAccountsDao();
        VersionConverter converter = new VersionConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(VersionEntity.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    protected Response getVersion(String accountSid, MediaType mediaType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:Usage");
        VersionEntity versionEntity = Version.getVersionEntity();
        if (versionEntity != null) {
            if (MediaType.APPLICATION_XML_TYPE == mediaType) {
                RestCommResponse response = new RestCommResponse((Object)versionEntity);
                return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
            }
            if (MediaType.APPLICATION_JSON_TYPE == mediaType) {
                Response response = Response.ok((Object)this.gson.toJson((Object)versionEntity), (String)"application/json").build();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Supervisor endpoint response: " + this.gson.toJson((Object)versionEntity)));
                }
                return response;
            }
            return null;
        }
        return null;
    }
}

