/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.util.StringUtils;
import org.restcomm.connect.extension.api.ExtensionConfiguration;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class ExtensionConfigurationConverter
extends AbstractConverter
implements JsonSerializer<ExtensionConfiguration> {
    private final String apiVersion;
    private final String rootUri;

    public ExtensionConfigurationConverter(Configuration configuration) {
        super(configuration);
        this.apiVersion = configuration.getString("api-version");
        this.rootUri = StringUtils.addSuffixIfNotPresent((String)configuration.getString("root-uri"), (String)"/");
    }

    @Override
    public boolean canConvert(Class klass) {
        return ExtensionConfiguration.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        ExtensionConfiguration extensionConfiguration = (ExtensionConfiguration)object;
        writer.startNode("ExtensionConfiguration");
        this.writeSid(extensionConfiguration.getSid(), writer);
        writer.startNode("Extension");
        writer.setValue(extensionConfiguration.getExtensionName());
        writer.endNode();
        writer.startNode("Configuration");
        writer.setValue(extensionConfiguration.getConfigurationData().toString());
        writer.endNode();
        writer.startNode("Configuration Type");
        writer.setValue(extensionConfiguration.getConfigurationType().name());
        writer.endNode();
        this.writeDateCreated(extensionConfiguration.getDateCreated(), writer);
        this.writeDateCreated(extensionConfiguration.getDateUpdated(), writer);
        writer.endNode();
    }

    public JsonElement serialize(ExtensionConfiguration extensionConfiguration, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(extensionConfiguration.getSid(), object);
        object.addProperty("extension", extensionConfiguration.getExtensionName());
        object.addProperty("configuration", extensionConfiguration.getConfigurationData().toString());
        object.addProperty("configuration type", extensionConfiguration.getConfigurationType().name());
        this.writeDateCreated(extensionConfiguration.getDateCreated(), object);
        this.writeDateUpdated(extensionConfiguration.getDateUpdated(), object);
        return object;
    }
}

