/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.dao.entities.Geolocation;
import org.restcomm.connect.http.converter.AbstractConverter;

public class GeolocationConverter
extends AbstractConverter
implements JsonSerializer<Geolocation> {
    public GeolocationConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Geolocation.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Geolocation geolocation = (Geolocation)object;
        writer.startNode("Geolocation");
        this.writeSid(geolocation.getSid(), writer);
        this.writeDateCreated(geolocation.getDateCreated(), writer);
        this.writeDateUpdated(geolocation.getDateUpdated(), writer);
        this.writeDateExecuted(geolocation.getDateExecuted(), writer);
        this.writeAccountSid(geolocation.getAccountSid(), writer);
        this.writeSource(geolocation.getSource(), writer);
        this.writeDeviceIdentifier(geolocation.getDeviceIdentifier(), writer);
        this.writeGeolocationType(geolocation.getGeolocationType(), writer);
        this.writeResponseStatus(geolocation.getResponseStatus(), writer);
        this.writeGeolocationData(geolocation, writer);
        this.writeGeolocationPositioningType(geolocation.getGeolocationPositioningType(), writer);
        this.writeLastGeolocationResponse(geolocation.getLastGeolocationResponse(), writer);
        this.writeCause(geolocation.getCause(), writer);
        this.writeApiVersion(geolocation.getApiVersion(), writer);
        this.writeUri(geolocation.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Geolocation geolocation, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(geolocation.getSid(), object);
        this.writeDateCreated(geolocation.getDateCreated(), object);
        this.writeDateUpdated(geolocation.getDateUpdated(), object);
        this.writeDateExecuted(geolocation.getDateExecuted(), object);
        this.writeAccountSid(geolocation.getAccountSid(), object);
        this.writeSource(geolocation.getSource(), object);
        this.writeDeviceIdentifier(geolocation.getDeviceIdentifier(), object);
        this.writeGeolocationType(geolocation.getGeolocationType(), object);
        this.writeResponseStatus(geolocation.getResponseStatus(), object);
        this.writeGeolocationData(geolocation, object);
        this.writeGeolocationPositioningType(geolocation.getGeolocationPositioningType(), object);
        this.writeLastGeolocationResponse(geolocation.getLastGeolocationResponse(), object);
        this.writeCause(geolocation.getCause(), object);
        this.writeApiVersion(geolocation.getApiVersion(), object);
        this.writeUri(geolocation.getUri(), object);
        return object;
    }

    protected void writeDateExecuted(DateTime dateExecuted, HierarchicalStreamWriter writer) {
        writer.startNode("DateExecuted");
        writer.setValue(new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(dateExecuted.toDate()));
        writer.endNode();
    }

    protected void writeDateExecuted(DateTime dateExecuted, JsonObject object) {
        object.addProperty("date_executed", new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(dateExecuted.toDate()));
    }

    protected void writeSource(String source, HierarchicalStreamWriter writer) {
        if (source != null) {
            writer.startNode("Source");
            writer.setValue(source);
            writer.endNode();
        }
    }

    protected void writeSource(String source, JsonObject object) {
        if (source != null) {
            object.addProperty("source", source);
        } else {
            object.add("source", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeDeviceIdentifier(String deviceIdentifier, HierarchicalStreamWriter writer) {
        if (deviceIdentifier != null) {
            writer.startNode("DeviceIdentifier");
            writer.setValue(deviceIdentifier);
            writer.endNode();
        }
    }

    protected void writeDeviceIdentifier(String deviceIdentifier, JsonObject object) {
        if (deviceIdentifier != null) {
            object.addProperty("device_identifier", deviceIdentifier);
        } else {
            object.add("device_identifier", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeGeolocationType(Geolocation.GeolocationType geolocationType, HierarchicalStreamWriter writer) {
        if (geolocationType != null) {
            writer.startNode("GeolocationType");
            writer.setValue(geolocationType.toString());
            writer.endNode();
        }
    }

    protected void writeGeolocationType(Geolocation.GeolocationType geolocationType, JsonObject object) {
        if (geolocationType != null) {
            object.addProperty("geolocation_type", geolocationType.toString());
        } else {
            object.add("geolocation_type", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeResponseStatus(String responseStatus2, HierarchicalStreamWriter writer) {
        if (responseStatus2 != null) {
            writer.startNode("ResponseStatus");
            writer.setValue(responseStatus2);
            writer.endNode();
        }
    }

    protected void writeResponseStatus(String responseStatus2, JsonObject object) {
        if (responseStatus2 != null) {
            object.addProperty("response_status", responseStatus2);
        } else {
            object.add("response_status", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeGeolocationData(Geolocation geolocation, HierarchicalStreamWriter writer) {
        writer.startNode("GeolocationData");
        if (geolocation != null) {
            this.writeCellId(geolocation.getCellId(), writer);
            this.writeLocationAreaCode(geolocation.getLocationAreaCode(), writer);
            this.writeMobileCountryCode(geolocation.getMobileCountryCode(), writer);
            this.writeMobileNetworkCode(geolocation.getMobileNetworkCode(), writer);
            this.writeNetworkEntityAddress(geolocation.getNetworkEntityAddress(), writer);
            this.writeAgeOfLocationInfo(geolocation.getAgeOfLocationInfo(), writer);
            this.writeDeviceLatitude(geolocation.getDeviceLatitude(), writer);
            this.writeDeviceLongitude(geolocation.getDeviceLongitude(), writer);
            this.writeAccuracy(geolocation.getAccuracy(), writer);
            this.writeInternetAddress(geolocation.getInternetAddress(), writer);
            this.writePhysicalAddress(geolocation.getPhysicalAddress(), writer);
            this.writeFormattedAddress(geolocation.getFormattedAddress(), writer);
            this.writeLocationTimestamp(geolocation.getLocationTimestamp(), writer);
            this.writeEventGeofenceLatitude(geolocation.getEventGeofenceLatitude(), writer);
            this.writeEventGeofenceLongitude(geolocation.getEventGeofenceLongitude(), writer);
            this.writeRadius(geolocation.getRadius(), writer);
        }
        writer.endNode();
    }

    protected void writeGeolocationData(Geolocation geolocation, JsonObject object) {
        if (geolocation != null) {
            JsonObject other = new JsonObject();
            this.writeCellId(geolocation.getCellId(), other);
            this.writeLocationAreaCode(geolocation.getLocationAreaCode(), other);
            this.writeMobileCountryCode(geolocation.getMobileCountryCode(), other);
            this.writeMobileNetworkCode(geolocation.getMobileNetworkCode(), other);
            this.writeNetworkEntityAddress(geolocation.getNetworkEntityAddress(), other);
            this.writeAgeOfLocationInfo(geolocation.getAgeOfLocationInfo(), other);
            this.writeDeviceLatitude(geolocation.getDeviceLatitude(), other);
            this.writeDeviceLongitude(geolocation.getDeviceLongitude(), other);
            this.writeAccuracy(geolocation.getAccuracy(), other);
            this.writeInternetAddress(geolocation.getInternetAddress(), other);
            this.writePhysicalAddress(geolocation.getPhysicalAddress(), other);
            this.writeFormattedAddress(geolocation.getFormattedAddress(), other);
            this.writeLocationTimestamp(geolocation.getLocationTimestamp(), other);
            this.writeEventGeofenceLatitude(geolocation.getEventGeofenceLatitude(), other);
            this.writeEventGeofenceLongitude(geolocation.getEventGeofenceLongitude(), other);
            this.writeRadius(geolocation.getRadius(), other);
            object.add("geolocation_data", (JsonElement)other);
        } else {
            object.add("geolocation_data", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeCellId(String cellId, HierarchicalStreamWriter writer) {
        if (cellId != null) {
            writer.startNode("CellId");
            writer.setValue(cellId);
            writer.endNode();
        }
    }

    protected void writeCellId(String cellId, JsonObject object) {
        if (cellId != null) {
            object.addProperty("cell_id", cellId);
        } else {
            object.add("cell_id", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeLocationAreaCode(String locationAreaCode, HierarchicalStreamWriter writer) {
        if (locationAreaCode != null) {
            writer.startNode("LocationAreaCode");
            writer.setValue(locationAreaCode);
            writer.endNode();
        }
    }

    protected void writeLocationAreaCode(String locationAreaCode, JsonObject object) {
        if (locationAreaCode != null) {
            object.addProperty("location_area_code", locationAreaCode);
        } else {
            object.add("location_area_code", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeMobileCountryCode(Integer mobileCountryCode, HierarchicalStreamWriter writer) {
        if (mobileCountryCode != null) {
            writer.startNode("MobileCountryCode");
            writer.setValue(mobileCountryCode.toString());
            writer.endNode();
        }
    }

    protected void writeMobileCountryCode(Integer mobileCountryCode, JsonObject object) {
        if (mobileCountryCode != null) {
            object.addProperty("mobile_country_code", (Number)mobileCountryCode);
        } else {
            object.add("mobile_country_code", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeMobileNetworkCode(String mobileNetworkCode, HierarchicalStreamWriter writer) {
        if (mobileNetworkCode != null) {
            writer.startNode("MobileNetworkCode");
            writer.setValue(mobileNetworkCode.toString());
            writer.endNode();
        }
    }

    protected void writeMobileNetworkCode(String mobileNetworkCode, JsonObject object) {
        if (mobileNetworkCode != null) {
            object.addProperty("mobile_network_code", mobileNetworkCode);
        } else {
            object.add("mobile_network_code", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeNetworkEntityAddress(Long networkEntityAddress, HierarchicalStreamWriter writer) {
        if (networkEntityAddress != null) {
            writer.startNode("NetworkEntityAddress");
            writer.setValue(networkEntityAddress.toString());
            writer.endNode();
        }
    }

    protected void writeNetworkEntityAddress(Long networkEntityAddress, JsonObject object) {
        if (networkEntityAddress != null) {
            object.addProperty("network_entity_address", (Number)networkEntityAddress);
        } else {
            object.add("network_entity_address", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeAgeOfLocationInfo(Integer ageOfLocationInfo, HierarchicalStreamWriter writer) {
        if (ageOfLocationInfo != null) {
            writer.startNode("LocationAge");
            writer.setValue(ageOfLocationInfo.toString());
            writer.endNode();
        }
    }

    protected void writeAgeOfLocationInfo(Integer ageOfLocationInfo, JsonObject object) {
        if (ageOfLocationInfo != null) {
            object.addProperty("location_age", (Number)ageOfLocationInfo);
        } else {
            object.add("location_age", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeDeviceLatitude(String deviceLatitude, HierarchicalStreamWriter writer) {
        if (deviceLatitude != null) {
            writer.startNode("DeviceLatitude");
            writer.setValue(deviceLatitude);
            writer.endNode();
        }
    }

    protected void writeDeviceLatitude(String deviceLatitude, JsonObject object) {
        if (deviceLatitude != null) {
            object.addProperty("device_latitude", deviceLatitude);
        } else {
            object.add("device_latitude", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeDeviceLongitude(String deviceLongitude, HierarchicalStreamWriter writer) {
        if (deviceLongitude != null) {
            writer.startNode("DeviceLongitude");
            writer.setValue(deviceLongitude);
            writer.endNode();
        }
    }

    protected void writeDeviceLongitude(String deviceLongitude, JsonObject object) {
        if (deviceLongitude != null) {
            object.addProperty("device_longitude", deviceLongitude);
        } else {
            object.add("device_longitude", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeAccuracy(Long accuracy, HierarchicalStreamWriter writer) {
        if (accuracy != null) {
            writer.startNode("Accuracy");
            writer.setValue(accuracy.toString());
            writer.endNode();
        }
    }

    protected void writeAccuracy(Long accuracy, JsonObject object) {
        if (accuracy != null) {
            object.addProperty("accuracy", (Number)accuracy);
        } else {
            object.add("accuracy", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writePhysicalAddress(String physicalAddress, HierarchicalStreamWriter writer) {
        if (physicalAddress != null) {
            writer.startNode("PhysicalAddress");
            writer.setValue(physicalAddress);
            writer.endNode();
        }
    }

    protected void writePhysicalAddress(String physicalAddress, JsonObject object) {
        if (physicalAddress != null) {
            object.addProperty("physical_address", physicalAddress);
        } else {
            object.add("physical_address", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeInternetAddress(String internetAddress, HierarchicalStreamWriter writer) {
        if (internetAddress != null) {
            writer.startNode("InternetAddress");
            writer.setValue(internetAddress);
            writer.endNode();
        }
    }

    protected void writeInternetAddress(String internetAddress, JsonObject object) {
        if (internetAddress != null) {
            object.addProperty("internet_address", internetAddress);
        } else {
            object.add("internet_address", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeFormattedAddress(String formattedAddress, HierarchicalStreamWriter writer) {
        if (formattedAddress != null) {
            writer.startNode("FormattedAddress");
            writer.setValue(formattedAddress);
            writer.endNode();
        }
    }

    protected void writeFormattedAddress(String formattedAddress, JsonObject object) {
        if (formattedAddress != null) {
            object.addProperty("formatted_address", formattedAddress);
        } else {
            object.add("formatted_address", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeLocationTimestamp(DateTime locationTimestamp, HierarchicalStreamWriter writer) {
        if (locationTimestamp != null) {
            writer.startNode("LocationTimestamp");
            writer.setValue(new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(locationTimestamp.toDate()));
            writer.endNode();
        }
    }

    protected void writeLocationTimestamp(DateTime locationTimestamp, JsonObject object) {
        if (locationTimestamp != null) {
            object.addProperty("location_timestamp", new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US).format(locationTimestamp.toDate()));
        } else {
            object.add("location_timestamp", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeEventGeofenceLatitude(String eventGeofenceLatitude, HierarchicalStreamWriter writer) {
        if (eventGeofenceLatitude != null) {
            writer.startNode("EventGeofenceLatitude");
            writer.setValue(eventGeofenceLatitude);
            writer.endNode();
        }
    }

    protected void writeEventGeofenceLatitude(String eventGeofenceLatitude, JsonObject object) {
        if (eventGeofenceLatitude != null) {
            object.addProperty("event_geofence_latitude", eventGeofenceLatitude);
        } else {
            object.add("event_geofence_latitude", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeEventGeofenceLongitude(String eventGeofenceLongitude, HierarchicalStreamWriter writer) {
        if (eventGeofenceLongitude != null) {
            writer.startNode("EventGeofenceLongitude");
            writer.setValue(eventGeofenceLongitude);
            writer.endNode();
        }
    }

    protected void writeEventGeofenceLongitude(String eventGeofenceLongitude, JsonObject object) {
        if (eventGeofenceLongitude != null) {
            object.addProperty("event_geofence_longitude", eventGeofenceLongitude);
        } else {
            object.add("event_geofence_longitude", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeRadius(Long radius, HierarchicalStreamWriter writer) {
        if (radius != null) {
            writer.startNode("Radius");
            writer.setValue(radius.toString());
            writer.endNode();
        }
    }

    protected void writeRadius(Long radius, JsonObject object) {
        if (radius != null) {
            object.addProperty("radius", (Number)radius);
        } else {
            object.add("radius", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeGeolocationPositioningType(String geolocationPositioningType, HierarchicalStreamWriter writer) {
        if (geolocationPositioningType != null) {
            writer.startNode("GeolocationPositioningType");
            writer.setValue(geolocationPositioningType.toString());
            writer.endNode();
        }
    }

    protected void writeGeolocationPositioningType(String geolocationPositioningType, JsonObject object) {
        if (geolocationPositioningType != null) {
            object.addProperty("geolocation_positioning_type", geolocationPositioningType);
        } else {
            object.add("geolocation_positioning_type", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeLastGeolocationResponse(String lastGeolocationResponse, HierarchicalStreamWriter writer) {
        if (lastGeolocationResponse != null) {
            writer.startNode("LastGeolocationResponse");
            writer.setValue(lastGeolocationResponse.toString());
            writer.endNode();
        }
    }

    protected void writeLastGeolocationResponse(String lastGeolocationResponse, JsonObject object) {
        if (lastGeolocationResponse != null) {
            object.addProperty("last_geolocation_response", lastGeolocationResponse);
        } else {
            object.add("last_geolocation_response", (JsonElement)JsonNull.INSTANCE);
        }
    }

    protected void writeCause(String cause, HierarchicalStreamWriter writer) {
        if (cause != null) {
            writer.startNode("Cause");
            writer.setValue(cause.toString());
            writer.endNode();
        }
    }

    protected void writeCause(String cause, JsonObject object) {
        if (cause != null) {
            object.addProperty("cause", cause);
        } else {
            object.add("cause", (JsonElement)JsonNull.INSTANCE);
        }
    }
}

