/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.dao.entities.NotificationList;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class NotificationListConverter
extends AbstractConverter
implements JsonSerializer<NotificationList> {
    Integer page;
    Integer pageSize;
    Integer total;
    String pathUri;

    public NotificationListConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return NotificationList.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        NotificationList list = (NotificationList)object;
        writer.startNode("Notifications");
        for (Notification notification : list.getNotifications()) {
            context.convertAnother((Object)notification);
        }
        writer.endNode();
    }

    public JsonObject serialize(NotificationList ntfList, Type type, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        JsonArray array = new JsonArray();
        for (Notification cdr : ntfList.getNotifications()) {
            array.add(context.serialize((Object)cdr));
        }
        if (this.total != null && this.pageSize != null && this.page != null) {
            result.addProperty("page", (Number)this.page);
            result.addProperty("num_pages", (Number)this.getTotalPages());
            result.addProperty("page_size", (Number)this.pageSize);
            result.addProperty("total", (Number)this.total);
            result.addProperty("start", this.getFirstIndex());
            result.addProperty("end", this.getLastIndex(ntfList));
            result.addProperty("uri", this.pathUri);
            result.addProperty("first_page_uri", this.getFirstPageUri());
            result.addProperty("previous_page_uri", this.getPreviousPageUri());
            result.addProperty("next_page_uri", this.getNextPageUri(ntfList));
            result.addProperty("last_page_uri", this.getLastPageUri());
        }
        result.add("notifications", (JsonElement)array);
        return result;
    }

    private int getTotalPages() {
        return this.total / this.pageSize;
    }

    private String getFirstIndex() {
        return String.valueOf(this.page * this.pageSize);
    }

    private String getLastIndex(NotificationList list) {
        return String.valueOf(this.page.intValue() == this.getTotalPages() ? this.page * this.pageSize + list.getNotifications().size() : this.pageSize - 1 + this.page * this.pageSize);
    }

    private String getFirstPageUri() {
        return this.pathUri + "?Page=0&PageSize=" + this.pageSize;
    }

    private String getPreviousPageUri() {
        return this.page == 0 ? "null" : this.pathUri + "?Page=" + (this.page - 1) + "&PageSize=" + this.pageSize;
    }

    private String getNextPageUri(NotificationList list) {
        String lastSid = this.page.intValue() == this.getTotalPages() ? "null" : ((Notification)list.getNotifications().get(this.pageSize - 1)).getSid().toString();
        return this.page.intValue() == this.getTotalPages() ? "null" : this.pathUri + "?Page=" + (this.page + 1) + "&PageSize=" + this.pageSize + "&AfterSid=" + lastSid;
    }

    private String getLastPageUri() {
        return this.pathUri + "?Page=" + this.getTotalPages() + "&PageSize=" + this.pageSize;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setCount(Integer count) {
        this.total = count;
    }

    public void setPathUri(String pathUri) {
        this.pathUri = pathUri;
    }
}

