/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.entities.Transcription;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class TranscriptionConverter
extends AbstractConverter
implements JsonSerializer<Transcription> {
    public TranscriptionConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Transcription.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Transcription transcription = (Transcription)object;
        writer.startNode("Transcription");
        this.writeSid(transcription.getSid(), writer);
        this.writeDateCreated(transcription.getDateCreated(), writer);
        this.writeDateUpdated(transcription.getDateUpdated(), writer);
        this.writeAccountSid(transcription.getAccountSid(), writer);
        this.writeStatus(transcription.getStatus().toString(), writer);
        this.writeRecordingSid(transcription.getRecordingSid(), writer);
        this.writeDuration((double)transcription.getDuration(), writer);
        this.writeTranscriptionText(transcription.getTranscriptionText(), writer);
        this.writePrice(transcription.getPrice(), writer);
        this.writePriceUnit(transcription.getPriceUnit(), writer);
        this.writeUri(transcription.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Transcription transcription, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(transcription.getSid(), object);
        this.writeDateCreated(transcription.getDateCreated(), object);
        this.writeDateUpdated(transcription.getDateUpdated(), object);
        this.writeAccountSid(transcription.getAccountSid(), object);
        this.writeStatus(transcription.getStatus().toString(), object);
        this.writeRecordingSid(transcription.getRecordingSid(), object);
        this.writeDuration((double)transcription.getDuration(), object);
        this.writeTranscriptionText(transcription.getTranscriptionText(), object);
        this.writePrice(transcription.getPrice(), object);
        this.writePriceUnit(transcription.getPriceUnit(), object);
        this.writeUri(transcription.getUri(), object);
        return object;
    }

    private void writeRecordingSid(Sid recordingSid, HierarchicalStreamWriter writer) {
        writer.startNode("RecordingSid");
        writer.setValue(recordingSid.toString());
        writer.endNode();
    }

    private void writeRecordingSid(Sid recordingSid, JsonObject object) {
        object.addProperty("recording_sid", recordingSid.toString());
    }

    private void writeTranscriptionText(String transcriptionText, HierarchicalStreamWriter writer) {
        writer.startNode("TranscriptionText");
        if (transcriptionText != null) {
            writer.setValue(transcriptionText);
        }
        writer.endNode();
    }

    private void writeTranscriptionText(String transcriptionText, JsonObject object) {
        if (transcriptionText != null) {
            object.addProperty("transcription_text", transcriptionText);
        } else {
            object.add("transcription_text", (JsonElement)JsonNull.INSTANCE);
        }
    }
}

