/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.exceptionmappers;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.log4j.Logger;
import org.restcomm.connect.commons.exceptions.RestcommRuntimeException;
import org.restcomm.connect.dao.exceptions.AccountHierarchyDepthCrossed;
import org.restcomm.connect.http.exceptions.InsufficientPermission;
import org.restcomm.connect.http.exceptions.NotAuthenticated;
import org.restcomm.connect.http.exceptions.OperatedAccountMissing;
import org.restcomm.connect.http.exceptions.ResourceAccountMissmatch;

@Provider
public class RestcommRuntimeExceptionMapper
implements ExceptionMapper<RestcommRuntimeException> {
    static final Logger logger = Logger.getLogger((String)RestcommRuntimeExceptionMapper.class.getName());

    public Response toResponse(RestcommRuntimeException e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Converting response to a corresponding http status.");
        }
        if (e instanceof NotAuthenticated) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"Restcomm realm\"").build();
        }
        if (e instanceof InsufficientPermission) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (e instanceof OperatedAccountMissing) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (e instanceof ResourceAccountMissmatch) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (e instanceof AccountHierarchyDepthCrossed) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

