/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.http.AccountsEndpoint;

@Path(value="/Accounts.json")
@ThreadSafe
public final class AccountsJsonEndpoint
extends AccountsEndpoint {
    @Path(value="/{accountSid}")
    @GET
    public Response getAccountAsJson(@PathParam(value="accountSid") String accountSid) {
        return this.getAccount(accountSid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{accountSid}")
    @OPTIONS
    public Response optionsAccount(@PathParam(value="accountSid") String accountSid) {
        return Response.ok().build();
    }

    @GET
    public Response getAccounts() {
        return this.getAccounts(MediaType.APPLICATION_JSON_TYPE);
    }

    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    public Response putAccount(MultivaluedMap<String, String> data) {
        return this.putAccount(data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{accountSid}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @POST
    public Response updateAccountAsJsonPost(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.updateAccount(accountSid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{accountSid}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @PUT
    public Response updateAccountAsJsonPut(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.updateAccount(accountSid, data, MediaType.APPLICATION_JSON_TYPE);
    }
}

