/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.ClientsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.dao.entities.ClientList;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.ClientConverter;
import org.restcomm.connect.http.converter.ClientListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;
import org.restcomm.connect.http.exceptions.PasswordTooWeak;
import org.restcomm.connect.identity.passwords.PasswordValidator;
import org.restcomm.connect.identity.passwords.PasswordValidatorFactory;

@NotThreadSafe
public abstract class ClientsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected ClientsDao dao;
    protected Gson gson;
    protected XStream xstream;
    protected AccountsDao accountsDao;

    @PostConstruct
    public void init() {
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.dao = storage.getClientsDao();
        this.accountsDao = storage.getAccountsDao();
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        ClientConverter converter = new ClientConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Client.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new ClientListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
    }

    private Client createFrom(Sid accountSid, MultivaluedMap<String, String> data) throws PasswordTooWeak {
        Client.Builder builder = Client.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.CLIENT);
        builder.setSid(sid);
        builder.setApiVersion(this.getApiVersion(data));
        builder.setFriendlyName(this.getFriendlyName((String)data.getFirst((Object)"Login"), data));
        builder.setAccountSid(accountSid);
        builder.setLogin((String)data.getFirst((Object)"Login"));
        String password = (String)data.getFirst((Object)"Password");
        PasswordValidator validator = PasswordValidatorFactory.createDefault();
        if (!validator.isStrongEnough(password)) {
            throw new PasswordTooWeak();
        }
        builder.setPassword(password);
        builder.setStatus(this.getStatus(data));
        URI voiceUrl = this.getUrl("VoiceUrl", data);
        if (voiceUrl != null && voiceUrl.toString().equals("")) {
            voiceUrl = null;
        }
        builder.setVoiceUrl(voiceUrl);
        String method = this.getMethod("VoiceMethod", data);
        if (method == null || method.isEmpty() || method.equals("")) {
            method = "POST";
        }
        builder.setVoiceMethod(method);
        builder.setVoiceFallbackUrl(this.getUrl("VoiceFallbackUrl", data));
        builder.setVoiceFallbackMethod(this.getMethod("VoiceFallbackMethod", data));
        if (data.containsKey((Object)"VoiceApplicationSid") && !StringUtils.isEmpty((String)((String)data.getFirst((Object)"VoiceApplicationSid")))) {
            builder.setVoiceApplicationSid(this.getSid("VoiceApplicationSid", data));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("/").append(this.getApiVersion(data)).append("/Accounts/").append(accountSid.toString()).append("/Clients/").append(sid.toString());
        builder.setUri(URI.create(buffer.toString()));
        if (data.containsKey((Object)"IsPushEnabled") && this.getBoolean("IsPushEnabled", data).booleanValue()) {
            builder.setPushClientIdentity(sid.toString());
        }
        return builder.build();
    }

    protected Response getClient(String accountSid, String sid, MediaType responseType) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Read:Clients");
        Client client = this.dao.getClient(new Sid(sid));
        if (client == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(operatedAccount, client.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)client);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)client), (String)"application/json").build();
        }
        return null;
    }

    protected Response getClients(String accountSid, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:Clients");
        List clients = this.dao.getClients(new Sid(accountSid));
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new ClientList(clients));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)clients), (String)"application/json").build();
        }
        return null;
    }

    private String getFriendlyName(String login, MultivaluedMap<String, String> data) {
        String friendlyName = login;
        if (data.containsKey((Object)"FriendlyName")) {
            friendlyName = (String)data.getFirst((Object)"FriendlyName");
        }
        return friendlyName;
    }

    private int getStatus(MultivaluedMap<String, String> data) {
        int status = 1;
        if (data.containsKey((Object)"Status")) {
            try {
                status = Integer.parseInt((String)data.getFirst((Object)"Status"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return status;
    }

    public Response putClient(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        Account account = this.accountsDao.getAccount(accountSid);
        this.secure(account, "RestComm:Create:Clients");
        try {
            this.validate(data);
        }
        catch (IllegalArgumentException | NullPointerException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        Client client = this.dao.getClient((String)data.getFirst((Object)"Login"), account.getOrganizationSid());
        if (client == null) {
            try {
                client = this.createFrom(new Sid(accountSid), data);
            }
            catch (PasswordTooWeak passwordTooWeak) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.buildErrorResponseBody("Password too weak", responseType)).type(responseType).build();
            }
            this.dao.addClient(client);
        } else if (!client.getAccountSid().toString().equals(accountSid)) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"A client with the same name was already created by another account. Please, choose a different name and try again.").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)client);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)client), (String)"application/json").build();
        }
        return null;
    }

    protected Response updateClient(String accountSid, String sid, MultivaluedMap<String, String> data, MediaType responseType) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Modify:Clients");
        Client client = this.dao.getClient(new Sid(sid));
        if (client == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(operatedAccount, client.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        try {
            this.dao.updateClient(this.update(client, data));
        }
        catch (PasswordTooWeak passwordTooWeak) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.buildErrorResponseBody("Password too weak", responseType)).type(responseType).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)client);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)client), (String)"application/json").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) throws RuntimeException {
        if (!data.containsKey((Object)"Login")) {
            throw new NullPointerException("Login can not be null.");
        }
        if (!data.containsKey((Object)"Password")) {
            throw new NullPointerException("Password can not be null.");
        }
        if (((String)data.getFirst((Object)"Login")).contains("@")) {
            throw new IllegalArgumentException("Login contains invalid character: @ " + (String)data.getFirst((Object)"Login"));
        }
    }

    private Client update(Client client, MultivaluedMap<String, String> data) throws PasswordTooWeak {
        URI uri;
        Client result = client;
        if (data.containsKey((Object)"FriendlyName")) {
            result = result.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
        }
        if (data.containsKey((Object)"Password")) {
            String password = (String)data.getFirst((Object)"Password");
            PasswordValidator validator = PasswordValidatorFactory.createDefault();
            if (!validator.isStrongEnough(password)) {
                throw new PasswordTooWeak();
            }
            result = result.setPassword(password);
        }
        if (data.containsKey((Object)"Status")) {
            result = result.setStatus(this.getStatus(data));
        }
        if (data.containsKey((Object)"VoiceUrl")) {
            uri = this.getUrl("VoiceUrl", data);
            result = result.setVoiceUrl(this.isEmpty(uri.toString()) ? null : uri);
        }
        if (data.containsKey((Object)"VoiceMethod")) {
            result = result.setVoiceMethod(this.getMethod("VoiceMethod", data));
        }
        if (data.containsKey((Object)"VoiceFallbackUrl")) {
            uri = this.getUrl("VoiceFallbackUrl", data);
            result = result.setVoiceFallbackUrl(this.isEmpty(uri.toString()) ? null : uri);
        }
        if (data.containsKey((Object)"VoiceFallbackMethod")) {
            result = result.setVoiceFallbackMethod(this.getMethod("VoiceFallbackMethod", data));
        }
        if (data.containsKey((Object)"VoiceApplicationSid")) {
            result = StringUtils.isEmpty((String)((String)data.getFirst((Object)"VoiceApplicationSid"))) ? result.setVoiceApplicationSid(null) : result.setVoiceApplicationSid(this.getSid("VoiceApplicationSid", data));
        }
        if (data.containsKey((Object)"IsPushEnabled") && this.getBoolean("IsPushEnabled", data).booleanValue()) {
            result.setPushClientIdentity(client.getSid().toString());
        }
        return result;
    }
}

