/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.entities.Geolocation;
import org.restcomm.connect.http.GeolocationEndpoint;

@Path(value="/Accounts/{accountSid}/Geolocation")
@ThreadSafe
public final class GeolocationXmlEndpoint
extends GeolocationEndpoint {
    @Path(value="/Immediate/{sid}.json")
    @DELETE
    public Response deleteImmediateGeolocationAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteGeolocation(accountSid, sid);
    }

    @Path(value="/Immediate/{sid}")
    @DELETE
    public Response deleteImmediateGeolocationAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteGeolocation(accountSid, sid);
    }

    @Path(value="/Immediate/{sid}.json")
    @GET
    public Response getImmediateGeolocationAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getGeolocation(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/Immediate/{sid}")
    @GET
    public Response getImmediateGeolocationAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getGeolocation(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Immediate.json")
    @POST
    public Response putImmediateGeolocationJsonPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.putGeolocation(accountSid, data, Geolocation.GeolocationType.Immediate, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/Immediate/{sid}.json")
    @POST
    public Response updateImmediateGeolocationAsJsonPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGeolocation(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/Immediate/{sid}.json")
    @PUT
    public Response updateImmediateGeolocationAsJsonPut(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGeolocation(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/Immediate")
    @POST
    public Response putImmediateGeolocationXmlPost(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putGeolocation(accountSid, data, Geolocation.GeolocationType.Immediate, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Immediate/{sid}")
    @POST
    public Response putImmediateGeolocationAsXmlPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGeolocation(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Immediate/{sid}")
    @PUT
    public Response updateImmediateGeolocationAsXmlPut(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGeolocation(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Notification/{sid}.json")
    @DELETE
    public Response deleteNotificationGeolocationAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteGeolocation(accountSid, sid);
    }

    @Path(value="/Notification/{sid}")
    @DELETE
    public Response deleteNotificationGeolocationAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteGeolocation(accountSid, sid);
    }

    @Path(value="/Notification/{sid}.json")
    @GET
    public Response getNotificationGeolocationAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getGeolocation(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/Notification/{sid}")
    @GET
    public Response getNotificationGeolocationAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getGeolocation(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Notification.json")
    @POST
    public Response putNotificationGeolocationJsonPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.putGeolocation(accountSid, data, Geolocation.GeolocationType.Notification, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/Notification/{sid}.json")
    @POST
    public Response updateNotificationGeolocationAsJsonPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGeolocation(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/Notification/{sid}.json")
    @PUT
    public Response updateNotificationGeolocationAsJsonPut(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGeolocation(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/Notification")
    @POST
    public Response putNotificationGeolocationXmlPost(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putGeolocation(accountSid, data, Geolocation.GeolocationType.Notification, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Notification/{sid}")
    @POST
    public Response putNotificationGeolocationAsXmlPost(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGeolocation(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/Notification/{sid}")
    @PUT
    public Response updateNotificationGeolocationAsXmlPut(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateGeolocation(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @GET
    public Response getGeolocationsAsXml(@PathParam(value="accountSid") String accountSid) {
        return this.getGeolocations(accountSid, MediaType.APPLICATION_XML_TYPE);
    }
}

