/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.OutgoingCallerId;
import org.restcomm.connect.http.OutgoingCallerIdsEndpoint;
import org.restcomm.connect.http.SecuredEndpoint;

@Path(value="/Accounts/{accountSid}/OutgoingCallerIds")
@ThreadSafe
public final class OutgoingCallerIdsXmlEndpoint
extends OutgoingCallerIdsEndpoint {
    private Response deleteOutgoingCallerId(String accountSid, String sid) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Delete:OutgoingCallerIds");
        OutgoingCallerId oci = this.dao.getOutgoingCallerId(new Sid(sid));
        if (oci != null) {
            this.secure(operatedAccount, String.valueOf(oci.getAccountSid()), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        }
        this.dao.removeOutgoingCallerId(new Sid(sid));
        return Response.ok().build();
    }

    @Path(value="/{sid}.json")
    @DELETE
    public Response deleteOutgoingCallerIdAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteOutgoingCallerId(accountSid, sid);
    }

    @Path(value="/{sid}")
    @DELETE
    public Response deleteOutgoingCallerIdAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.deleteOutgoingCallerId(accountSid, sid);
    }

    @Path(value="/{sid}.json")
    @GET
    public Response getCallerIdAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getCallerId(accountSid, sid, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @GET
    public Response getCallerIdAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid) {
        return this.getCallerId(accountSid, sid, MediaType.APPLICATION_XML_TYPE);
    }

    @GET
    public Response getCallerIds(@PathParam(value="accountSid") String accountSid) {
        return this.getCallerIds(accountSid, MediaType.APPLICATION_XML_TYPE);
    }

    @POST
    public Response putOutgoingCallerId(@PathParam(value="accountSid") String accountSid, MultivaluedMap<String, String> data) {
        return this.putOutgoingCallerId(accountSid, data, MediaType.APPLICATION_XML_TYPE);
    }

    @Path(value="/{sid}.json")
    @PUT
    public Response updateOutgoingCallerIdAsJson(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateOutgoingCallerId(accountSid, sid, data, MediaType.APPLICATION_JSON_TYPE);
    }

    @Path(value="/{sid}")
    @PUT
    public Response updateOutgoingCallerIdAsXml(@PathParam(value="accountSid") String accountSid, @PathParam(value="sid") String sid, MultivaluedMap<String, String> data) {
        return this.updateOutgoingCallerId(accountSid, sid, data, MediaType.APPLICATION_XML_TYPE);
    }
}

