/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.File;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.amazonS3.RecordingSecurityLevel;
import org.restcomm.connect.commons.amazonS3.S3AccessTool;
import org.restcomm.connect.commons.annotations.concurrency.NotThreadSafe;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.RecordingsDao;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.Recording;
import org.restcomm.connect.dao.entities.RecordingFilter;
import org.restcomm.connect.dao.entities.RecordingList;
import org.restcomm.connect.dao.entities.RestCommResponse;
import org.restcomm.connect.http.SecuredEndpoint;
import org.restcomm.connect.http.converter.RecordingConverter;
import org.restcomm.connect.http.converter.RecordingListConverter;
import org.restcomm.connect.http.converter.RestCommResponseConverter;

@NotThreadSafe
public abstract class RecordingsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected RecordingsDao dao;
    protected Gson gson;
    protected XStream xstream;
    protected S3AccessTool s3AccessTool;
    protected RecordingSecurityLevel securityLevel = RecordingSecurityLevel.SECURE;
    protected RecordingListConverter listConverter;
    protected String instanceId;

    @PostConstruct
    public void init() {
        boolean amazonS3Enabled;
        DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        Configuration amazonS3Configuration = this.configuration.subset("amazon-s3");
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        this.dao = storage.getRecordingsDao();
        RecordingConverter converter = new RecordingConverter(this.configuration);
        this.listConverter = new RecordingListConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Recording.class, (Object)converter);
        builder.registerTypeAdapter(RecordingList.class, (Object)this.listConverter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RecordingListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        if (!amazonS3Configuration.isEmpty() && (amazonS3Enabled = amazonS3Configuration.getBoolean("enabled"))) {
            String accessKey = amazonS3Configuration.getString("access-key");
            String securityKey = amazonS3Configuration.getString("security-key");
            String bucketName = amazonS3Configuration.getString("bucket-name");
            String bucketFolder = amazonS3Configuration.getString("folder");
            boolean reducedRedundancy = amazonS3Configuration.getBoolean("reduced-redundancy");
            int minutesToRetainPublicUrl = amazonS3Configuration.getInt("minutes-to-retain-public-url", 10);
            boolean removeOriginalFile = amazonS3Configuration.getBoolean("remove-original-file");
            String bucketRegion = amazonS3Configuration.getString("bucket-region");
            boolean testing = amazonS3Configuration.getBoolean("testing", false);
            String testingUrl = amazonS3Configuration.getString("testing-url", null);
            this.s3AccessTool = new S3AccessTool(accessKey, securityKey, bucketName, bucketFolder, reducedRedundancy, minutesToRetainPublicUrl, removeOriginalFile, bucketRegion, testing, testingUrl);
            this.securityLevel = RecordingSecurityLevel.valueOf((String)amazonS3Configuration.getString("security-level", "secure").toUpperCase());
            converter.setSecurityLevel(this.securityLevel);
        }
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
    }

    protected Response getRecording(String accountSid, String sid, MediaType responseType) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        this.secure(operatedAccount, "RestComm:Read:Recordings");
        Recording recording = this.dao.getRecording(new Sid(sid));
        if (recording == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(operatedAccount, recording.getAccountSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)recording), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)recording);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getRecordings(String accountSid, UriInfo info, MediaType responseType) {
        RecordingFilter filter;
        RecordingFilter filterForTotal;
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:Recordings");
        boolean localInstanceOnly = true;
        try {
            String localOnly = (String)info.getQueryParameters().getFirst((Object)"localOnly");
            if (localOnly != null && localOnly.equalsIgnoreCase("false")) {
                localInstanceOnly = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean querySubAccounts = false;
        String querySubAccountsParam = (String)info.getQueryParameters().getFirst((Object)"SubAccounts");
        if (querySubAccountsParam != null && querySubAccountsParam.equalsIgnoreCase("true")) {
            querySubAccounts = true;
        }
        String pageSize = (String)info.getQueryParameters().getFirst((Object)"PageSize");
        String page = (String)info.getQueryParameters().getFirst((Object)"Page");
        String startTime = (String)info.getQueryParameters().getFirst((Object)"StartTime");
        String endTime = (String)info.getQueryParameters().getFirst((Object)"EndTime");
        String callSid = (String)info.getQueryParameters().getFirst((Object)"CallSid");
        if (pageSize == null) {
            pageSize = "50";
        }
        if (page == null) {
            page = "0";
        }
        int limit = Integer.parseInt(pageSize);
        int offset = page.equals("0") ? 0 : (Integer.parseInt(page) - 1) * Integer.parseInt(pageSize) + Integer.parseInt(pageSize);
        ArrayList<String> ownerAccounts = null;
        if (querySubAccounts) {
            ownerAccounts = new ArrayList<String>();
            ownerAccounts.add(accountSid);
            ownerAccounts.addAll(this.accountsDao.getSubAccountSidsRecursive(new Sid(accountSid)));
        }
        try {
            filterForTotal = localInstanceOnly ? new RecordingFilter(accountSid, ownerAccounts, startTime, endTime, callSid, null, null) : new RecordingFilter(accountSid, ownerAccounts, startTime, endTime, callSid, null, null, this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int total = this.dao.getTotalRecording(filterForTotal);
        if (Integer.parseInt(page) > total / limit) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            filter = localInstanceOnly ? new RecordingFilter(accountSid, ownerAccounts, startTime, endTime, callSid, Integer.valueOf(limit), Integer.valueOf(offset)) : new RecordingFilter(accountSid, ownerAccounts, startTime, endTime, callSid, Integer.valueOf(limit), Integer.valueOf(offset), this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List cdrs = this.dao.getRecordings(filter);
        this.listConverter.setCount(total);
        this.listConverter.setPage(Integer.parseInt(page));
        this.listConverter.setPageSize(Integer.parseInt(pageSize));
        this.listConverter.setPathUri(info.getRequestUri().getPath());
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new RecordingList(cdrs));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new RecordingList(cdrs)), (String)"application/json").build();
        }
        return null;
    }

    protected Response getRecordingsByCall(String accountSid, String callSid, MediaType responseType) {
        this.secure(this.accountsDao.getAccount(accountSid), "RestComm:Read:Recordings");
        List recordings = this.dao.getRecordingsByCall(new Sid(callSid));
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)recordings), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new RecordingList(recordings));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getRecordingWav(String accountSid, String sid) {
        Account operatedAccount = this.accountsDao.getAccount(accountSid);
        Recording recording = this.dao.getRecording(new Sid(sid));
        if (recording == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Recording with SID: " + sid + ", was not found"));
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        URI recordingUri = null;
        try {
            File recordingFile;
            if (recording.getS3Uri() != null) {
                recordingUri = this.s3AccessTool.getPublicUrl(recording.getSid() + ".wav");
                if (this.securityLevel.equals((Object)RecordingSecurityLevel.REDIRECT)) {
                    return Response.temporaryRedirect((URI)recordingUri).build();
                }
                String contentType = recordingUri.toURL().openConnection().getContentType();
                if (contentType == null || contentType.isEmpty()) {
                    contentType = "audio/x-wav";
                }
                return Response.ok((Object)recordingUri.toURL().openStream(), (String)contentType).build();
            }
            String path = this.configuration.getString("recordings-path");
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if ((recordingFile = new File(URI.create(path = path + sid.toString() + ".wav"))).exists()) {
                return Response.ok((Object)recordingFile, (String)"audio/x-wav").build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)"Problem during preparation of Recording wav file link, ", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

